/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.organization.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.corporate.entity.Corporate;
import com.infinite.focus.server.corporate.service.CorporateService;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organization.dto.OrganizationDTO;
import com.infinite.focus.server.organization.request.ActiveDeactiveOrganizationRequest;
import com.infinite.focus.server.organization.request.CreateOrganizationAdminRequest;
import com.infinite.focus.server.organization.request.DeleteOrganizationRequest;
import com.infinite.focus.server.organization.request.EditOrganizationRequest;
import com.infinite.focus.server.organization.request.GetOrganizationsRequest;
import com.infinite.focus.server.organization.service.OrganizationService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.parent.entity.Parent;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.utils.AppUtils;
import java.io.IOException;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/organization"})
public class OrganizationController {
    private final AuthService authService;
    private final OrganizationService organizationService;
    private final CorporateService corporateService;
    private final OrganizationAdminService organizationAdminService;
    private final MessageService messageService;

    public OrganizationController(AuthService authService, OrganizationService organizationService, CorporateService corporateService, OrganizationAdminService organizationAdminService, MessageService messageService) {
        this.authService = authService;
        this.organizationService = organizationService;
        this.corporateService = corporateService;
        this.organizationAdminService = organizationAdminService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/get/active/organizations"})
    @ResponseBody
    public ResponseEntity<Page<OrganizationDTO>> getActiveOrganizations(@RequestHeader(value="Authorization") String token, @RequestBody GetOrganizationsRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.organizationService.getActiveOrganizations(request), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/inactive/organizations"})
    @ResponseBody
    public ResponseEntity<Page<OrganizationDTO>> getInactiveOrganizations(@RequestHeader(value="Authorization") String token, @RequestBody GetOrganizationsRequest request) {
        this.authService.isAdmin(token);
        return new ResponseEntity((Object)this.organizationService.getInactiveOrganizations(request), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/active-deactive/large-organization"})
    public ResponseEntity<Message> activeDeactiveLargeOrganization(@RequestHeader(value="Authorization") String token, @RequestBody ActiveDeactiveOrganizationRequest request) throws IOException {
        this.authService.isAdmin(token);
        District district = this.organizationService.activeDeactiveLargeOrganization(request.getOrganization_id(), request.isActive());
        Message message = null;
        message = district.isActive() ? new Message(this.messageService.getMessage("the.large.organization.is.activated")) : new Message(this.messageService.getMessage("the.large.organization.is.deactivated"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/active-deactive/organization"})
    public ResponseEntity<Message> activeDeactiveOrganization(@RequestHeader(value="Authorization") String token, @RequestBody ActiveDeactiveOrganizationRequest request) throws IOException {
        this.authService.isAdmin(token);
        School school = this.organizationService.activeDeactiveOrganization(request.getOrganization_id(), request.isActive());
        Message message = null;
        message = school.isActive() ? new Message(this.messageService.getMessage("the.organization.is.activated")) : new Message(this.messageService.getMessage("the.organization.is.deactivated"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/active-deactive"})
    public ResponseEntity<Message> activeDeactive(@RequestHeader(value="Authorization") String token, @RequestBody ActiveDeactiveOrganizationRequest request) throws IOException {
        this.authService.isAdmin(token);
        if (request.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.organizationService.activeDeactiveLargeOrganization(request.getOrganization_id(), request.isActive());
            Message message = null;
            message = district.isActive() ? new Message(this.messageService.getMessage("the.large.organization.is.activated")) : new Message(this.messageService.getMessage("the.large.organization.is.deactivated"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            School school = this.organizationService.activeDeactiveOrganization(request.getOrganization_id(), request.isActive());
            Message message = null;
            message = school.isActive() ? new Message(this.messageService.getMessage("the.organization.is.deactivated")) : new Message(this.messageService.getMessage("the.organization.is.deactivated"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        Message message = new Message(this.messageService.getMessage("the.organization.type.is.not.found"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/create-organization-admin"})
    public ResponseEntity<Message> createOrganizationAdmin(@RequestHeader(value="Authorization") String token, @RequestBody CreateOrganizationAdminRequest request) throws IOException {
        this.authService.isAuthenticated(token);
        District district = this.authService.getDistrictByToken(token);
        List schools = this.authService.getSchoolByToken(token);
        School school = null;
        if (!AppUtils.isNullOrEmpty((List)schools)) {
            school = schools.stream().filter(item -> item.getSchool_id() == request.getOrganization_id()).findFirst().orElse(null);
        }
        Corporate corporate = this.authService.getCorporateByToken(token);
        Parent parent = this.authService.getParentByToken(token);
        if (AppUtils.isNullOrEmpty((String)request.getFirst_name())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.first.name.should.not.empty.or.null"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getLast_name())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.last.name.should.not.empty.or.null"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.email.should.not.empty.or.null"));
        }
        if (!AppUtils.isValidateEmail((String)request.getEmail())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.email.should.a.valid.email.address"));
        }
        if (district != null) {
            OrganizationAdmin organizationAdmin = this.organizationAdminService.createOrganizationAdmin(request.getFirst_name(), request.getLast_name(), request.getEmail(), OrganizationType.LARGE_ORGANIZATION, district.getDistrict_id(), null, district.getCity(), district.getState());
            Message message = null;
            message = organizationAdmin != null ? new Message(this.messageService.getMessage("the.admin.is.created")) : new Message(this.messageService.getMessage("the.admin.is.not.created"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (school != null) {
            OrganizationAdmin organizationAdmin = this.organizationAdminService.createOrganizationAdmin(request.getFirst_name(), request.getLast_name(), request.getEmail(), OrganizationType.ORGANIZATION, school.getSchool_id(), school.getAddress(), null, null);
            Message message = null;
            message = organizationAdmin != null ? new Message(this.messageService.getMessage("the.admin.is.created")) : new Message(this.messageService.getMessage("the.admin.is.not.created"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (corporate != null) {
            OrganizationAdmin organizationAdmin = this.organizationAdminService.createOrganizationAdmin(request.getFirst_name(), request.getLast_name(), request.getEmail(), OrganizationType.CORPORATE, corporate.getCorporate_id(), corporate.getAddress(), null, null);
            Message message = null;
            message = organizationAdmin != null ? new Message(this.messageService.getMessage("the.admin.is.created")) : new Message(this.messageService.getMessage("the.admin.is.not.created"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (parent != null) {
            OrganizationAdmin organizationAdmin = this.organizationAdminService.createOrganizationAdmin(request.getFirst_name(), request.getLast_name(), request.getEmail(), OrganizationType.PARENT, parent.getParent_id(), null, parent.getCity(), parent.getState());
            Message message = null;
            message = organizationAdmin != null ? new Message(this.messageService.getMessage("the.admin.is.created")) : new Message(this.messageService.getMessage("the.admin.is.not.created"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        Message message = new Message(this.messageService.getMessage("the.organization.type.is.not.found"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/edit"})
    public ResponseEntity<Message> edit(@RequestHeader(value="Authorization") String token, @RequestBody EditOrganizationRequest request) throws IOException {
        this.authService.isAdmin(token);
        if (request.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.organizationService.editLargeOrganization(request.getOrganization_id(), request.getName_of_organization(), request.getFocus_on(), request.getEmail(), request.getCity(), request.getState(), request.getNumber_of_youth(), request.getLicence_key_expiry_date());
            Message message = null;
            message = district != null ? new Message(this.messageService.getMessage("the.large.organization.is.edited")) : new Message(this.messageService.getMessage("the.large.organization.is.not.edited"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            School school = this.organizationService.editOrganization(request.getOrganization_id(), request.getName_of_organization(), request.getFocus_on(), request.getEmail(), request.getAddress(), request.getNumber_of_youth(), request.getLicence_key_expiry_date());
            Message message = null;
            message = school != null ? new Message(this.messageService.getMessage("the.organization.is.edited")) : new Message(this.messageService.getMessage("the.organization.is.not.edited"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.CORPORATE)) {
            Corporate corporate = this.corporateService.editCorporate(request.getOrganization_id(), request.getName_of_organization(), request.getFocus_on(), request.getEmail(), request.getAddress(), request.getNumber_of_youth(), request.getLicence_key_expiry_date());
            Message message = null;
            message = corporate != null ? new Message(this.messageService.getMessage("the.corporate.is.edited")) : new Message(this.messageService.getMessage("the.corporate.is.not.edited"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        Message message = new Message(this.messageService.getMessage("the.organization.type.is.not.found"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<Message> delete(@RequestHeader(value="Authorization") String token, @RequestBody DeleteOrganizationRequest request) throws IOException {
        this.authService.isAdmin(token);
        if (request.getOrganization_type().equals((Object)OrganizationType.LARGE_ORGANIZATION)) {
            District district = this.organizationService.deleteLargeOrganization(request.getOrganization_id(), request.isDeleted());
            Message message = null;
            message = district.isDeleted() ? new Message(this.messageService.getMessage("the.large.organization.is.deleted")) : new Message(this.messageService.getMessage("the.large.organization.is.not.deleted"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.ORGANIZATION)) {
            School school = this.organizationService.deleteOrganization(request.getOrganization_id(), request.isDeleted());
            Message message = null;
            message = school.isDeleted() ? new Message(this.messageService.getMessage("the.organization.is.deleted")) : new Message(this.messageService.getMessage("the.organization.is.not.deleted"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        if (request.getOrganization_type().equals((Object)OrganizationType.CORPORATE)) {
            Corporate corporate = this.corporateService.deleteCorporate(request.getOrganization_id(), request.isDeleted(), false);
            Message message = null;
            message = corporate.isDeleted() ? new Message(this.messageService.getMessage("the.corporate.is.deleted")) : new Message(this.messageService.getMessage("the.corporate.is.not.deleted"));
            return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
        }
        Message message = new Message(this.messageService.getMessage("the.organization.type.is.not.found"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

