/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.postcategory.controller;

import com.infinite.focus.server.postcategory.dto.PostCategoryDTO;
import com.infinite.focus.server.postcategory.request.CreatePostCategoryRequest;
import com.infinite.focus.server.postcategory.request.GetPostCategoryListByPostIdsRequest;
import com.infinite.focus.server.postcategory.service.PostCategoryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/post-category"})
public class PostCategoryController {
    @Autowired
    private PostCategoryService postAndCategoryService;

    @PostMapping(value={"/create"})
    public ResponseEntity<List<PostCategoryDTO>> create(@RequestBody CreatePostCategoryRequest request) {
        return new ResponseEntity((Object)this.postAndCategoryService.create(request.getPost_id(), request.getCategory_ids()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/get-post-ids-by-category-ids"})
    public ResponseEntity<List<Long>> getPostIdsByCategoryIds(@RequestBody CreatePostCategoryRequest request) {
        return new ResponseEntity((Object)this.postAndCategoryService.getPostIdsByCategoryIds(request.getCategory_ids()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-post-category-list-by-post-ids"})
    public ResponseEntity<List<PostCategoryDTO>> getPostCategoryListByPostIds(@RequestBody GetPostCategoryListByPostIdsRequest request) {
        return new ResponseEntity((Object)this.postAndCategoryService.getPostCategoryListByPostIds(request.getPost_ids()), (HttpStatusCode)HttpStatus.OK);
    }
}

