/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosquestion.repository;

import com.infinite.focus.server.sosquestion.dto.SOSQuestionDTO;
import com.infinite.focus.server.sosquestion.model.ChoiceType;
import com.infinite.focus.server.sosquestion.repository.SOSQuestionRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class SOSQuestionRepositoryImpl
implements SOSQuestionRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static SOSQuestionDTO mapRow(ResultSet rs, int i) throws SQLException {
        return SOSQuestionDTO.builder().sos_question_id(rs.getLong("sos_question_id")).image(rs.getString("image")).question(rs.getString("question")).question_es(rs.getString("question_es")).active(rs.getBoolean("active")).choice_type(ChoiceType.valueOf((String)rs.getString("choice_type"))).build();
    }

    public SOSQuestionDTO create(String image, String question, String question_es, boolean active, ChoiceType choice_type) {
        String INSERT_SQL = "INSERT INTO sosquestion (image, question, question_es, active, choice_type, created_at, updated_at) VALUES (?,?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO sosquestion (image, question, question_es, active, choice_type, created_at, updated_at) VALUES (?,?,?,?,?,?,?)", 1);
            ps.setString(1, image);
            ps.setString(2, question);
            ps.setString(3, question_es);
            ps.setBoolean(4, active);
            ps.setString(5, choice_type.toString());
            ps.setTimestamp(6, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(7, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int sos_question_id = Objects.requireNonNull(holder.getKey()).intValue();
        return SOSQuestionDTO.builder().sos_question_id((long)sos_question_id).image(image).question(question).question_es(question_es).active(active).choice_type(choice_type).build();
    }

    public SOSQuestionDTO update(long sos_question_id, String image, String question, String question_es, boolean active, ChoiceType choice_type) {
        String SQL = "UPDATE sosquestion SET image = ?, question = ?, question_es = ?, active = ?, choice_type = ?, updated_at = ? WHERE sos_question_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE sosquestion SET image = ?, question = ?, question_es = ?, active = ?, choice_type = ?, updated_at = ? WHERE sos_question_id = ? ", new Object[]{image, question, question_es, active, choice_type.toString(), Timestamp.valueOf(LocalDateTime.now()), sos_question_id});
        if (updateCount == 1) {
            return this.findById(Long.valueOf(sos_question_id));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Not updated!!!");
    }

    public SOSQuestionDTO activeInactiveQuestion(long sos_question_id, boolean active) {
        String SQL = "UPDATE sosquestion SET active = ?, updated_at = ? WHERE sos_question_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE sosquestion SET active = ?, updated_at = ? WHERE sos_question_id = ? ", new Object[]{active, Timestamp.valueOf(LocalDateTime.now()), sos_question_id});
        if (updateCount == 1) {
            return this.findById(Long.valueOf(sos_question_id));
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Not updated!!!");
    }

    public SOSQuestionDTO findById(Long sos_question_id) {
        String SQL = "SELECT * FROM sosquestion WHERE sos_question_id = ?";
        return (SOSQuestionDTO)this.jdbcTemplate.queryForObject(SQL, SOSQuestionRepositoryImpl::mapRow, new Object[]{sos_question_id});
    }

    public Page<SOSQuestionDTO> findQuestionsByPage(Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM sosquestion ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, new Object[0], (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM sosquestion ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), new Object[0], SOSQuestionRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public Page<SOSQuestionDTO> findActiveQuestionsByPage(Pageable pageable) {
        String rowCountSql = "SELECT count(1) AS row_count FROM sosquestion WHERE active = true ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, new Object[0], (rs, rowNum) -> rs.getInt(1));
        StringBuilder querySql = new StringBuilder("SELECT * FROM sosquestion WHERE active = true ");
        for (Sort.Order order : pageable.getSort()) {
            System.out.println("Property: " + order.getProperty());
            System.out.println("Direction: " + order.getDirection());
            querySql.append("ORDER BY ").append(order.getProperty()).append(" ").append(order.getDirection()).append(" ");
        }
        querySql.append("LIMIT ").append(pageable.getPageSize()).append(" ").append("OFFSET ").append(pageable.getOffset());
        List demos = this.jdbcTemplate.query(querySql.toString(), new Object[0], SOSQuestionRepositoryImpl::mapRow);
        return new PageImpl(demos, pageable, total == null ? 0L : (long)total.intValue());
    }

    public long getActiveQuestionsCount() {
        String rowCountSql = "SELECT count(1) AS row_count FROM sosquestion WHERE active = true ";
        Integer total = (Integer)this.jdbcTemplate.queryForObject(rowCountSql, new Object[0], (rs, rowNum) -> rs.getInt(1));
        if (total != null) {
            return total.longValue();
        }
        return 0L;
    }

    public List<SOSQuestionDTO> getSOSQuestionsByIds(Set<Long> sos_question_ids) {
        if (AppUtils.isNullOrEmpty(sos_question_ids)) {
            return new ArrayList<SOSQuestionDTO>();
        }
        String inSql = String.join((CharSequence)",", Collections.nCopies(sos_question_ids.size(), "?"));
        String SQL = "SELECT * FROM sosquestion WHERE sos_question_id IN(%s) ORDER BY sos_question_id ASC";
        List sosQuestionDTOS = this.jdbcTemplate.query(String.format(SQL, inSql), sos_question_ids.toArray(), SOSQuestionRepositoryImpl::mapRow);
        return sosQuestionDTOS;
    }
}

