/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.home.service;

import com.infinite.focus.server.client.MoodUpdateClient;
import com.infinite.focus.server.configuration.service.ConfigurationService;
import com.infinite.focus.server.dailyappreciation.entity.DailyAppreciation;
import com.infinite.focus.server.dailyappreciation.repository.DailyAppreciationRepository;
import com.infinite.focus.server.home.service.HomeService;
import com.infinite.focus.server.mood.wrapper.MoodUpdateAndStreak;
import com.infinite.focus.server.moodupdate.entity.MoodUpdate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class HomeServiceImpl
implements HomeService {
    @Autowired
    DailyAppreciationRepository dailyAppreciationRepository;
    @Autowired
    ConfigurationService configurationService;
    private final MoodUpdateClient moodUpdateClient;

    public HomeServiceImpl(MoodUpdateClient moodUpdateClient) {
        this.moodUpdateClient = moodUpdateClient;
    }

    public Page<DailyAppreciation> getAllDailyAppreciationForStudent(long student_id, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = this.dailyAppreciationRepository.findByStudent(student_id, (Pageable)paging);
        PageImpl pageWithFilteredData = new PageImpl(pagedResult.stream().map(dailyAppreciation -> {
            dailyAppreciation.setAppreciation_image(this.getAppreciationImageByAppreciationText(dailyAppreciation.getText()));
            return dailyAppreciation;
        }).collect(Collectors.toList()), pagedResult.getPageable(), pagedResult.getTotalElements());
        return pageWithFilteredData;
    }

    public MoodUpdateAndStreak createMoodUpdate(MoodUpdate request) {
        MoodUpdateAndStreak moodUpdate = this.moodUpdateClient.create(request);
        return moodUpdate;
    }

    public String getAppreciationImageByAppreciationText(String appreciationItem) {
        String appreciation_images_path = this.configurationService.getConfiguration().getAppreciation_images_path();
        switch (appreciationItem) {
            case "Family": {
                return appreciation_images_path + "Family.png";
            }
            case "Friends": {
                return appreciation_images_path + "Friends.png";
            }
            case "School": {
                return appreciation_images_path + "School.png";
            }
            case "Me": {
                return appreciation_images_path + "Me.png";
            }
            case "My Teacher": {
                return appreciation_images_path + "MyTeacher.png";
            }
            case "My Pets": {
                return appreciation_images_path + "MyPets.png";
            }
            case "A Teacher": {
                return appreciation_images_path + "MyTeacher.png";
            }
            case "Technology": {
                return appreciation_images_path + "Technology.png";
            }
            case "Math": {
                return appreciation_images_path + "Technology.png";
            }
            case "Music": {
                return appreciation_images_path + "Music.png";
            }
            case "Art": {
                return appreciation_images_path + "Art.png";
            }
        }
        return "";
    }
}

