/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.helper;

import com.infinite.focus.server.dashboard.model.LabelAndData;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.LabelsAndDatasets;
import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class LabelAndDataHelper {
    private static final String LABELS = "labels";
    private static final String DATASET = "dataset";
    private static final String LABEL = "label";
    private static final String DATA = "data";

    public static LabelsAndDatasets getLabelsAndDatasets(LinkedHashMap<String, List<LabelAndValue>> graphData) {
        LabelsAndDatasets labelsAndDatasets = new LabelsAndDatasets();
        LinkedHashSet<String> allLabels = new LinkedHashSet<String>();
        for (List<LabelAndValue> values : graphData.values()) {
            for (LabelAndValue v : values) {
                allLabels.add(v.getxLabel());
            }
        }
        labelsAndDatasets.setLabels(allLabels);
        LinkedList<LabelAndData> dataset = new LinkedList<LabelAndData>();
        for (String key : graphData.keySet()) {
            Map<String, Double> valueMap = graphData.get(key).stream().collect(Collectors.toMap(LabelAndValue::getxLabel, LabelAndValue::getValue));
            LinkedList<Double> data = new LinkedList<Double>();
            for (String label : allLabels) {
                Double value = valueMap.getOrDefault(label, 0.0);
                data.add(DigitUtils.formatDoubleInTwoDigit((Double)value));
            }
            dataset.add(new LabelAndData(key, data));
        }
        labelsAndDatasets.setDataset(dataset);
        return labelsAndDatasets;
    }

    public static LabelsAndDatasets getLabelsAndDatasets3(LinkedHashMap<String, List<LabelAndValue>> graphData, TimeLine timeLine, String language) {
        LabelsAndDatasets labelsAndDatasets = new LabelsAndDatasets();
        LinkedHashSet<String> unsortedLabels = new LinkedHashSet<String>();
        for (List<LabelAndValue> values : graphData.values()) {
            for (LabelAndValue v : values) {
                unsortedLabels.add(v.getxLabel());
            }
        }
        ArrayList<String> sortedLabels = new ArrayList<String>(unsortedLabels);
        if (timeLine == TimeLine.MONTHLY) {
            sortedLabels.sort(Comparator.comparing(label -> LabelAndDataHelper.parseMonthYear((String)label, (String)language)));
        } else if (timeLine == TimeLine.YEARLY) {
            sortedLabels.sort(Comparator.comparingInt(label -> Integer.parseInt(label.trim())));
        }
        labelsAndDatasets.setLabels(new LinkedHashSet(sortedLabels));
        LinkedList<LabelAndData> dataset = new LinkedList<LabelAndData>();
        for (String key : graphData.keySet()) {
            Map<String, Double> valueMap = graphData.get(key).stream().collect(Collectors.toMap(LabelAndValue::getxLabel, LabelAndValue::getValue));
            LinkedList<Double> data = new LinkedList<Double>();
            for (String label2 : sortedLabels) {
                Double value = valueMap.getOrDefault(label2, 0.0);
                data.add(DigitUtils.formatDoubleInTwoDigit((Double)value));
            }
            dataset.add(new LabelAndData(key, data));
        }
        labelsAndDatasets.setDataset(dataset);
        return labelsAndDatasets;
    }

    private static Date parseMonthYear(String label, String language) {
        try {
            if (language.equalsIgnoreCase("es")) {
                return new SimpleDateFormat("MMM yyyy", new Locale("es", "ES")).parse(label);
            }
            return new SimpleDateFormat("MMM yyyy", Locale.ENGLISH).parse(label);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse month label: " + label);
        }
    }

    public static LabelsAndDatasets getLabelsAndDatasets2(LinkedHashMap<String, List<LabelAndValue>> graphData) {
        LabelsAndDatasets result = new LabelsAndDatasets();
        LinkedHashSet<String> globalLabels = new LinkedHashSet<String>();
        for (List<LabelAndValue> values : graphData.values()) {
            if (!AppUtils.isNotNullOrEmpty(values)) continue;
            for (LabelAndValue lv : values) {
                globalLabels.add(lv.getxLabel());
            }
        }
        result.setLabels(globalLabels);
        LinkedList<LabelAndData> datasets = new LinkedList<LabelAndData>();
        for (Map.Entry<String, List<LabelAndValue>> entry : graphData.entrySet()) {
            String datasetName = entry.getKey();
            List<LabelAndValue> values = entry.getValue();
            HashMap<String, Double> valueMap = new HashMap<String, Double>();
            if (AppUtils.isNotNullOrEmpty(values)) {
                for (LabelAndValue lv : values) {
                    valueMap.put(lv.getxLabel(), DigitUtils.formatDoubleInTwoDigit((Double)lv.getValue()));
                }
            }
            LinkedList<Double> alignedData = new LinkedList<Double>();
            for (String label : globalLabels) {
                alignedData.add(valueMap.getOrDefault(label, 0.0));
            }
            datasets.add(new LabelAndData(datasetName, alignedData));
        }
        result.setDataset(datasets);
        return result;
    }

    public static Object getLabelsAndMultiDatasets(LinkedHashMap<String, LinkedHashMap<String, LinkedList<Double>>> graphData) {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        LinkedList dataset = new LinkedList();
        for (String demographic : graphData.keySet()) {
            LinkedList data = new LinkedList();
            for (String mood : graphData.get(demographic).keySet()) {
                labels.add(mood);
                LinkedList<Double> countAndScores = new LinkedList<Double>();
                countAndScores.add(graphData.get(demographic).get(mood).get(0));
                countAndScores.add(graphData.get(demographic).get(mood).get(1));
                data.add(countAndScores);
            }
            LinkedHashMap<String, Object> datasetItem = new LinkedHashMap<String, Object>();
            datasetItem.put("label", demographic);
            datasetItem.put("data", data);
            dataset.add(datasetItem);
        }
        LinkedHashMap<String, AbstractCollection> labelsAndDatasets = new LinkedHashMap<String, AbstractCollection>();
        labelsAndDatasets.put("labels", labels);
        labelsAndDatasets.put("dataset", dataset);
        return labelsAndDatasets;
    }

    public static List<Map<String, String>> cleanList(List<Map<String, String>> list) {
        if (list == null) {
            return new ArrayList<Map<String, String>>();
        }
        return list.stream().filter(map -> map != null && !map.isEmpty()).collect(Collectors.toList());
    }

    public static List<String> cleanStringList(List<String> list) {
        if (list == null) {
            return new ArrayList<String>();
        }
        return list.stream().filter(s -> s != null && !s.trim().isEmpty()).collect(Collectors.toList());
    }

    private <T> List<T> cleanCombineList(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return list.stream().filter(item -> {
            if (item == null) {
                return false;
            }
            if (item instanceof String) {
                return !((String)item).trim().isEmpty();
            }
            if (item instanceof Map) {
                return !((Map)item).isEmpty();
            }
            return true;
        }).collect(Collectors.toList());
    }
}

