/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.post.service;

import com.infinite.focus.server.category.dto.CategoryDTO;
import com.infinite.focus.server.category.request.GetCategoriesByIdsRequest;
import com.infinite.focus.server.client.CategoryClient;
import com.infinite.focus.server.client.ContentClient;
import com.infinite.focus.server.client.FavoriteClient;
import com.infinite.focus.server.client.MoodClient;
import com.infinite.focus.server.client.PostCategoryClient;
import com.infinite.focus.server.client.PostContentClient;
import com.infinite.focus.server.client.PostMoodClient;
import com.infinite.focus.server.client.PostStandardClient;
import com.infinite.focus.server.client.StandardClient;
import com.infinite.focus.server.client.VimeoClient;
import com.infinite.focus.server.content.dto.ContentDTO;
import com.infinite.focus.server.content.request.GetContentsByIdsRequest;
import com.infinite.focus.server.favorite.request.GetPostIdsByStudentIdRequest;
import com.infinite.focus.server.mood.dto.MoodDTO;
import com.infinite.focus.server.mood.request.GetMoodsByIdsRequest;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PageImplStreak;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.post.service.PostService;
import com.infinite.focus.server.post.wrapper.PostCategoryListAndCategoryListWrapper;
import com.infinite.focus.server.post.wrapper.PostContentListAndContentListWrapper;
import com.infinite.focus.server.post.wrapper.PostMoodListAndMoodListWrapper;
import com.infinite.focus.server.post.wrapper.PostStandardListAndStandardListWrapper;
import com.infinite.focus.server.post.wrapper.PostWrapper;
import com.infinite.focus.server.postcategory.dto.PostCategoryDTO;
import com.infinite.focus.server.postcategory.request.CreatePostCategoryRequest;
import com.infinite.focus.server.postcategory.request.GetPostCategoryListByPostIdsRequest;
import com.infinite.focus.server.postcontent.dto.PostContentDTO;
import com.infinite.focus.server.postcontent.request.CreatePostContentRequest;
import com.infinite.focus.server.postcontent.request.GetPostContentListByPostIdsRequest;
import com.infinite.focus.server.postmood.dto.PostMoodDTO;
import com.infinite.focus.server.postmood.request.CreatePostMoodRequest;
import com.infinite.focus.server.postmood.request.GetPostMoodListByPostIdsRequest;
import com.infinite.focus.server.poststandard.dto.PostStandardDTO;
import com.infinite.focus.server.poststandard.request.CreatePostStandardRequest;
import com.infinite.focus.server.poststandard.request.GetPostStandardListByPostIdsRequest;
import com.infinite.focus.server.standard.dto.StandardDTO;
import com.infinite.focus.server.studentstreak.service.resourcelibrary.StreakResourceLibraryService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.vimeo.model.VimeoVideoDetailsoEmbed;
import com.infinite.focus.server.vimeo.request.GetVimeoVideoDetailsByVideoUrlRequest;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PostServiceImpl
implements PostService {
    private final PostRepository postRepository;
    private final StreakResourceLibraryService streakResourceLibraryService;
    private final VimeoClient vimeoClient;
    private final MoodClient moodClient;
    private final StandardClient standardClient;
    private final PostCategoryClient postCategoryClient;
    private final PostContentClient postContentClient;
    private final PostMoodClient postMoodClient;
    private final ContentClient contentClient;
    private final PostStandardClient postStandardClient;
    private final FavoriteClient favoriteClient;
    private final CategoryClient categoryClient;

    public PostServiceImpl(PostRepository postRepository, StreakResourceLibraryService streakResourceLibraryService, VimeoClient vimeoClient, MoodClient moodClient, StandardClient standardClient, PostCategoryClient postCategoryClient, PostContentClient postContentClient, PostMoodClient postMoodClient, ContentClient contentClient, PostStandardClient postStandardClient, FavoriteClient favoriteClient, CategoryClient categoryClient) {
        this.postRepository = postRepository;
        this.streakResourceLibraryService = streakResourceLibraryService;
        this.vimeoClient = vimeoClient;
        this.moodClient = moodClient;
        this.standardClient = standardClient;
        this.postCategoryClient = postCategoryClient;
        this.postContentClient = postContentClient;
        this.postMoodClient = postMoodClient;
        this.contentClient = contentClient;
        this.postStandardClient = postStandardClient;
        this.favoriteClient = favoriteClient;
        this.categoryClient = categoryClient;
    }

    public Set<Long> getPostIdsByStandardId(long standard_id) {
        HashSet<Long> standard_ids = new HashSet<Long>();
        standard_ids.add(standard_id);
        return new HashSet<Long>(this.postStandardClient.getPostIdsByStandardIds(CreatePostStandardRequest.builder().standard_ids(standard_ids).post_id(0L).build()));
    }

    public Set<Long> getPostIdsByCategoryId(long category_id) {
        HashSet<Long> category_ids = new HashSet<Long>();
        category_ids.add(category_id);
        return new HashSet<Long>(this.postCategoryClient.getPostIdsByCategoryIds(CreatePostCategoryRequest.builder().category_ids(category_ids).post_id(0L).build()));
    }

    public List<PostDTO> get3RandomPost(long standard_id) {
        return this.postRepository.get3RandomPostByIds(this.getPostIdsByStandardId(standard_id));
    }

    public List<PostDTO> get3RandomPostByCategories(long standard_id, Set<Long> category_ids) {
        Set postIdsByStandardId = this.getPostIdsByStandardId(standard_id);
        Set postIdsByCategoryIds = this.postCategoryClient.getPostIdsByCategoryIds(CreatePostCategoryRequest.builder().category_ids(category_ids).post_id(0L).build()).stream().filter(postIdsByStandardId::contains).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        return this.postRepository.get3RandomPostByIds(postIdsByCategoryIds);
    }

    public List<PostDTO> get3RandomPostByCategoryId(long standard_id, long category_id) {
        Set postIdsByStandardId = this.getPostIdsByStandardId(standard_id);
        Set postIdsByCategoryId = this.getPostIdsByCategoryId(category_id).stream().filter(postIdsByStandardId::contains).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        return this.postRepository.get3RandomPostByIds(postIdsByCategoryId);
    }

    public PostDTO findByPostId(long post_id) {
        return this.postRepository.findById(post_id);
    }

    @Async
    public void deletePostsByIds(Set<Long> post_ids) {
        this.postRepository.deleteByIds(post_ids);
    }

    @Async
    public void deleteAllPosts() {
        this.postRepository.deleteAll();
    }

    public PostDTO create(PostType post_type, String post_title, String post_title_es, String post_description, String post_description_es, String post_cover_image_url, String post_cover_image_url_es, String post_video_url, String post_video_url_es, String key_words, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids) {
        return this.update(0L, post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, key_words, category_ids, content_ids, mood_ids, standard_ids);
    }

    public PostDTO update(long post_id, PostType post_type, String post_title, String post_title_es, String post_description, String post_description_es, String post_cover_image_url, String post_cover_image_url_es, String post_video_url, String post_video_url_es, String key_words, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids) {
        Long post_duration = null;
        String oEmbed_html = null;
        if (post_type.equals((Object)PostType.VIDEO) && AppUtils.isNotNullOrEmpty((String)post_video_url)) {
            post_video_url = post_video_url.trim();
            VimeoVideoDetailsoEmbed vimeoVideoDetailsoEmbed = this.vimeoClient.getVimeoVideoDetailsoEmbedByVideoUrl(GetVimeoVideoDetailsByVideoUrlRequest.builder().video_url(post_video_url).build());
            if (vimeoVideoDetailsoEmbed != null) {
                post_cover_image_url = vimeoVideoDetailsoEmbed.getThumbnail_url();
                post_duration = vimeoVideoDetailsoEmbed.getDuration();
                oEmbed_html = vimeoVideoDetailsoEmbed.getHtml();
            } else {
                post_cover_image_url = null;
            }
        } else {
            post_video_url = null;
        }
        Long post_duration_es = null;
        String oEmbed_html_es = null;
        if (post_type.equals((Object)PostType.VIDEO) && AppUtils.isNotNullOrEmpty((String)post_video_url_es)) {
            post_video_url_es = post_video_url_es.trim();
            VimeoVideoDetailsoEmbed vimeoVideoDetailsoEmbed_es = this.vimeoClient.getVimeoVideoDetailsoEmbedByVideoUrl(GetVimeoVideoDetailsByVideoUrlRequest.builder().video_url(post_video_url_es).build());
            if (vimeoVideoDetailsoEmbed_es != null) {
                post_cover_image_url_es = vimeoVideoDetailsoEmbed_es.getThumbnail_url();
                post_duration_es = vimeoVideoDetailsoEmbed_es.getDuration();
                oEmbed_html_es = vimeoVideoDetailsoEmbed_es.getHtml();
            } else {
                post_cover_image_url_es = null;
            }
        } else {
            post_video_url_es = null;
        }
        PostDTO postDTO = null;
        postDTO = post_id > 0L ? this.postRepository.update(post_id, post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration, post_duration_es, oEmbed_html, oEmbed_html_es, key_words) : this.postRepository.create(post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, post_duration, post_duration_es, oEmbed_html, oEmbed_html_es, key_words);
        List postAndCategoryDTOS = this.postCategoryClient.create(CreatePostCategoryRequest.builder().post_id(postDTO.getPost_id()).category_ids(category_ids).build());
        List postAndContentDTOS = this.postContentClient.create(CreatePostContentRequest.builder().post_id(postDTO.getPost_id()).content_ids(content_ids).build());
        List postAndMoodDTOS = this.postMoodClient.create(CreatePostMoodRequest.builder().post_id(postDTO.getPost_id()).mood_ids(mood_ids).build());
        List postAndStandardDTOS = this.postStandardClient.create(CreatePostStandardRequest.builder().post_id(postDTO.getPost_id()).standard_ids(standard_ids).build());
        return postDTO;
    }

    public Page<PostDTO> getPosts(long student_id, String post_title, Set<String> post_types, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids, boolean showOnlyFavorites, Set<Long> last_post_ids, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        HashSet<Long> postIdsByCategoryIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(category_ids) && AppUtils.isNullOrEmpty(postIdsByCategoryIds = new HashSet(this.postCategoryClient.getPostIdsByCategoryIds(CreatePostCategoryRequest.builder().category_ids(category_ids).post_id(0L).build())))) {
            postIdsByCategoryIds.add(-1L);
        }
        HashSet<Long> postIdsByContentIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(content_ids) && AppUtils.isNullOrEmpty(postIdsByContentIds = new HashSet(this.postContentClient.getPostIdsByContentIds(CreatePostContentRequest.builder().content_ids(content_ids).post_id(0L).build())))) {
            postIdsByContentIds.add(-1L);
        }
        HashSet<Long> postIdsByMoodIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(mood_ids) && AppUtils.isNullOrEmpty(postIdsByMoodIds = new HashSet(this.postMoodClient.getPostIdsByMoodIds(CreatePostMoodRequest.builder().mood_ids(mood_ids).post_id(0L).build())))) {
            postIdsByMoodIds.add(-1L);
        }
        HashSet<Long> postIdsByStandardIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(standard_ids) && AppUtils.isNullOrEmpty(postIdsByStandardIds = new HashSet(this.postStandardClient.getPostIdsByStandardIds(CreatePostStandardRequest.builder().standard_ids(standard_ids).post_id(0L).build())))) {
            postIdsByStandardIds.add(-1L);
        }
        HashSet<Long> postIdsByFavorite = new HashSet<Long>();
        if (showOnlyFavorites && student_id > 0L && AppUtils.isNullOrEmpty(postIdsByFavorite = new HashSet(this.favoriteClient.getPostIdsByStudentId(GetPostIdsByStudentIdRequest.builder().student_id(student_id).build())))) {
            postIdsByFavorite.add(-1L);
        }
        PageRequest pageable = null;
        pageable = last_post_ids != null ? PageRequest.of((int)pageNo, (int)pageSize) : PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pageByPostTitle = this.postRepository.findPageByPostTitle(post_title, post_types, postIdsByCategoryIds, postIdsByContentIds, postIdsByMoodIds, postIdsByStandardIds, postIdsByFavorite, last_post_ids, (Pageable)pageable);
        if (!AppUtils.isNullOrEmpty((List)pageByPostTitle.getContent())) {
            Set post_ids = pageByPostTitle.stream().map(PostDTO::getPost_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            PostCategoryListAndCategoryListWrapper categories = this.getPostCategoryListAndCategoryListByPostIds(post_ids);
            PostContentListAndContentListWrapper contents = this.getPostContentListAndContentListByPostIds(post_ids);
            PostMoodListAndMoodListWrapper moods = this.getPostMoodListAndMoodListByPostIds(post_ids);
            PostStandardListAndStandardListWrapper standards = this.getPostStandardListAndStandardListByPostIds(post_ids);
            if (student_id > 0L && !showOnlyFavorites) {
                postIdsByFavorite = new HashSet(this.favoriteClient.getPostIdsByStudentId(GetPostIdsByStudentIdRequest.builder().student_id(student_id).build()));
            }
            for (PostDTO post : pageByPostTitle.getContent()) {
                this.setCategories(post, categories);
                this.setContents(post, contents);
                this.setMoods(post, moods);
                this.setStandards(post, standards);
                if (student_id <= 0L) continue;
                post.setFavorite(postIdsByFavorite.contains(post.getPost_id()));
            }
        }
        PageImplStreak pagedResult = new PageImplStreak(pageByPostTitle.getContent(), (Pageable)pageable, pageByPostTitle.getTotalElements(), student_id > 0L ? this.streakResourceLibraryService.addStreakResourceLibrary(student_id) : null);
        return pagedResult;
    }

    public Page<PostWrapper> getResourceLibrary(long student_id, String post_title, Set<String> post_types, Set<Long> category_ids, Set<Long> content_ids, Set<Long> mood_ids, Set<Long> standard_ids, boolean showOnlyFavorites, Set<Long> last_post_ids, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        HashSet<Long> postIdsByCategoryIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(category_ids) && AppUtils.isNullOrEmpty(postIdsByCategoryIds = new HashSet(this.postCategoryClient.getPostIdsByCategoryIds(CreatePostCategoryRequest.builder().category_ids(category_ids).post_id(0L).build())))) {
            postIdsByCategoryIds.add(-1L);
        }
        HashSet<Long> postIdsByContentIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(content_ids) && AppUtils.isNullOrEmpty(postIdsByContentIds = new HashSet(this.postContentClient.getPostIdsByContentIds(CreatePostContentRequest.builder().content_ids(content_ids).post_id(0L).build())))) {
            postIdsByContentIds.add(-1L);
        }
        HashSet<Long> postIdsByMoodIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(mood_ids) && AppUtils.isNullOrEmpty(postIdsByMoodIds = new HashSet(this.postMoodClient.getPostIdsByMoodIds(CreatePostMoodRequest.builder().mood_ids(mood_ids).post_id(0L).build())))) {
            postIdsByMoodIds.add(-1L);
        }
        HashSet<Long> postIdsByStandardIds = new HashSet<Long>();
        if (!AppUtils.isNullOrEmpty(standard_ids) && AppUtils.isNullOrEmpty(postIdsByStandardIds = new HashSet(this.postStandardClient.getPostIdsByStandardIds(CreatePostStandardRequest.builder().standard_ids(standard_ids).post_id(0L).build())))) {
            postIdsByStandardIds.add(-1L);
        }
        HashSet<Long> postIdsByFavorite = new HashSet<Long>();
        if (showOnlyFavorites && student_id > 0L && AppUtils.isNullOrEmpty(postIdsByFavorite = new HashSet(this.favoriteClient.getPostIdsByStudentId(GetPostIdsByStudentIdRequest.builder().student_id(student_id).build())))) {
            postIdsByFavorite.add(-1L);
        }
        PageRequest pageable = null;
        pageable = last_post_ids != null ? PageRequest.of((int)pageNo, (int)pageSize) : PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pageByPostTitle = this.postRepository.findPageByPostTitle(post_title, post_types, postIdsByCategoryIds, postIdsByContentIds, postIdsByMoodIds, postIdsByStandardIds, postIdsByFavorite, last_post_ids, (Pageable)pageable);
        if (!AppUtils.isNullOrEmpty((List)pageByPostTitle.getContent()) && student_id > 0L && !showOnlyFavorites) {
            postIdsByFavorite = new HashSet(this.favoriteClient.getPostIdsByStudentId(GetPostIdsByStudentIdRequest.builder().student_id(student_id).build()));
        }
        HashSet<Long> finalPostIdsByFavorite = postIdsByFavorite;
        PageImplStreak pagedResult = new PageImplStreak(pageByPostTitle.getContent().stream().map(p -> PostWrapper.builder().post_id(p.getPost_id()).post_title(p.getPost_title()).post_title_es(p.getPost_title_es()).post_duration(p.getPost_duration()).post_description(p.getPost_description()).post_cover_image_url(p.getPost_cover_image_url()).post_cover_image_url_es(p.getPost_cover_image_url_es()).post_duration(p.getPost_duration()).post_duration_es(p.getPost_duration_es()).post_video_url(p.getPost_video_url()).post_video_url_es(p.getPost_video_url_es()).oEmbed_html(p.getoEmbed_html()).oEmbed_html_es(p.getoEmbed_html_es()).deleted(p.isDeleted()).favorite(student_id > 0L ? finalPostIdsByFavorite.contains(p.getPost_id()) : p.isFavorite()).post_type(p.getPost_type()).key_words(p.getKey_words()).build()).collect(Collectors.toList()), (Pageable)pageable, pageByPostTitle.getTotalElements(), student_id > 0L ? this.streakResourceLibraryService.addStreakResourceLibrary(student_id) : null);
        return pagedResult;
    }

    public void updateoEmbed_htmlById(long id, String oEmbed_html) {
        this.postRepository.updateoEmbed_htmlById(id, oEmbed_html);
    }

    private PostCategoryListAndCategoryListWrapper getPostCategoryListAndCategoryListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostCategoryListAndCategoryListWrapper wrapper = new PostCategoryListAndCategoryListWrapper();
        wrapper.setPost_category_list(new HashSet(this.postCategoryClient.getPostCategoryListByPostIds(GetPostCategoryListByPostIdsRequest.builder().post_ids(post_ids).build())));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_category_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_category_list().stream().map(PostCategoryDTO::getCategory_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setCategory_list(new HashSet(this.categoryClient.getCategoriesByIds(GetCategoriesByIdsRequest.builder().ids(ids).build())));
        }
        return wrapper;
    }

    private PostContentListAndContentListWrapper getPostContentListAndContentListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostContentListAndContentListWrapper wrapper = new PostContentListAndContentListWrapper();
        wrapper.setPost_content_list(new HashSet(this.postContentClient.getPostContentListByPostIds(GetPostContentListByPostIdsRequest.builder().post_ids(post_ids).build())));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_content_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_content_list().stream().map(PostContentDTO::getContent_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setContent_list(new HashSet(this.contentClient.getContentsByIds(GetContentsByIdsRequest.builder().ids(ids).build())));
        }
        return wrapper;
    }

    private PostMoodListAndMoodListWrapper getPostMoodListAndMoodListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostMoodListAndMoodListWrapper wrapper = new PostMoodListAndMoodListWrapper();
        wrapper.setPost_mood_list(new HashSet(this.postMoodClient.getPostMoodListByPostIds(GetPostMoodListByPostIdsRequest.builder().post_ids(post_ids).build())));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_mood_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_mood_list().stream().map(PostMoodDTO::getMood_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setMood_list(new HashSet(this.moodClient.getMoodsByIds(GetMoodsByIdsRequest.builder().ids(ids).build())));
        }
        return wrapper;
    }

    private PostStandardListAndStandardListWrapper getPostStandardListAndStandardListByPostIds(Set<Long> post_ids) {
        Set ids;
        PostStandardListAndStandardListWrapper wrapper = new PostStandardListAndStandardListWrapper();
        wrapper.setPost_standard_list(new HashSet(this.postStandardClient.getPostStandardListByPostIds(GetPostStandardListByPostIdsRequest.builder().post_ids(post_ids).build())));
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_standard_list()) && !AppUtils.isNullOrEmpty((Set)(ids = (Set)wrapper.getPost_standard_list().stream().map(PostStandardDTO::getStandard_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            wrapper.setStandard_list(new HashSet(this.standardClient.getStandardsByIds(GetCategoriesByIdsRequest.builder().ids(ids).build())));
        }
        return wrapper;
    }

    private void setCategories(PostDTO post, PostCategoryListAndCategoryListWrapper wrapper) {
        Set categoryIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_category_list()) && !AppUtils.isNullOrEmpty((Set)(categoryIdsForPost = (Set)wrapper.getPost_category_list().stream().filter(postCategoryDTO -> postCategoryDTO.getPost_id() == post.getPost_id()).map(PostCategoryDTO::getCategory_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set categories = wrapper.getCategory_list().stream().filter(categoryDTO -> categoryIdsForPost.contains(categoryDTO.getCategory_id())).sorted(Comparator.comparingLong(CategoryDTO::getCategory_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setCategories(categories);
        }
    }

    private void setContents(PostDTO post, PostContentListAndContentListWrapper wrapper) {
        Set contentIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_content_list()) && !AppUtils.isNullOrEmpty((Set)(contentIdsForPost = (Set)wrapper.getPost_content_list().stream().filter(postContentDTO -> postContentDTO.getPost_id() == post.getPost_id()).map(PostContentDTO::getContent_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set contents = wrapper.getContent_list().stream().filter(contentDTO -> contentIdsForPost.contains(contentDTO.getContent_id())).sorted(Comparator.comparingLong(ContentDTO::getContent_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setContents(contents);
        }
    }

    private void setMoods(PostDTO post, PostMoodListAndMoodListWrapper wrapper) {
        Set moodIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_mood_list()) && !AppUtils.isNullOrEmpty((Set)(moodIdsForPost = (Set)wrapper.getPost_mood_list().stream().filter(postContentDTO -> postContentDTO.getPost_id() == post.getPost_id()).map(PostMoodDTO::getMood_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set moods = wrapper.getMood_list().stream().filter(moodDTO -> moodIdsForPost.contains(moodDTO.getMood_id())).sorted(Comparator.comparingLong(MoodDTO::getMood_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setMoods(moods);
        }
    }

    private void setStandards(PostDTO post, PostStandardListAndStandardListWrapper wrapper) {
        Set standardIdsForPost;
        if (!AppUtils.isNullOrEmpty((Set)wrapper.getPost_standard_list()) && !AppUtils.isNullOrEmpty((Set)(standardIdsForPost = (Set)wrapper.getPost_standard_list().stream().filter(postContentDTO -> postContentDTO.getPost_id() == post.getPost_id()).map(PostStandardDTO::getStandard_id).sorted().collect(Collectors.toCollection(LinkedHashSet::new))))) {
            Set standards = wrapper.getStandard_list().stream().filter(standardDTO -> standardIdsForPost.contains(standardDTO.getStandard_id())).sorted(Comparator.comparingLong(StandardDTO::getStandard_id)).collect(Collectors.toCollection(LinkedHashSet::new));
            post.setStandards(standards);
        }
    }
}

