/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.service.socioemotionalassessment;

import com.infinite.focus.server.activity.dto.ActivityDTO;
import com.infinite.focus.server.activity.repository.ActivityCriteriaRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.dashboard.helper.LabelAndDataHelper;
import com.infinite.focus.server.dashboard.model.LabelAndValue;
import com.infinite.focus.server.dashboard.model.LabelAndValueScore;
import com.infinite.focus.server.dashboard.model.LabelsAndDatasets;
import com.infinite.focus.server.dashboard.model.TimeLine;
import com.infinite.focus.server.dashboard.request.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.service.socioemotionalassessment.SocioEmotionalAssessmentService;
import com.infinite.focus.server.ethnicity.entity.Ethnicity;
import com.infinite.focus.server.ethnicity.repository.EthnicityRepository;
import com.infinite.focus.server.gender.entity.Gender;
import com.infinite.focus.server.gender.repository.GenderRepository;
import com.infinite.focus.server.grade.repository.GradeRepository;
import com.infinite.focus.server.grade.view.GradeView;
import com.infinite.focus.server.language.Language;
import com.infinite.focus.server.socioemotionaltestanswer.entity.SocioEmotionalTestAnswer;
import com.infinite.focus.server.socioemotionaltestanswer.repository.SocioEmotionalTestAnswerRepository;
import com.infinite.focus.server.socioemotionaltestquestion.entity.SocioEmotionalTestQuestion;
import com.infinite.focus.server.socioemotionaltestquestion.repository.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.socioemotionaltestquestionoption.entity.SocioEmotionalTestQuestionOption;
import com.infinite.focus.server.socioemotionaltestquestionoption.repository.SocioEmotionalTestQuestionOptionRepository;
import com.infinite.focus.server.socioemotionaltestresult.entity.SocioEmotionalTestResult;
import com.infinite.focus.server.socioemotionaltestresult.service.SocioEmotionalTestResultService;
import com.infinite.focus.server.student.repository.StudentCriteriaRepository;
import com.infinite.focus.server.student.service.StudentService;
import com.infinite.focus.server.test.wrapper.SocioEmotionalTestDataWrapper;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioEmotionalAssessmentServiceImpl
implements SocioEmotionalAssessmentService {
    @Autowired
    SocioEmotionalTestResultService socioEmotionalTestResultService;
    @Autowired
    ActivityService activityService;
    @Autowired
    ActivityCriteriaRepository activityCriteriaRepository;
    @Autowired
    SocioEmotionalTestQuestionOptionRepository socioEmotionalTestQuestionOptionRepository;
    @Autowired
    SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository;
    @Autowired
    SocioEmotionalTestAnswerRepository socioEmotionalTestAnswerRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StudentService studentService;
    @Autowired
    StudentCriteriaRepository studentCriteriaRepository;
    @Autowired
    GenderRepository genderRepository;
    @Autowired
    EthnicityRepository ethnicityRepository;
    String forwardSlash = "/";

    public LinkedHashMap<String, List<LabelAndValue>> getSELStrandsGraphData(GetDataDashBoardRequest request) {
        String graphType = String.valueOf(request.getGraphType());
        List student_ids = new ArrayList();
        student_ids = request.getFromDate() != null && request.getToDate() != null ? this.studentCriteriaRepository.getStudentIdsByDemographics(request, true, false) : this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        List socioEmotionalTestResultList = new ArrayList();
        socioEmotionalTestResultList = request.getFromDate() != null && request.getToDate() != null ? this.socioEmotionalTestResultService.getSocioEmotionalTestResultByStudentIds(new LinkedHashSet(student_ids), request.getFromDate(), request.getToDate()) : this.socioEmotionalTestResultService.getSocioEmotionalTestResultByStudentIds(student_ids, request.getTimeLine());
        LinkedHashMap testResultMap = "SEL_STRANDS".equals(graphType) ? this.socioEmotionalTestResultService.getSocioEmotionalTestResultMapByTimeLine2(request.getTimeLine(), socioEmotionalTestResultList, Language.getLanguage()) : ("SINGLE_DEMOGRAPHIC_COMPARISON".equals(graphType) ? this.socioEmotionalTestResultService.getSocioEmotionalTestResultMapByTimeLine4(request.getTimeLine(), socioEmotionalTestResultList, Language.getLanguage(), request.getFromDate(), request.getToDate()) : this.socioEmotionalTestResultService.getSocioEmotionalTestResultMapByTimeLine(request.getTimeLine(), socioEmotionalTestResultList, Language.getLanguage()));
        Long socio_emotional_test_question_type_id = request.getSocio_emotional_test_question_type_id();
        ArrayList<LabelAndValue> labelAndValues_en = new ArrayList<LabelAndValue>();
        ArrayList<LabelAndValue> labelAndValues_es = new ArrayList<LabelAndValue>();
        if (socio_emotional_test_question_type_id == null) {
            for (String[] keys : testResultMap.keySet()) {
                List values = (List)testResultMap.get(keys);
                if (!values.isEmpty()) {
                    double score = 0.0;
                    for (SocioEmotionalTestResult test : values) {
                        System.out.println("test id " + test.getSocio_emotional_test_result_id() + " test score " + test.getScore() + " score = " + (score += (double)test.getScore()));
                    }
                    double avgScore = score / (double)values.size();
                    System.out.println("Key" + keys[0] + "avgScore  " + avgScore + "  score = " + score + " size (count) = " + values.size());
                    double value = DigitUtils.formatDoubleInTwoDigit((Double)avgScore);
                    labelAndValues_en.add(new LabelAndValue(keys[0], value));
                    if (!Language.isSpanish()) continue;
                    labelAndValues_es.add(new LabelAndValue(keys[1], value));
                    continue;
                }
                labelAndValues_en.add(new LabelAndValue(keys[0], 0.0));
                if (!Language.isSpanish()) continue;
                labelAndValues_es.add(new LabelAndValue(keys[1], 0.0));
            }
        } else {
            SocioEmotionalTestDataWrapper s = new SocioEmotionalTestDataWrapper();
            s.setOptions(this.socioEmotionalTestQuestionOptionRepository.findAll());
            s.setQuestions(this.socioEmotionalTestQuestionRepository.findBySocioEmotionalTestQuestionTypeId(socio_emotional_test_question_type_id));
            for (String[] keys : testResultMap.keySet()) {
                List values = (List)testResultMap.get(keys);
                if (!values.isEmpty()) {
                    double score = 0.0;
                    for (SocioEmotionalTestResult test : values) {
                        int total_score = 0;
                        List socioEmotionalTestAnswers = this.socioEmotionalTestAnswerRepository.findBySocioEmotionalTestResultId(Long.valueOf(test.getSocio_emotional_test_result_id()));
                        for (int q = 0; q < s.getQuestions().size(); ++q) {
                            SocioEmotionalTestQuestion socioEmotionalTestQuestion = (SocioEmotionalTestQuestion)s.getQuestions().get(q);
                            block5: for (int a = 0; a < socioEmotionalTestAnswers.size(); ++a) {
                                if (socioEmotionalTestQuestion.getSocio_emotional_test_question_id() != ((SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a)).getSocio_emotional_test_question_id()) continue;
                                SocioEmotionalTestAnswer socioEmotionalTestAnswer = (SocioEmotionalTestAnswer)socioEmotionalTestAnswers.get(a);
                                for (int o = 0; o < s.getOptions().size(); ++o) {
                                    if (socioEmotionalTestAnswer.getSocio_emotional_test_question_option_id() != ((SocioEmotionalTestQuestionOption)s.getOptions().get(o)).getSocio_emotional_test_question_option_id()) continue;
                                    SocioEmotionalTestQuestionOption socioEmotionalTestQuestionOption = (SocioEmotionalTestQuestionOption)s.getOptions().get(o);
                                    if (socioEmotionalTestQuestion.isReversed()) {
                                        System.out.println("score = " + socioEmotionalTestQuestionOption.getReverse_weight() + " total_score = " + (total_score += socioEmotionalTestQuestionOption.getReverse_weight()));
                                        continue block5;
                                    }
                                    System.out.println("score = " + socioEmotionalTestQuestionOption.getWeight() + " total_score = " + (total_score += socioEmotionalTestQuestionOption.getWeight()));
                                    continue block5;
                                }
                            }
                        }
                        System.out.println("test id " + test.getSocio_emotional_test_result_id() + "  score = " + (score += (double)total_score));
                    }
                    double avgScore = score / (double)values.size();
                    System.out.println("Key" + keys[0] + "avgScore  " + avgScore + "  score = " + score + " size (count) = " + values.size());
                    double value = DigitUtils.formatDoubleInTwoDigit((Double)avgScore);
                    labelAndValues_en.add(new LabelAndValue(keys[0], value));
                    if (!Language.isSpanish()) continue;
                    labelAndValues_es.add(new LabelAndValue(keys[1], value));
                    continue;
                }
                double value = DigitUtils.formatDoubleInTwoDigit((Double)0.0);
                labelAndValues_en.add(new LabelAndValue(keys[0], value));
                if (!Language.isSpanish()) continue;
                labelAndValues_es.add(new LabelAndValue(keys[1], value));
            }
        }
        LinkedHashMap<String, List<LabelAndValue>> graphData = new LinkedHashMap<String, List<LabelAndValue>>();
        graphData.put("en", labelAndValues_en);
        if (Language.isSpanish()) {
            graphData.put("es", labelAndValues_es);
        }
        return graphData;
    }

    public Object getSingleDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, List> graphData_en = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> graphData_es = new LinkedHashMap<String, List>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            for (String gender : request.getGenders()) {
                Gender genderItem = this.genderRepository.findByGender(gender);
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGenders().add(gender);
                graphData_en.put(gender, (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("en"));
                graphData_es.put(genderItem.getGender_es(), (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("es"));
            }
        } else if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            for (Integer age : request.getAges()) {
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getAges().add(age);
                graphData_en.put(String.valueOf(age), (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("en"));
                graphData_es.put(String.valueOf(age), (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("es"));
            }
        } else if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            for (String ethnicity : request.getEthnicity()) {
                Ethnicity ethnicityItem = this.ethnicityRepository.findByEthnicity(ethnicity);
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getEthnicity().add(ethnicity);
                graphData_en.put(ethnicity, (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("en"));
                graphData_es.put(ethnicityItem.getEthnicity_es(), (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("es"));
            }
        } else if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            for (Long grade_id : request.getGradeIds()) {
                GradeView gradeView = this.gradeRepository.findByGradeId(grade_id);
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                graphData_en.put(gradeView.getGrade_name(), (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("en"));
                graphData_es.put(gradeView.getGrade_name_es(), (List)this.getSELStrandsGraphData(getDataDashBoardRequest).get("es"));
            }
        }
        LinkedHashMap<String, LabelsAndDatasets> graphData = new LinkedHashMap<String, LabelsAndDatasets>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndDatasets3(graphData_en, (TimeLine)request.getTimeLine(), (String)"en"));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndDatasets3(graphData_es, (TimeLine)request.getTimeLine(), (String)"es"));
        }
        return graphData;
    }

    public Object getDemographicComparisonGraphData(GetDataDashBoardRequest request) {
        LinkedHashMap linkedHashMap;
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, List> graphData_en = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> graphData_es = new LinkedHashMap<String, List>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            linkedHashMap = this.getSELStrandsGraphData(getDataDashBoardRequest);
            graphData_en.put("Gender", (List)linkedHashMap.get("en"));
            graphData_es.put("G\u00e9nero", (List)linkedHashMap.get("es"));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            linkedHashMap = this.getSELStrandsGraphData(getDataDashBoardRequest);
            graphData_en.put("Age", (List)linkedHashMap.get("en"));
            graphData_es.put("Edad", (List)linkedHashMap.get("es"));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            linkedHashMap = this.getSELStrandsGraphData(getDataDashBoardRequest);
            graphData_en.put("Ethnicity", (List)linkedHashMap.get("en"));
            graphData_es.put("Etnia", (List)linkedHashMap.get("es"));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            linkedHashMap = this.getSELStrandsGraphData(getSocioEmotionalDataAnalyticsRequest);
            graphData_en.put("Grade", (List)linkedHashMap.get("en"));
            graphData_es.put("Grado", (List)linkedHashMap.get("es"));
        }
        LinkedHashMap<String, LabelsAndDatasets> graphData = new LinkedHashMap<String, LabelsAndDatasets>();
        graphData.put("en", LabelAndDataHelper.getLabelsAndDatasets(graphData_en));
        if (Language.isSpanish()) {
            graphData.put("es", LabelAndDataHelper.getLabelsAndDatasets(graphData_es));
        }
        return graphData;
    }

    public Object getTimeSpentAndSELStrandsGraphData(GetDataDashBoardRequest request) {
        List student_ids = new ArrayList();
        student_ids = request.getFromDate() != null && request.getToDate() != null ? this.studentCriteriaRepository.getStudentIdsByDemographics(request, true, false) : this.studentCriteriaRepository.getStudentIdsByDemographics(request, false, false);
        List activityList = new ArrayList();
        activityList = request.getFromDate() != null && request.getToDate() != null ? this.activityCriteriaRepository.getTimeSpentByStudentIds(student_ids, request.getTimeLine(), request.getFromDate(), request.getToDate()) : this.activityCriteriaRepository.getTimeSpentByStudentIds(student_ids, request.getTimeLine());
        LinkedHashMap activityMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activityList, Language.getLanguage());
        LinkedHashMap linkedHashMap = this.getSELStrandsGraphData(request);
        List labelAndValueList_en = (List)linkedHashMap.get("en");
        List labelAndValueList_es = (List)linkedHashMap.get("es");
        ArrayList<LabelAndValueScore> labelAndValueScoreList_en = new ArrayList<LabelAndValueScore>();
        ArrayList<LabelAndValueScore> labelAndValueScoreList_es = new ArrayList<LabelAndValueScore>();
        int tempInt = 100;
        for (String[] keys : activityMap.keySet()) {
            List values = (List)activityMap.get(keys);
            if (!values.isEmpty()) {
                double appUsedTime = 0.0;
                for (ActivityDTO activity : values) {
                    double differnce = (activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime()) / 1000L;
                    if (!(differnce >= 1.0)) continue;
                    appUsedTime += differnce;
                }
                if (appUsedTime >= 1.0 && AppUtils.isNotNullOrEmpty(student_ids)) {
                    System.out.println("key " + keys[0] + " App Used Time in seconds " + appUsedTime + " in minutes " + appUsedTime / 60.0 + " Student Size " + student_ids.size() + " AVG Time " + appUsedTime / 60.0 / (double)student_ids.size());
                    value = DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getAverage((Double)DigitUtils.getAverage((Double)appUsedTime, (Double)60.0), (Double)Double.valueOf(student_ids.size())));
                    labelAndValueScoreList_en.add(new LabelAndValueScore(keys[0], Double.valueOf(value), 0.0));
                    if (Language.isSpanish()) {
                        labelAndValueScoreList_es.add(new LabelAndValueScore(keys[1], Double.valueOf(value), 0.0));
                    }
                } else {
                    value = DigitUtils.formatDoubleInTwoDigit((Double)0.0);
                    labelAndValueScoreList_en.add(new LabelAndValueScore(keys[0], Double.valueOf(value), 0.0));
                    if (Language.isSpanish()) {
                        labelAndValueScoreList_es.add(new LabelAndValueScore(keys[1], Double.valueOf(value), 0.0));
                    }
                }
            } else {
                double value = DigitUtils.formatDoubleInTwoDigit((Double)0.0);
                labelAndValueScoreList_en.add(new LabelAndValueScore(keys[0], Double.valueOf(value), 0.0));
                if (Language.isSpanish()) {
                    labelAndValueScoreList_es.add(new LabelAndValueScore(keys[1], Double.valueOf(value), 0.0));
                }
            }
            tempInt += 100;
        }
        for (int i = 0; i < labelAndValueScoreList_en.size(); ++i) {
            LabelAndValueScore labelAndValueScore_en = (LabelAndValueScore)labelAndValueScoreList_en.get(i);
            LabelAndValueScore labelAndValueScore_es = null;
            if (Language.isSpanish()) {
                labelAndValueScore_es = (LabelAndValueScore)labelAndValueScoreList_es.get(i);
            }
            for (int j = 0; j < labelAndValueList_en.size(); ++j) {
                LabelAndValue labelAndValue_en = (LabelAndValue)labelAndValueList_en.get(j);
                if (labelAndValueScore_en.getxLabel().equals(labelAndValue_en.getxLabel())) {
                    labelAndValueScore_en.setScore(DigitUtils.formatDoubleInTwoDigit((Double)labelAndValue_en.getValue()).doubleValue());
                }
                if (!Language.isSpanish()) continue;
                LabelAndValue labelAndValue_es = (LabelAndValue)labelAndValueList_es.get(j);
                if (!labelAndValueScore_es.getxLabel().equals(labelAndValue_es.getxLabel())) continue;
                labelAndValueScore_es.setScore(DigitUtils.formatDoubleInTwoDigit((Double)labelAndValue_es.getValue()).doubleValue());
            }
        }
        LinkedHashMap<String, ArrayList<LabelAndValueScore>> graphData = new LinkedHashMap<String, ArrayList<LabelAndValueScore>>();
        graphData.put("en", labelAndValueScoreList_en);
        if (Language.isSpanish()) {
            graphData.put("es", labelAndValueScoreList_es);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }
}

