/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.instructorsurveychoice.repository;

import com.infinite.focus.server.instructorsurveychoice.entity.InstructorSurveyChoice;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface InstructorSurveyChoiceRepository
extends JpaRepository<InstructorSurveyChoice, Long> {
    @Query(value="SELECT * FROM instructor_survey_choice WHERE survey_id = ?1", nativeQuery=true)
    public List<InstructorSurveyChoice> findBySurveyId(Long var1);

    @Query(value="SELECT * FROM instructor_survey_choice WHERE instructor_id = ?1", nativeQuery=true)
    public List<InstructorSurveyChoice> findByInstructorId(long var1);

    @Query(value="SELECT * FROM instructor_survey_choice WHERE survey_id = ?1 AND instructor_id = ?2 ORDER BY instructor_survey_choice_id ASC", nativeQuery=true)
    public List<InstructorSurveyChoice> findBySurveyIdAndInstructorIdOrderByInstructorSurveyChoiceASC(long var1, long var3);

    @Query(value="SELECT * FROM instructor_survey_choice WHERE created_at BETWEEN ?1 AND ?2 ORDER BY created_at desc", nativeQuery=true)
    public List<InstructorSurveyChoice> findByCreatedAtBetweenFromDateAndEndDateOrderByDESC(String var1, String var2);

    @Query(value="SELECT COUNT(DISTINCT instructor_id) FROM instructor_survey_choice WHERE created_at BETWEEN ?1 AND ?2", nativeQuery=true)
    public long countByCreatedAtBetweenFromDateAndEndDate(String var1, String var2);

    @Query(value="SELECT COUNT(DISTINCT i.instructor_id) FROM instructor_survey_choice i WHERE i.created_at BETWEEN ?1 AND ?2 AND i.created_at < (SELECT MAX(act.start_date_time) FROM activity act WHERE act.activity_type_id = 1 AND act.instructor_id = i.instructor_id) ", nativeQuery=true)
    public long loginCountOfInstructorForWhoLoggedAfterReceivingSurveyByCreatedAtBetweenFromDateAndEndDate(String var1, String var2);

    @Query(value="SELECT COUNT(DISTINCT instructor_id) FROM instructor_survey_choice WHERE survey_choice_id > 0 AND created_at BETWEEN ?1 AND ?2", nativeQuery=true)
    public long countFilledByCreatedAtBetweenFromDateAndEndDate(String var1, String var2);

    @Query(value="SELECT * FROM instructor_survey_choice WHERE updated_at BETWEEN ?1 AND ?2 ORDER BY updated_at desc", nativeQuery=true)
    public List<InstructorSurveyChoice> findByUpdatedAtBetweenFromDateAndEndDateOrderByDESC(String var1, String var2);
}

