/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sosquestion.service;

import com.cloudinary.Cloudinary;
import com.cloudinary.utils.ObjectUtils;
import com.infinite.focus.server.client.SOSOptionClient;
import com.infinite.focus.server.sosoption.dto.SOSOptionDTO;
import com.infinite.focus.server.sosoption.request.GetOptionsByQuestionIdRequest;
import com.infinite.focus.server.sosquestion.dto.SOSQuestionDTO;
import com.infinite.focus.server.sosquestion.model.ChoiceType;
import com.infinite.focus.server.sosquestion.repository.SOSQuestionRepository;
import com.infinite.focus.server.sosquestion.request.GetActiveQuestionsCount;
import com.infinite.focus.server.sosquestion.service.SOSQuestionService;
import com.infinite.focus.server.sosquestion.wrapper.SOSQuestionOptionWrapper;
import com.infinite.focus.server.utils.AppUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class SOSQuestionServiceImpl
implements SOSQuestionService {
    private final SOSQuestionRepository sosQuestionRepository;
    private final SOSOptionClient sosOptionClient;

    public SOSQuestionServiceImpl(SOSQuestionRepository sosQuestionRepository, SOSOptionClient sosOptionClient) {
        this.sosQuestionRepository = sosQuestionRepository;
        this.sosOptionClient = sosOptionClient;
    }

    public SOSQuestionOptionWrapper create(String image, String question, String question_es, boolean active, ChoiceType choice_type, List<SOSOptionDTO> options) {
        SOSQuestionDTO sosQuestionDTO = this.sosQuestionRepository.create(image, question, question_es, active, choice_type);
        List sosOptionDTOS = this.sosOptionClient.createOptions(options.stream().peek(option -> option.setSos_question_id(sosQuestionDTO.getSos_question_id())).collect(Collectors.toList()));
        return SOSQuestionOptionWrapper.builder().question(sosQuestionDTO).options(sosOptionDTOS).build();
    }

    public SOSQuestionOptionWrapper update(long sos_question_id, String image, String question, String question_es, boolean active, ChoiceType choice_type, List<SOSOptionDTO> options) {
        SOSQuestionDTO sosQuestionDTO = this.sosQuestionRepository.update(sos_question_id, image, question, question_es, active, choice_type);
        List sosOptionDTOS = this.sosOptionClient.createOptions(options.stream().peek(option -> option.setSos_question_id(sosQuestionDTO.getSos_question_id())).collect(Collectors.toList()));
        return SOSQuestionOptionWrapper.builder().question(sosQuestionDTO).options(sosOptionDTOS).build();
    }

    public SOSQuestionDTO activeInactiveQuestion(long sos_question_id, boolean active) {
        return this.sosQuestionRepository.activeInactiveQuestion(sos_question_id, active);
    }

    public Page<SOSQuestionOptionWrapper> getQuestions(Integer image_width, Integer pageNo, Integer pageSize, String orderBy, String sortBy) {
        Cloudinary cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", "veedbeta", "api_key", "843536583549614", "api_secret", "oCK-t2tOxYm_xofyio5PO2k93Us"}));
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page result = this.sosQuestionRepository.findQuestionsByPage((Pageable)paging);
        PageImpl questions = new PageImpl(result.stream().map(sosQuestionDTO -> {
            sosQuestionDTO.setImage(AppUtils.getResizedUrl((Cloudinary)cloudinary, (int)image_width, (String)sosQuestionDTO.getImage()));
            List sosOptionDTOS = this.sosOptionClient.getOptionsByQuestionId(GetOptionsByQuestionIdRequest.builder().question_id(sosQuestionDTO.getSos_question_id()).build());
            return SOSQuestionOptionWrapper.builder().question(sosQuestionDTO).options(sosOptionDTOS).build();
        }).collect(Collectors.toList()), result.getPageable(), result.getTotalElements());
        return questions;
    }

    public Page<SOSQuestionOptionWrapper> getQuestionsForStudent(Integer image_width, Integer pageNo, Integer pageSize, String orderBy, String sortBy) {
        Cloudinary cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", "veedbeta", "api_key", "843536583549614", "api_secret", "oCK-t2tOxYm_xofyio5PO2k93Us"}));
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equalsIgnoreCase("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page result = this.sosQuestionRepository.findActiveQuestionsByPage((Pageable)paging);
        PageImpl activeQuestions = new PageImpl(result.stream().map(sosQuestionDTO -> {
            sosQuestionDTO.setImage(AppUtils.getResizedUrl((Cloudinary)cloudinary, (int)image_width, (String)sosQuestionDTO.getImage()));
            List sosOptionDTOS = this.sosOptionClient.getOptionsByQuestionId(GetOptionsByQuestionIdRequest.builder().question_id(sosQuestionDTO.getSos_question_id()).build());
            return SOSQuestionOptionWrapper.builder().question(sosQuestionDTO).options(sosOptionDTOS).build();
        }).collect(Collectors.toList()), result.getPageable(), result.getTotalElements());
        return activeQuestions;
    }

    public GetActiveQuestionsCount getActiveQuestionsCount() {
        return GetActiveQuestionsCount.builder().active_questions_count(this.sosQuestionRepository.getActiveQuestionsCount()).build();
    }

    public List<SOSQuestionDTO> getSOSQuestionsByIds(Set<Long> sos_question_ids, int image_width) {
        Cloudinary cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", "veedbeta", "api_key", "843536583549614", "api_secret", "oCK-t2tOxYm_xofyio5PO2k93Us"}));
        return this.sosQuestionRepository.getSOSQuestionsByIds(sos_question_ids).stream().peek(sosQuestionDTO -> sosQuestionDTO.setImage(AppUtils.getResizedUrl((Cloudinary)cloudinary, (int)image_width, (String)sosQuestionDTO.getImage()))).collect(Collectors.toList());
    }
}

