/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.district.service;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.district.dto.DistrictDTO;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.repository.DistrictCoreRepository;
import com.infinite.focus.server.district.repository.DistrictRepository;
import com.infinite.focus.server.district.request.GetStudentTestReportbyDistrictRequest;
import com.infinite.focus.server.district.response.GetStudentTestReportbyDistrictResponse;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.freetrial.entity.FreeTrial;
import com.infinite.focus.server.freetrial.model.FocusOn;
import com.infinite.focus.server.freetrial.model.OrganizationType;
import com.infinite.focus.server.freetrial.service.FreeTrialService;
import com.infinite.focus.server.invoice.entity.Invoice;
import com.infinite.focus.server.invoice.model.InvoiceType;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.organizationadmin.entity.OrganizationAdmin;
import com.infinite.focus.server.organizationadmin.service.OrganizationAdminService;
import com.infinite.focus.server.school.entity.School;
import com.infinite.focus.server.school.service.SchoolService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DistrictServiceImpl
implements DistrictService {
    @Autowired
    DistrictRepository districtRepository;
    @Autowired
    private DistrictCoreRepository districtCoreRepository;
    @Autowired
    SchoolService schoolService;
    @Autowired
    FreeTrialService freeTrialService;
    @Autowired
    OrganizationAdminService organizationAdminService;
    @Autowired
    AccountService accountService;
    @Autowired
    MessageService messageService;

    public List<DistrictDTO> getAll() {
        return this.districtCoreRepository.findAll();
    }

    public DistrictDTO getById(long district_id) {
        return this.districtCoreRepository.findById(district_id);
    }

    public District getDistrictById(long district_id) {
        return this.districtRepository.findByDistrictId(Long.valueOf(district_id));
    }

    public District getDistrictByCleverId(String clever_id) {
        return this.districtRepository.findByDistrictCleverId(clever_id);
    }

    public District getDistrictByAccountId(long account_id) {
        return this.findByAccountId(account_id);
    }

    public Page<District> getDistricts(String districtName, Integer pageNo, Integer pageSize, String sortBy, String orderBy) {
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = districtName == null || districtName.isEmpty() ? this.districtRepository.findAllDistricts((Pageable)paging) : this.districtRepository.findByDistrictName(districtName, (Pageable)paging);
        return pagedResult;
    }

    public long getStudentsCountByDistrictId(long district_id) {
        List schools = this.schoolService.getSchoolsByDistrictId(district_id);
        long count = 0L;
        for (School school : schools) {
            count += this.schoolService.getStudentsCountBySchoolId(school.getSchool_id());
        }
        return count;
    }

    public District activeDeactiveDistrict(long district_id, boolean active) {
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        district.setActive(active);
        return (District)this.districtRepository.save((Object)district);
    }

    public Date getRenewalDate(long district_id) {
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        if (AppUtils.isNotNullOrEmpty((String)district.getLicense_key())) {
            return district.getLicence_key_expiry_date();
        }
        return this.freeTrialService.getFreeTrialByDistrictId(district.getDistrict_id()).getTrial_end_date();
    }

    public District findByAccountId(long account_id) {
        List organizationAdmins;
        District district = this.districtRepository.findByAccountId(Long.valueOf(account_id));
        if (district == null && !AppUtils.isNullOrEmpty((List)(organizationAdmins = this.organizationAdminService.findByOrganizationTypeAndAccountId(OrganizationType.LARGE_ORGANIZATION.toString(), account_id)))) {
            OrganizationAdmin organizationAdmin = (OrganizationAdmin)organizationAdmins.get(0);
            district = this.districtRepository.findByDistrictId(Long.valueOf(organizationAdmin.getOrganization_id()));
        }
        return district;
    }

    public District deleteDistrict(long district_id, boolean deleted, boolean isFromFreeTrial) {
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        district.setDeleted(deleted);
        if (!isFromFreeTrial && AppUtils.isNullOrEmpty((String)district.getLicense_key())) {
            FreeTrial freeTrial = this.freeTrialService.deleteFreeTrial(district.getDistrict_id(), OrganizationType.LARGE_ORGANIZATION, deleted);
        }
        return (District)this.districtRepository.save((Object)district);
    }

    public District editDistrict(long district_id, String district_name, FocusOn focus_on, String email, String city, String state, long number_of_youth, Date licence_key_expiry_date) {
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)district_name)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("district.name.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)city)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("city.is.null.or.empty"));
        }
        if (AppUtils.isNullOrEmpty((String)state)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("state.is.null.or.empty"));
        }
        Account account = this.accountService.changeEmail(district.getAccount_id(), email);
        district.setDistrict_name(district_name);
        district.setFocus_on(focus_on);
        district.setCity(city);
        district.setState(state);
        district.setNumber_of_youth(number_of_youth);
        if (AppUtils.isNullOrEmpty((String)district.getLicense_key())) {
            this.freeTrialService.editFreeTrial(district.getDistrict_id(), OrganizationType.LARGE_ORGANIZATION, district_name, focus_on, licence_key_expiry_date);
        } else {
            district.setLicence_key_expiry_date(licence_key_expiry_date);
        }
        return (District)this.districtRepository.save((Object)district);
    }

    public District updateNumberOfYouthByDistrictId(long district_id, long number_of_youth) {
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        district.setNumber_of_youth(number_of_youth);
        return (District)this.districtRepository.save((Object)district);
    }

    public District renewSubscriptionByDistrictId(long district_id) {
        District district = this.districtRepository.findByDistrictId(Long.valueOf(district_id));
        if (district == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.large.organization.is.not.found"));
        }
        district.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        district.setActive(true);
        return (District)this.districtRepository.save((Object)district);
    }

    public void addLicenseKey(Invoice invoice) {
        District district = this.getDistrictById(invoice.getOrganization_id());
        district.setLicense_key(invoice.getLicense_key());
        district.setLicence_key_added_date(new Date());
        district.setLicence_key_expiry_date(DateUtils.getNextYearDateFromToday());
        district.setActive(true);
        if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            district.setNumber_of_youth(invoice.getNumber_of_youth());
        }
        this.districtRepository.save((Object)district);
        FreeTrial freeTrial = this.freeTrialService.findByOrganizationTypeAndOrganizationId(OrganizationType.LARGE_ORGANIZATION.toString(), district.getDistrict_id());
        if (freeTrial != null) {
            this.freeTrialService.deleteById(Long.valueOf(freeTrial.getFree_trial_id()));
        }
    }

    public void updateSubscription(Invoice invoice) {
        if (!AppUtils.isNullOrEmpty((String)invoice.getLicense_key())) {
            this.addLicenseKey(invoice);
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.INCREASE_NO_OF_YOUTH)) {
            this.updateNumberOfYouthByDistrictId(invoice.getOrganization_id(), invoice.getNumber_of_youth());
        } else if (invoice.getInvoice_type().equals((Object)InvoiceType.RENEW_SUBSCRIPTION)) {
            this.renewSubscriptionByDistrictId(invoice.getOrganization_id());
        }
    }

    public District save(District district) {
        return (District)this.districtRepository.save((Object)district);
    }

    public Page<GetStudentTestReportbyDistrictResponse> getStudentReportbyDistrict32(GetStudentTestReportbyDistrictRequest request) {
        Integer pageNumber = request.getPageNo() - 1;
        LocalDate startDate = null;
        LocalDate endDate = null;
        if (request.getFromDate() != null) {
            startDate = request.getFromDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (request.getToDate() != null) {
            endDate = request.getToDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        String studentIds = null;
        if (request.getStudents_id() != null && !request.getStudents_id().isEmpty()) {
            studentIds = request.getStudents_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String genders = null;
        if (request.getGenders() != null && !request.getGenders().isEmpty()) {
            genders = String.join((CharSequence)",", request.getGenders());
        }
        String ages = null;
        if (request.getAges() != null && !request.getAges().isEmpty()) {
            ages = request.getAges().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String ethnicities = null;
        if (request.getEthnicity() != null && !request.getEthnicity().isEmpty()) {
            ethnicities = String.join((CharSequence)",", request.getEthnicity());
        }
        String gradeIds = null;
        if (request.getGradeIds() != null && !request.getGradeIds().isEmpty()) {
            gradeIds = request.getGradeIds().stream().flatMap(grade -> {
                if (grade == 1L) {
                    return Stream.of(1, 2, 3);
                }
                if (grade == 2L) {
                    return Stream.of(4, 5, 6);
                }
                if (grade == 3L) {
                    return Stream.of(7, 8, 9, 10, 11, 12, 13);
                }
                return Stream.of(grade);
            }).map(x$0 -> String.valueOf(x$0)).collect(Collectors.joining(","));
        }
        String schoolIds = null;
        if (request.getSchool_id() != null && !request.getSchool_id().isEmpty()) {
            schoolIds = request.getSchool_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String groupIds = null;
        if (request.getStudents_id() != null && !request.getStudents_id().isEmpty()) {
            groupIds = request.getStudents_id().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        List results = this.districtRepository.getStudentTestReportDistrict32(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, schoolIds, groupIds, pageNumber, request.getPageSize(), request.getSortBy(), request.getOrderBy());
        List content = results.stream().map(result -> {
            int gradeIndex;
            Object[] transformedResult = (Object[])result.clone();
            if (transformedResult[gradeIndex = 5] != null) {
                int gradeValue = ((Number)transformedResult[gradeIndex]).intValue();
                if (gradeValue >= 1 && gradeValue <= 3) {
                    transformedResult[gradeIndex] = gradeValue == 1 ? "K" : String.valueOf(gradeValue - 1);
                } else if (gradeValue >= 4 && gradeValue <= 6) {
                    transformedResult[gradeIndex] = String.valueOf(gradeValue - 3);
                } else if (gradeValue >= 7 && gradeValue <= 13) {
                    transformedResult[gradeIndex] = String.valueOf(gradeValue - 1);
                }
            }
            return new GetStudentTestReportbyDistrictResponse(transformedResult);
        }).collect(Collectors.toList());
        Long totalElements = this.districtRepository.getStudentTestReportDistrictPageCount32(startDate, endDate, studentIds, genders, ages, ethnicities, gradeIds, schoolIds, groupIds);
        Sort.Direction direction = "desc".equalsIgnoreCase(request.getOrderBy()) ? Sort.Direction.DESC : Sort.Direction.ASC;
        Sort sort = Sort.by((Sort.Direction)direction, (String[])new String[]{request.getSortBy()});
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)request.getPageSize(), (Sort)sort);
        return new PageImpl(content, (Pageable)pageable, totalElements.longValue());
    }

    public List<Map<String, Object>> searchStudents(GetStudentTestReportbyDistrictRequest request, Long districtId) {
        List schoolIdsList = null;
        schoolIdsList = request.getSchool_id() != null && !request.getSchool_id().isEmpty() ? request.getSchool_id().stream().map(Integer::longValue).collect(Collectors.toList()) : this.districtRepository.getSchoolIdsByDistrictId(districtId);
        List classIdsList = null;
        if (request.getGroups() != null && !request.getGroups().isEmpty()) {
            classIdsList = request.getGroups();
        } else if (schoolIdsList != null && !schoolIdsList.isEmpty()) {
            List groupResults = this.districtRepository.getGroupsByNameAndSchoolsForStudentReport("", schoolIdsList);
            classIdsList = groupResults.stream().map(row -> ((Number)row[0]).longValue()).collect(Collectors.toList());
        }
        String genders = null;
        if (request.getGenders() != null && !request.getGenders().isEmpty()) {
            genders = String.join((CharSequence)",", request.getGenders());
        }
        String ages = null;
        if (request.getAges() != null && !request.getAges().isEmpty()) {
            ages = request.getAges().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String ethnicities = null;
        if (request.getEthnicity() != null && !request.getEthnicity().isEmpty()) {
            ethnicities = String.join((CharSequence)",", request.getEthnicity());
        }
        String gradeIds = null;
        if (request.getGradeIds() != null && !request.getGradeIds().isEmpty()) {
            gradeIds = request.getGradeIds().stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String schoolIds = null;
        if (schoolIdsList != null && !schoolIdsList.isEmpty()) {
            schoolIds = schoolIdsList.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String classIds = null;
        if (classIdsList != null && !classIdsList.isEmpty()) {
            classIds = classIdsList.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        String studentName = request.getStudent_name();
        List results = this.districtRepository.searchStudentsSimple(studentName, genders, ages, ethnicities, gradeIds, schoolIds, classIds);
        return results.stream().map(row -> {
            HashMap<String, Object> student = new HashMap<String, Object>();
            student.put("studentId", row[0]);
            student.put("studentName", row[1]);
            student.put("schoolId", row[2]);
            return student;
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> getSchoolsByName(String schoolName, Long districtId) {
        List results = this.districtRepository.getSchoolsByNameForReport(schoolName, districtId);
        return results.stream().map(row -> {
            HashMap<String, Object> school = new HashMap<String, Object>();
            school.put("schoolId", row[0]);
            school.put("schoolName", row[1]);
            return school;
        }).collect(Collectors.toList());
    }

    public List<Map<String, Object>> getGroupsByName(Long district_id, String groupName, List<Long> schools) {
        List schoolIds = schools;
        if (schools == null || schools.isEmpty()) {
            schoolIds = this.districtRepository.getSchoolIdsByDistrictId(district_id);
        }
        if (schoolIds == null || schoolIds.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        List results = this.districtRepository.getGroupsByNameAndSchoolsForStudentReport(groupName, schoolIds);
        return results.stream().map(row -> {
            HashMap<String, Object> group = new HashMap<String, Object>();
            group.put("groupId", row[0]);
            group.put("groupName", row[1]);
            group.put("schoolId", row[4]);
            return group;
        }).collect(Collectors.toList());
    }
}

