/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.post.controller;

import com.infinite.focus.server.auth.model.Message;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.client.VimeoClient;
import com.infinite.focus.server.favorite.service.FavoriteService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.post.dto.PostDTO;
import com.infinite.focus.server.post.model.PostType;
import com.infinite.focus.server.post.repository.PostRepository;
import com.infinite.focus.server.post.request.AddRemoveFromFavoriteRequest;
import com.infinite.focus.server.post.request.DeletePostsRequest;
import com.infinite.focus.server.post.request.GetPostsPageRequest;
import com.infinite.focus.server.post.request.GetPostsRequest;
import com.infinite.focus.server.post.response.AddRemoveFromFavoriteResponse;
import com.infinite.focus.server.post.service.PostService;
import com.infinite.focus.server.post.wrapper.PostWrapper;
import com.infinite.focus.server.streak.dto.StreakDTO;
import com.infinite.focus.server.student.entity.Student;
import com.infinite.focus.server.studentstreak.service.resourcelibrary.StreakResourceLibraryService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.vimeo.model.VimeoVideoDetailsoEmbed;
import com.infinite.focus.server.vimeo.request.GetVimeoVideoDetailsByVideoUrlRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/post"})
public class PostController {
    private final PostRepository postRepository;
    private final AuthService authService;
    private final PostService postService;
    private final FavoriteService favoriteService;
    private final VimeoClient vimeoClient;
    private final StreakResourceLibraryService streakResourceLibraryService;
    private final MessageService messageService;

    public PostController(PostRepository postRepository, AuthService authService, PostService postService, FavoriteService favoriteService, VimeoClient vimeoClient, StreakResourceLibraryService streakResourceLibraryService, MessageService messageService) {
        this.postRepository = postRepository;
        this.authService = authService;
        this.postService = postService;
        this.favoriteService = favoriteService;
        this.vimeoClient = vimeoClient;
        this.streakResourceLibraryService = streakResourceLibraryService;
        this.messageService = messageService;
    }

    @PostMapping(value={"/create/post"})
    @ResponseBody
    public ResponseEntity<PostDTO> createPost(@RequestHeader(value="Authorization") String token, @RequestParam(value="post_title") String post_title, @RequestParam(value="post_title_es") String post_title_es, @RequestParam(value="post_description") String post_description, @RequestParam(value="post_description_es") String post_description_es, @RequestParam(required=false, value="post_cover_image_url") String post_cover_image_url, @RequestParam(required=false, value="post_cover_image_url_es") String post_cover_image_url_es, @RequestParam(required=false, value="post_video_url") String post_video_url, @RequestParam(required=false, value="post_video_url_es") String post_video_url_es, @RequestParam(value="post_type") PostType post_type, @RequestParam(required=false, value="key_words") String key_words, @RequestParam(value="categories") String categories, @RequestParam(value="contents") String contents, @RequestParam(value="moods") String moods, @RequestParam(value="standards") String standards) {
        this.authService.isAuthenticated(token);
        Set category_ids = Arrays.stream(categories.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Set content_ids = Arrays.stream(contents.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Set mood_ids = Arrays.stream(moods.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Set standard_ids = Arrays.stream(standards.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        PostDTO postDTO = this.postService.create(post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, key_words, category_ids, content_ids, mood_ids, standard_ids);
        return new ResponseEntity((Object)postDTO, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/edit/post"})
    @ResponseBody
    public ResponseEntity<PostDTO> editPost(@RequestHeader(value="Authorization") String token, @RequestParam(value="post_id") long post_id, @RequestParam(value="post_title") String post_title, @RequestParam(value="post_title_es") String post_title_es, @RequestParam(value="post_description") String post_description, @RequestParam(value="post_description_es") String post_description_es, @RequestParam(required=false, value="post_cover_image_url") String post_cover_image_url, @RequestParam(required=false, value="post_cover_image_url_es") String post_cover_image_url_es, @RequestParam(required=false, value="post_video_url") String post_video_url, @RequestParam(required=false, value="post_video_url_es") String post_video_url_es, @RequestParam(value="post_type") PostType post_type, @RequestParam(required=false, value="key_words") String key_words, @RequestParam(value="categories") String categories, @RequestParam(value="contents") String contents, @RequestParam(value="moods") String moods, @RequestParam(value="standards") String standards) {
        this.authService.isAuthenticated(token);
        PostDTO requestPostDTO = this.postRepository.findById(post_id);
        if (requestPostDTO == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.post.is.not.found"));
        }
        Set category_ids = Arrays.stream(categories.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Set content_ids = Arrays.stream(contents.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Set mood_ids = Arrays.stream(moods.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        Set standard_ids = Arrays.stream(standards.split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        PostDTO postDTO = this.postService.update(post_id, post_type, post_title, post_title_es, post_description, post_description_es, post_cover_image_url, post_cover_image_url_es, post_video_url, post_video_url_es, key_words, category_ids, content_ids, mood_ids, standard_ids);
        return new ResponseEntity((Object)postDTO, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get/posts"})
    public ResponseEntity<Page<PostDTO>> getPosts(@RequestHeader(value="Authorization") String token, @RequestBody GetPostsRequest request) {
        this.authService.isAuthenticated(token);
        Student student = this.authService.getStudentByToken(token);
        Set<Object> post_types = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getPost_types())) {
            post_types = Arrays.stream(request.getPost_types().split("\\s*,\\s*")).collect(Collectors.toSet());
        }
        Set category_ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getCategories())) {
            category_ids = Arrays.stream(request.getCategories().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set content_ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getContents())) {
            content_ids = Arrays.stream(request.getContents().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set mood_ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getMoods())) {
            mood_ids = Arrays.stream(request.getMoods().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set<Long> standard_ids = new HashSet<Long>();
        if (student != null && student.getStandard_id() > 0L) {
            standard_ids.add(student.getStandard_id());
        }
        if (!AppUtils.isNullOrEmpty((String)request.getStandards())) {
            standard_ids = Arrays.stream(request.getStandards().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set last_post_ids = new HashSet();
        if (request.getLastPostIds() == null) {
            last_post_ids = null;
        }
        if (!AppUtils.isNullOrEmpty((String)request.getLastPostIds())) {
            last_post_ids = Arrays.stream(request.getLastPostIds().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new ResponseEntity((Object)this.postService.getPosts(student != null ? student.getStudent_id() : 0L, request.getPost_title(), post_types, category_ids, content_ids, mood_ids, standard_ids, request.isShowOnlyFavorites(), last_post_ids, request.getPageNo(), request.getPageSize(), request.getSortBy(), request.getOrderBy()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-posts"})
    public ResponseEntity<Page<PostWrapper>> getResourceLibrary(@RequestHeader(value="Authorization") String token, @RequestBody GetPostsPageRequest request) {
        Set<Object> post_types = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getPost_types())) {
            post_types = Arrays.stream(request.getPost_types().split("\\s*,\\s*")).collect(Collectors.toSet());
        }
        Set category_ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getCategories())) {
            category_ids = Arrays.stream(request.getCategories().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set content_ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getContents())) {
            content_ids = Arrays.stream(request.getContents().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set mood_ids = new HashSet();
        if (!AppUtils.isNullOrEmpty((String)request.getMoods())) {
            mood_ids = Arrays.stream(request.getMoods().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set<Long> standard_ids = new HashSet<Long>();
        if (request.getStudent_id() > 0L && request.getStandard_id() > 0L) {
            standard_ids.add(request.getStandard_id());
        }
        if (!AppUtils.isNullOrEmpty((String)request.getStandards())) {
            standard_ids = Arrays.stream(request.getStandards().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Set last_post_ids = new HashSet();
        if (request.getLastPostIds() == null) {
            last_post_ids = null;
        }
        if (!AppUtils.isNullOrEmpty((String)request.getLastPostIds())) {
            last_post_ids = Arrays.stream(request.getLastPostIds().split("\\s*,\\s*")).map(Long::valueOf).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        }
        Page postWrappers = this.postService.getResourceLibrary(request.getStudent_id(), request.getPost_title(), post_types, category_ids, content_ids, mood_ids, standard_ids, request.isShowOnlyFavorites(), last_post_ids, Integer.valueOf(request.getPageNo()), Integer.valueOf(request.getPageSize()), request.getSortBy(), request.getOrderBy());
        return new ResponseEntity((Object)postWrappers, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/delete/posts"})
    @ResponseBody
    public ResponseEntity<Message> deletePosts(@RequestHeader(value="Authorization") String token, @RequestBody DeletePostsRequest request) {
        this.authService.isAuthenticated(token);
        if (AppUtils.isNullOrEmpty((Set)request.getPost_ids())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("unable.to.delete.the.resource.from.the.library.please.try.again.after.some.time"));
        }
        this.postService.deletePostsByIds(request.getPost_ids());
        Message message = new Message();
        if (request.getPost_ids().size() == 1) {
            message.setMessage(this.messageService.getMessage("the.resource.has.been.removed.successfully.from.the.library"));
        } else {
            message.setMessage(this.messageService.getMessage("the.resource.s.have.been.removed.successfully.from.the.library"));
        }
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/delete/all/posts"})
    @ResponseBody
    public ResponseEntity<Message> deleteAllPosts(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        this.postService.deleteAllPosts();
        Message message = new Message();
        message.setMessage(this.messageService.getMessage("all.the.resources.have.been.removed.successfully.from.the.library"));
        return new ResponseEntity((Object)message, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/add-remove-from-favorite"})
    @ResponseBody
    public ResponseEntity<AddRemoveFromFavoriteResponse> addRemoveFromFavorite(@RequestHeader(value="Authorization") String token, @RequestBody AddRemoveFromFavoriteRequest request) {
        Student student = this.authService.isStudent(token);
        Message message = this.favoriteService.addRemoveFavorite(request.getPost_id(), student.getStudent_id());
        AddRemoveFromFavoriteResponse addRemoveFromFavoriteResponse = new AddRemoveFromFavoriteResponse();
        addRemoveFromFavoriteResponse.setMessage(message.getMessage());
        StreakDTO streak = this.streakResourceLibraryService.addStreakSaveVideos(student.getStudent_id());
        addRemoveFromFavoriteResponse.setStreak(streak);
        return new ResponseEntity((Object)addRemoveFromFavoriteResponse, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/sync-all-resource-library-posts"})
    public ResponseEntity<Message> syncAllResourceLibraryPosts(@RequestHeader(value="Authorization") String token) {
        this.authService.isAuthenticated(token);
        new Thread(() -> this.syncAllResourceLibraryVideoPosts()).start();
        return new ResponseEntity((Object)new Message(this.messageService.getMessage("work.in.progress.please.wait.for.five.min")), (HttpStatusCode)HttpStatus.OK);
    }

    private List<PostDTO> syncAllResourceLibraryVideoPosts() {
        List posts = this.postRepository.getAllPostByPostTypeOrderByPostId(PostType.VIDEO, "ASC");
        for (PostDTO postDTO : posts) {
            String url = postDTO.getPost_video_url().trim();
            System.out.println("Post id - " + postDTO.getPost_id() + " Type - " + postDTO.getPost_type().toString() + " Vimeo Video Url - " + url);
            VimeoVideoDetailsoEmbed vimeoVideoDetailsoEmbed = this.vimeoClient.getVimeoVideoDetailsoEmbedByVideoUrl(GetVimeoVideoDetailsByVideoUrlRequest.builder().video_url(url).build());
            if (vimeoVideoDetailsoEmbed == null) continue;
            this.postService.updateoEmbed_htmlById(postDTO.getPost_id(), vimeoVideoDetailsoEmbed.getHtml());
        }
        return posts;
    }
}

