/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.pvstate.model;

public enum PVState {
    VENTRAL("Ventral"),
    VENTRAL_SYMPATHETIC("Ventral Sympathetic"),
    VENTRAL_DORSAL("Ventral Dorsal"),
    SYMPATHETIC_VENTRAL("Sympathetic Ventral"),
    SYMPATHETIC("Sympathetic"),
    SYMPATHETIC_DORSAL("Sympathetic Dorsal"),
    DORSAL_VENTRAL("Dorsal Ventral"),
    DORSAL_TO_NEUTRAL("Dorsal to neutral"),
    DORSAL_TO_DORSAL_VENTRAL("Dorsal to Dorsal Ventral"),
    DORSAL_SYMPATHETIC("Dorsal Sympathetic"),
    DORSAL("Dorsal");

    private final String pv_state;

    private PVState(String pv_state) {
        this.pv_state = pv_state;
    }

    public String toString() {
        return this.pv_state;
    }

    public static PVState valueOfOrDefault(String myValue) {
        for (PVState type : (PVState[])PVState.class.getEnumConstants()) {
            String pv_state = type.pv_state;
            if (!pv_state.equalsIgnoreCase(myValue)) continue;
            return type;
        }
        return null;
    }

    public static PVState getByLevelOfFocus(float level_of_focus) {
        if (level_of_focus == 1.0f) {
            return DORSAL;
        }
        if (level_of_focus >= 2.0f && level_of_focus <= 3.0f) {
            return SYMPATHETIC;
        }
        if (level_of_focus >= 4.0f && level_of_focus <= 5.0f) {
            return VENTRAL;
        }
        return null;
    }
}

