/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.assessmentcategory.repository;

import com.infinite.focus.server.assessmentcategory.repository.AssessmentCategoryRepository;
import com.infinite.focus.server.utils.AppUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class AssessmentCategoryRepositoryImpl
implements AssessmentCategoryRepository {
    private final JdbcTemplate jdbcTemplate;

    public AssessmentCategoryRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void createAssessmentCategoryTable() {
        String SQL = "CREATE TABLE IF NOT EXISTS assessment_category(assessment_id bigint not null, category_id bigint not null )";
        this.jdbcTemplate.execute(SQL);
    }

    public void create(long assessment_id, Set<Long> category_ids) {
        if (!AppUtils.isNullOrEmpty(category_ids)) {
            this.deleteByAssessmentId(assessment_id);
            String INSERT_SQL = "INSERT INTO assessment_category (  assessment_id, category_id ) VALUES (?,?)";
            ArrayList arrayList = (ArrayList)this.jdbcTemplate.execute(connection -> connection.prepareStatement("INSERT INTO assessment_category (  assessment_id, category_id ) VALUES (?,?)", 1), ps -> {
                Iterator iterator = category_ids.iterator();
                while (iterator.hasNext()) {
                    long category_id = (Long)iterator.next();
                    ps.setLong(1, assessment_id);
                    ps.setLong(2, category_id);
                    ps.addBatch();
                }
                ps.executeBatch();
                ResultSet resultSet = ps.getGeneratedKeys();
                ArrayList<Long> ids = new ArrayList<Long>();
                while (resultSet.next()) {
                    ids.add(resultSet.getLong(1));
                }
                return ids;
            });
        }
    }

    public void deleteByAssessmentId(long assessment_id) {
        String SQL = "DELETE FROM assessment_category WHERE assessment_id = ? ";
        try {
            this.jdbcTemplate.update(SQL, new Object[]{assessment_id});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

