/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.sostime.repository;

import com.infinite.focus.server.sostime.dto.SOSTimeDTO;
import com.infinite.focus.server.sostime.repository.SOSTimeRepository;
import com.infinite.focus.server.utils.DateUtils;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
import org.springframework.web.server.ResponseStatusException;

@Repository
public class SOSTimeRepositoryImpl
implements SOSTimeRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public SOSTimeDTO createForSchool(long school_id, ZonedDateTime from_time, ZonedDateTime to_time) {
        String INSERT_SQL = "INSERT INTO sostime (school_id, from_time, to_time, time_zone, created_at, updated_at) VALUES (?,?,?,?,?,?)";
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("INSERT INTO sostime (school_id, from_time, to_time, time_zone, created_at, updated_at) VALUES (?,?,?,?,?,?)", 1);
            ps.setLong(1, school_id);
            ps.setTimestamp(2, Timestamp.valueOf(from_time.toLocalDateTime()));
            ps.setTimestamp(3, Timestamp.valueOf(to_time.toLocalDateTime()));
            ps.setString(4, DateUtils.getSystemTimeOffset((ZonedDateTime)to_time));
            ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now()));
            ps.setTimestamp(6, Timestamp.valueOf(LocalDateTime.now()));
            return ps;
        }, (KeyHolder)holder);
        int sos_time_id = Objects.requireNonNull(holder.getKey()).intValue();
        return this.getForSchool(school_id);
    }

    public SOSTimeDTO getForSchool(long school_id) {
        try {
            String SQL = "SELECT * FROM sostime WHERE school_id = ?";
            return (SOSTimeDTO)this.jdbcTemplate.queryForObject(SQL, (rs, i) -> SOSTimeDTO.builder().sos_time_id(rs.getLong("sos_time_id")).school_id(rs.getLong("school_id")).from_time(DateUtils.addTimeInCurrentDateFromTimestamp((Timestamp)rs.getTimestamp("from_time"), (String)rs.getString("time_zone"))).to_time(DateUtils.addTimeInCurrentDateFromTimestamp((Timestamp)rs.getTimestamp("to_time"), (String)rs.getString("time_zone"))).build(), new Object[]{school_id});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SOSTimeDTO updateForSchool(long school_id, ZonedDateTime from_time, ZonedDateTime to_time) {
        String SQL = "UPDATE sostime SET from_time = ?, to_time = ?, time_zone = ?, updated_at = ? WHERE school_id = ? ";
        int updateCount = this.jdbcTemplate.update("UPDATE sostime SET from_time = ?, to_time = ?, time_zone = ?, updated_at = ? WHERE school_id = ? ", new Object[]{Timestamp.valueOf(from_time.toLocalDateTime()), Timestamp.valueOf(to_time.toLocalDateTime()), DateUtils.getSystemTimeOffset((ZonedDateTime)to_time), Timestamp.valueOf(LocalDateTime.now()), school_id});
        if (updateCount == 1) {
            return this.getForSchool(school_id);
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, "Not updated!!!");
    }
}

