/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentpushnotification.repository;

import com.infinite.focus.server.studentpushnotification.entity.StudentPushNotification;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface StudentPushNotificationRepository
extends JpaRepository<StudentPushNotification, Long> {
    @Query(value="SELECT * FROM student_push_notification WHERE student_push_notification_id = ?1 ", nativeQuery=true)
    public StudentPushNotification findById(long var1);

    @Query(value="SELECT * FROM student_push_notification WHERE student_id = ?1 or student_id = 0", nativeQuery=true)
    public Page<StudentPushNotification> findByStudentId(Long var1, Pageable var2);

    @Query(value="SELECT * FROM student_push_notification WHERE created_at >= (SELECT created_date FROM access_code WHERE student_id = ?1 LIMIT 0,1) AND (student_id = ?1 or student_id = 0)", nativeQuery=true)
    public Page<StudentPushNotification> findByGreaterThanEqualToStudentApproveDateAndStudentId(long var1, Pageable var3);

    @Query(value="SELECT * FROM student_push_notification WHERE created_at >= (SELECT created_date FROM access_code WHERE student_id = ?1 LIMIT 0,1) AND (student_id = ?1 or student_id = 0) AND viewed = ?2", nativeQuery=true)
    public Page<StudentPushNotification> findByGreaterThanEqualToStudentApproveDateAndStudentIdAndViewed(long var1, Boolean var3, Pageable var4);

    @Query(value="SELECT COUNT(*) FROM student_push_notification WHERE created_at >= (SELECT created_date FROM access_code WHERE student_id = ?1 LIMIT 0,1) AND (student_id = ?1 or student_id = 0) AND viewed = ?2", nativeQuery=true)
    public long getCountOfGreaterThanEqualToStudentApproveDateAndStudentIdAndViewed(long var1, Boolean var3);

    @Query(value="SELECT * FROM student_push_notification WHERE created_at >= (SELECT created_date FROM access_code WHERE student_id = ?1 LIMIT 0,1) AND (student_id = ?1 or student_id = 0) ORDER BY student_push_notification_id DESC LIMIT 1", nativeQuery=true)
    public StudentPushNotification findTopFirstGreaterThanEqualToStudentApproveDateAndStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM student_push_notification WHERE student_id = ?1", nativeQuery=true)
    public void deleteByStudentId(long var1);

    @Modifying
    @Transactional
    @Query(value="DELETE FROM student_push_notification WHERE student_id IN(?1)", nativeQuery=true)
    public void deleteByStudentIds(List<Long> var1);

    @Query(value="SELECT * FROM student_push_notification WHERE student_id = ?1 AND notification_type = ?2 ORDER BY student_push_notification_id LIMIT 0,1", nativeQuery=true)
    public StudentPushNotification findByStudentIdAndNotificationType(Long var1, String var2);

    @Modifying
    @Transactional
    @Query(value="UPDATE student_push_notification SET viewed = ?2 WHERE student_push_notification_id IN(?1)", nativeQuery=true)
    public void updateViewedByStudentPushNotificationIds(List<Long> var1, boolean var2);
}

