/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.infinite.focus.server.converter.EncryptDecryptHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Converter
extends AbstractHttpMessageConverter<Object> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Autowired
    private ObjectMapper objectMapper;

    public Converter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json", DEFAULT_CHARSET)});
    }

    protected boolean supports(Class<?> clazz) {
        return !this.isRequiresNormalRequestResponse();
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.objectMapper.readValue(Converter.decrypt((InputStream)inputMessage.getBody(), (boolean)true), clazz);
    }

    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getBody().write(Converter.encrypt((byte[])this.objectMapper.writeValueAsBytes(o), (boolean)true));
    }

    private boolean isRequiresNormalRequestResponse() {
        try {
            String[] noNeedEncryptionDecryptionUrls;
            HttpServletRequest httpRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            String fullURL = httpRequest.getRequestURL().toString();
            for (String item : noNeedEncryptionDecryptionUrls = "invoice/webhook,compass-dashboard/get-low-score-categories-by-assessment-texts".split("\\s*,\\s*")) {
                if (!fullURL.contains(item)) continue;
                return true;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    public static InputStream decrypt(InputStream inputStream, boolean encrypted) {
        StringBuilder requestParamString = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, DEFAULT_CHARSET));){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                requestParamString.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            String decryptRequestString = null;
            decryptRequestString = encrypted ? EncryptDecryptHelper.decrypt((String)requestParamString.toString()) : requestParamString.toString();
            if (decryptRequestString != null) {
                return new ByteArrayInputStream(decryptRequestString.getBytes(DEFAULT_CHARSET));
            }
            return inputStream;
        }
        catch (JSONException err) {
            return inputStream;
        }
    }

    public static byte[] encrypt(byte[] bytesToEncrypt, boolean encrypted) {
        if (encrypted) {
            String apiJsonResponse = new String(bytesToEncrypt, DEFAULT_CHARSET);
            String encryptedString = EncryptDecryptHelper.encrypt((String)apiJsonResponse);
            if (encryptedString != null) {
                return encryptedString.getBytes();
            }
            return bytesToEncrypt;
        }
        return bytesToEncrypt;
    }
}

