/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moodandstandard.controller;

import com.infinite.focus.server.moodandstandard.dto.MoodAndStandardDTO;
import com.infinite.focus.server.moodandstandard.service.MoodAndStandardService;
import com.infinite.focus.server.standard.request.GetByStandardIdRequest;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mood-and-standard"})
public class MoodAndStandardController {
    private final MoodAndStandardService moodAndStandardService;

    public MoodAndStandardController(MoodAndStandardService moodAndStandardService) {
        this.moodAndStandardService = moodAndStandardService;
    }

    @PostMapping(value={"/get-mood-and-standard-by-standard-id"})
    public ResponseEntity<List<MoodAndStandardDTO>> getMoodAndStandardByStandardId(@RequestBody GetByStandardIdRequest request) {
        return new ResponseEntity((Object)this.moodAndStandardService.getByStandardId(request.getStandard_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-mood-ids-by-standard-id"})
    public ResponseEntity<List<Long>> getMoodIdsByStandardId(@RequestHeader(value="Authorization") String token, @RequestBody GetByStandardIdRequest request) {
        return new ResponseEntity((Object)this.moodAndStandardService.getMoodIdsByStandardId(request.getStandard_id()), (HttpStatusCode)HttpStatus.OK);
    }
}

