/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.studentprofileotp.entity;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.auth.model.Status;
import com.infinite.focus.server.utils.AppUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.UUID;

@Entity
public class StudentProfileOtp {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long student_profile_otp_id;
    private String token;
    private int otp;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", columnDefinition="enum('PENDING','ACCEPTED','REJECTED')")
    private Status status;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @OneToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="account_id", foreignKey=@ForeignKey(name="none"))
    private Account account;

    public StudentProfileOtp() {
    }

    public StudentProfileOtp(Account account) {
        this.account = account;
        this.createdDate = new Date();
        this.token = UUID.randomUUID().toString();
        this.otp = AppUtils.generateRandomOtp();
        this.status = Status.PENDING;
    }

    public long getStudent_profile_otp_id() {
        return this.student_profile_otp_id;
    }

    public void setStudent_profile_otp_id(long student_profile_otp_id) {
        this.student_profile_otp_id = student_profile_otp_id;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getOtp() {
        return this.otp;
    }

    public void setOtp(int otp) {
        this.otp = otp;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }
}

