/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.district.controller;

import com.infinite.focus.server.account.entity.Account;
import com.infinite.focus.server.account.service.AccountService;
import com.infinite.focus.server.auth.request.DistrictSignUpRequest;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.clever.model.AccessToken;
import com.infinite.focus.server.clever.model.CleverDistrict;
import com.infinite.focus.server.clever.service.CleverService;
import com.infinite.focus.server.clever.service.data.CleverDataService;
import com.infinite.focus.server.clever.service.district.CleverDistrictService;
import com.infinite.focus.server.district.dto.DistrictDTO;
import com.infinite.focus.server.district.entity.District;
import com.infinite.focus.server.district.request.GetByDistrictIdRequest;
import com.infinite.focus.server.district.request.GetStudentTestReportbyDistrictRequest;
import com.infinite.focus.server.district.response.GetStudentTestReportbyDistrictResponse;
import com.infinite.focus.server.district.service.DistrictService;
import com.infinite.focus.server.message.service.MessageService;
import com.infinite.focus.server.security.helper.JwtHelper;
import com.infinite.focus.server.utils.AppUtils;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/district"})
public class DistrictController {
    @Autowired
    AuthService authService;
    @Autowired
    AccountService accountService;
    @Autowired
    CleverService cleverService;
    @Autowired
    CleverDistrictService cleverDistrictService;
    @Autowired
    CleverDataService cleverDataService;
    @Autowired
    DistrictService districtService;
    @Autowired
    MessageService messageService;
    @Autowired
    JwtHelper jwtHelper;

    @GetMapping(value={"/get-all"})
    public ResponseEntity<List<DistrictDTO>> getAll(@RequestHeader(value="Authorization") String token) {
        return new ResponseEntity((Object)this.districtService.getAll(), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/get-by-id"})
    public ResponseEntity<DistrictDTO> getById(@RequestHeader(value="Authorization") String token, @RequestBody GetByDistrictIdRequest request) {
        return new ResponseEntity((Object)this.districtService.getById(request.getDistrict_id()), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/districts"})
    public ResponseEntity<Page<District>> getDistricts(@RequestHeader(value="Authorization") String token, @RequestParam(value="district_name", defaultValue="") String districtName, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="district_id") String sortBy, @RequestParam(value="orderBy", defaultValue="asc") String orderBy) {
        this.authService.isAuthenticated(token);
        return new ResponseEntity((Object)this.districtService.getDistricts(districtName, pageNo, pageSize, sortBy, orderBy), (MultiValueMap)new HttpHeaders(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/district/{district_id}"})
    public ResponseEntity<District> getTierById(@PathVariable(value="district_id") Long district_id) {
        return new ResponseEntity((Object)this.districtService.getDistrictById(district_id.longValue()), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/get/students/count/{district_id}"})
    public ResponseEntity<Long> getStudentsCountByDistrictId(@PathVariable(value="district_id") Long district_id) {
        return new ResponseEntity((Object)this.districtService.getStudentsCountByDistrictId(district_id.longValue()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<District> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody DistrictSignUpRequest request) {
        District d = this.authService.isDistrict(token);
        if (d == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, this.messageService.getMessage("the.district.is.not.found"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getDistrict().getDistrict_name())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.district.name.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getDistrict().getCity())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.city.is.required"));
        }
        if (AppUtils.isNullOrEmpty((String)request.getDistrict().getState())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.state.is.required"));
        }
        d.setDistrict_name(request.getDistrict().getDistrict_name());
        if (!AppUtils.isNullOrEmpty((String)request.getDistrict().getClever_id())) {
            this.cleverDataService.isCleverIdAlreadyInUse(request.getDistrict().getClever_id());
            AccessToken accessToken = this.cleverService.getAccessTokenByDistrictCleverId(request.getDistrict().getClever_id());
            if (accessToken == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            CleverDistrict cleverDistrict = this.cleverDistrictService.getDistrictById(accessToken.getAccess_token(), request.getDistrict().getClever_id());
            if (cleverDistrict == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, this.messageService.getMessage("the.clever.id.is.not.valid"));
            }
            d.setClever_id(cleverDistrict.getId());
            d.setDistrict_name(cleverDistrict.getName());
        }
        Account account = this.accountService.changeEmail(d.getAccount_id(), request.getUsername());
        d.setCity(request.getDistrict().getCity());
        d.setState(request.getDistrict().getState());
        District district = this.districtService.save(d);
        String newToken = this.jwtHelper.generateToken(account.getUsername());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Authorization", newToken);
        responseHeaders.set("Authorization_Refresh_Token", this.jwtHelper.generateRefreshToken(account.getUsername()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)district);
    }

    @PostMapping(value={"/student-test-report"})
    public ResponseEntity<Page<GetStudentTestReportbyDistrictResponse>> getStudentTestReport(@RequestHeader(value="Authorization") String token, @Valid @RequestBody GetStudentTestReportbyDistrictRequest request) {
        District district = this.authService.isDistrict(token);
        Page response = this.districtService.getStudentReportbyDistrict32(Long.valueOf(district.getDistrict_id()), request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/student-test-report/search-students"})
    public ResponseEntity<Object> searchStudents(@RequestHeader(value="Authorization") String token, @Valid @RequestBody GetStudentTestReportbyDistrictRequest request) {
        District district = this.authService.isDistrict(token);
        if (district == null) {
            return ResponseEntity.badRequest().body((Object)"District not found");
        }
        List students = this.districtService.searchStudents(request, Long.valueOf(district.getDistrict_id()));
        return ResponseEntity.ok((Object)students);
    }

    @GetMapping(value={"/student-test-report/get-schools-by-name"})
    public ResponseEntity<Object> getSchoolsByName(@RequestHeader(value="Authorization") String token, @RequestParam(required=false) String schoolName) {
        District district = this.authService.isDistrict(token);
        if (district == null) {
            return ResponseEntity.badRequest().body((Object)"District not found");
        }
        List schools = this.districtService.getSchoolsByName(schoolName, Long.valueOf(district.getDistrict_id()));
        return ResponseEntity.ok((Object)schools);
    }

    @PostMapping(value={"/student-test-report/get-groups-by-name"})
    public ResponseEntity<Object> getGroupsByName(@RequestHeader(value="Authorization") String token, @RequestBody Map<String, Object> request) {
        District district = this.authService.isDistrict(token);
        if (district == null) {
            return ResponseEntity.badRequest().body((Object)"District not found");
        }
        String groupName = (String)request.get("groupName");
        List schools = (List)request.get("school_id");
        List groups = this.districtService.getGroupsByName(Long.valueOf(district.getDistrict_id()), groupName, schools);
        return ResponseEntity.ok((Object)groups);
    }
}

