/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.school.repository;

import com.infinite.focus.server.school.entity.School;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface SchoolRepository
extends JpaRepository<School, Long> {
    @Query(value="SELECT * FROM school WHERE account_id = ?1 ", nativeQuery=true)
    public List<School> findByAccountId(Long var1);

    @Query(value="SELECT * FROM school WHERE school_id = ?1 ", nativeQuery=true)
    public School findBySchoolId(Long var1);

    @Query(value="SELECT * FROM school", nativeQuery=true)
    public Page<School> findAllSchools(Pageable var1);

    @Query(value="SELECT * FROM school WHERE school_name LIKE ?1", nativeQuery=true)
    public Page<School> findBySchoolName(String var1, Pageable var2);

    @Query(value="SELECT * FROM school WHERE clever_id = ?1 ", nativeQuery=true)
    public School findByCleverSchoolId(String var1);

    @Query(value="SELECT * FROM school WHERE district_id = ?1 ORDER BY school_name", nativeQuery=true)
    public List<School> findByDistrictId(Long var1);

    @Query(value="SELECT * FROM school WHERE registration_code = ?1", nativeQuery=true)
    public School findByRegistrationCode(String var1);

    @Query(value="SELECT * FROM school WHERE license_key = ?1", nativeQuery=true)
    public List<School> findByLicenseKey(String var1);

    @Query(value="SELECT * FROM school ORDER BY school_id ASC", nativeQuery=true)
    public List<School> findAllSchoolsOrderBySchoolIdASC();

    @Query(value="SELECT sch.*,acc.username FROM school sch JOIN account acc ON sch.account_id = acc.account_id WHERE acc.username IS NOT NULL AND acc.username != ''", nativeQuery=true)
    public List<School> getAllSchools();

    @Query(value="SELECT * FROM class WHERE school_id IN (?2) AND class_name LIKE CONCAT('%', ?1, '%')", nativeQuery=true)
    public List<Object[]> getGroupsByNameAndSchoolsForStudentReport(String var1, List<Long> var2);

    @Query(value="CALL GetSocioEmotionalTestReport21(?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9, ?10, ?11)", nativeQuery=true)
    public List<Object[]> getStudentTestReportSchool(LocalDate var1, LocalDate var2, String var3, String var4, String var5, String var6, String var7, Integer var8, Integer var9, String var10, String var11);

    @Query(value="CALL GetSocioEmotionalTestReportCount21(?1, ?2, ?3, ?4, ?5, ?6, ?7)", nativeQuery=true)
    public Long getStudentTestReportSchoolPageCount(LocalDate var1, LocalDate var2, String var3, String var4, String var5, String var6, String var7);

    @Query(value="CALL GetSocioEmotionalTestReport(?1, ?2, ?3, ?4, ?5, ?6, ?7)", nativeQuery=true)
    public List<Object[]> getStudentTestReportSchoolOld(LocalDate var1, LocalDate var2, String var3, String var4, String var5, Integer var6, Integer var7);

    @Query(value="CALL GetSocioEmotionalTestReportCount(?1, ?2, ?3, ?4, ?5)", nativeQuery=true)
    public Long getStudentTestReportSchoolPageCountOld(LocalDate var1, LocalDate var2, String var3, String var4, String var5);

    @Query(value="CALL GetSocioEmotionalTestReport101(?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9, ?10, ?11, ?12, ?13)", nativeQuery=true)
    public List<Object[]> getStudentTestReportSchool43(LocalDate var1, LocalDate var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, Integer var10, Integer var11, String var12, String var13);

    @Query(value="CALL GetSocioEmotionalTestReportCount101(?1, ?2, ?3, ?4, ?5, ?6, ?7, ?8, ?9)", nativeQuery=true)
    public Long getStudentTestReportSchoolPageCount43(LocalDate var1, LocalDate var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);

    @Query(value="CALL sp_SearchStudentsSimple(?1, ?2, ?3, ?4, ?5, ?6, ?7)", nativeQuery=true)
    public List<Object[]> searchStudentsSimple(String var1, String var2, String var3, String var4, String var5, String var6, String var7);
}

