/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server;

import com.infinite.focus.server.auth.AccessCode;
import com.infinite.focus.server.auth.AccessCodeRepository;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestion;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionType;
import com.infinite.focus.server.tests.SocioEmotionalTestQuestionTypeRepository;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.http.CacheControl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ComponentScan(basePackages={"com.infinite.focus.server.activity", "com.infinite.focus.server.data", "com.infinite.focus.server.grade", "com.infinite.focus.server.dashboard", "com.infinite.focus.server.tests", "com.infinite.focus.server.lessons", "com.infinite.focus.server.notifications", "com.infinite.focus.server.students", "com.infinite.focus.server.standard", "com.infinite.focus.server.auth", "com.infinite.focus.server.wall", "com.infinite.focus.server.home", "com.infinite.focus.server.categories", "com.infinite.focus.server.encryptdecrypthelper", "com.infinite.focus.server.contents", "com.infinite.focus.server.moods", "com.infinite.focus.server.resourcelibrary", "com.infinite.focus.server.vimeo", "com.infinite.focus.server.fcm", "com.infinite.focus.server.fcm.service", "com.infinite.focus.server.fcm.model", "com.infinite.focus.server.googleapis", "com.infinite.focus.server.googleapis.services", "com.infinite.focus.server.googleapis.youtube", "com.infinite.focus.server.instructor", "com.infinite.focus.server.payment", "com.infinite.focus.server.about", "com.infinite.focus.server.utils"})
@EnableScheduling
@SpringBootApplication
@EnableAsync
public class InfiniteFocusApplication
implements WebMvcConfigurer {
    public static void main(String[] args) {
        SpringApplication.run(InfiniteFocusApplication.class, (String[])args);
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    ApplicationRunner applicationRunner(AccountRepository accountRepository, StudentRepository studentRepository, AccessCodeRepository accessCodeRepository, InstructorRepository instructorRepository, GradeRepository gradeRepository, SocioEmotionalTestQuestionRepository socioEmotionalTestQuestionRepository, SocioEmotionalTestQuestionTypeRepository socioEmotionalTestQuestionTypeRepository) {
        return args -> {
            List socioEmotionalTestQuestionTypes;
            for (Student s : studentRepository.findAll()) {
                if (s.getInstructor_id() <= 0L || s.getStatus() != null) continue;
                Instructor i = instructorRepository.findByInstructorId(Long.valueOf(s.getInstructor_id()));
                AccessCode accessCode = new AccessCode(s, i);
                accessCodeRepository.save((Object)accessCode);
            }
            List grades = gradeRepository.findAll();
            if (grades.isEmpty()) {
                Grade gradeElementary = new Grade();
                gradeElementary.setGrade_name("Elementary");
                gradeRepository.save((Object)gradeElementary);
                Grade gradeMiddle = new Grade();
                gradeMiddle.setGrade_name("Middle");
                gradeRepository.save((Object)gradeMiddle);
                Grade gradeHighSchool = new Grade();
                gradeHighSchool.setGrade_name("High School");
                gradeRepository.save((Object)gradeHighSchool);
            }
            if ((socioEmotionalTestQuestionTypes = socioEmotionalTestQuestionTypeRepository.findAll()).isEmpty()) {
                SocioEmotionalTestQuestionType socioEmotionalTestQuestionType1 = new SocioEmotionalTestQuestionType();
                socioEmotionalTestQuestionType1.setText("Responsible decision making");
                socioEmotionalTestQuestionTypeRepository.save((Object)socioEmotionalTestQuestionType1);
                SocioEmotionalTestQuestionType socioEmotionalTestQuestionType2 = new SocioEmotionalTestQuestionType();
                socioEmotionalTestQuestionType2.setText("Social Awareness");
                socioEmotionalTestQuestionTypeRepository.save((Object)socioEmotionalTestQuestionType2);
                SocioEmotionalTestQuestionType socioEmotionalTestQuestionType3 = new SocioEmotionalTestQuestionType();
                socioEmotionalTestQuestionType3.setText("Self-Management");
                socioEmotionalTestQuestionTypeRepository.save((Object)socioEmotionalTestQuestionType3);
                SocioEmotionalTestQuestionType socioEmotionalTestQuestionType4 = new SocioEmotionalTestQuestionType();
                socioEmotionalTestQuestionType4.setText("Relationship Skills");
                socioEmotionalTestQuestionTypeRepository.save((Object)socioEmotionalTestQuestionType4);
                List socioEmotionalTestQuestions = socioEmotionalTestQuestionRepository.findAll();
                for (SocioEmotionalTestQuestion socioEmotionalTestQuestion : socioEmotionalTestQuestions) {
                    int socio_emotional_test_question_id = (int)socioEmotionalTestQuestion.getSocio_emotional_test_question_id();
                    switch (socio_emotional_test_question_id) {
                        case 1: 
                        case 5: 
                        case 9: {
                            socioEmotionalTestQuestion.setSocio_emotional_test_question_type(1L);
                            break;
                        }
                        case 2: 
                        case 6: 
                        case 10: {
                            socioEmotionalTestQuestion.setSocio_emotional_test_question_type(2L);
                            break;
                        }
                        case 3: 
                        case 7: 
                        case 11: {
                            socioEmotionalTestQuestion.setSocio_emotional_test_question_type(3L);
                            break;
                        }
                        case 4: 
                        case 8: 
                        case 12: {
                            socioEmotionalTestQuestion.setSocio_emotional_test_question_type(4L);
                        }
                    }
                    socioEmotionalTestQuestionRepository.save((Object)socioEmotionalTestQuestion);
                }
            }
        };
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"classpath:/statics/"}).setCacheControl(CacheControl.maxAge((long)2L, (TimeUnit)TimeUnit.HOURS).cachePublic());
    }

    static long generateRandomNumberByTwoNumber(int n1, int n2) {
        if (n1 != n2) {
            if (n1 > n2) {
                double Random2 = (double)n2 + Math.random() * (double)(n1 - n2);
                return Math.round(Random2);
            }
            double Random3 = (double)n1 + Math.random() * (double)(n2 - n1);
            return Math.round(Random3);
        }
        System.out.println("Please provide valid Range " + n1 + " " + n2 + " are equal numbers.");
        return 1L;
    }
}

