/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.ActivityRepository;
import com.infinite.focus.server.activity.ActivityTypeRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.lessons.Lesson;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.utils.DateUtils;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/activity"})
public class ActivityController {
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private LessonRepository lessonRepository;
    private ActivityRepository activityRepository;
    private ActivityTypeRepository activityTypeRepository;

    public ActivityController(ActivityRepository activityRepository, ActivityTypeRepository activityTypeRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, LessonRepository lessonRepository) {
        this.activityRepository = activityRepository;
        this.activityTypeRepository = activityTypeRepository;
        this.studentRepository = studentRepository;
        this.instructorRepository = instructorRepository;
        this.lessonRepository = lessonRepository;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<Activity> createActivity(@RequestBody Activity request) {
        if (request.getStudent_id() != null) {
            Student s = (Student)this.studentRepository.getOne((Object)request.getStudent_id());
            request.setStudent(s);
        }
        if (request.getInstructor_id() != null) {
            Instructor i = (Instructor)this.instructorRepository.getOne((Object)request.getInstructor_id());
            request.setInstructor(i);
        }
        if (request.getActivity_type_id() == 2L) {
            Lesson lesson = this.lessonRepository.findByVideoUrl(request.getVideo_url());
            request.setEntity_id(lesson.getLesson_id());
        }
        System.out.println("StartDate " + DateUtils.dailyDateFormat.format(request.getStart_date_time()) + " End Date " + DateUtils.dailyDateFormat.format(request.getEnd_date_time()));
        return new ResponseEntity((Object)((Activity)this.activityRepository.save((Object)request)), HttpStatus.OK);
    }

    @GetMapping(value={"/set-video-duration-in-activity-in-seconds"})
    public ResponseEntity<List<Activity>> setVideoDurationInActivityInSe() {
        List activities = this.activityRepository.getAllVideoActivities();
        for (Activity activity : activities) {
            if (activity.getWatch_duration() != 0L) continue;
            long diffInActivity = this.activityRepository.getDifferenceBetweenStartDateTimeAndEndDateTimeInSecondsByActivityId(Long.valueOf(activity.getActivity_id()));
            activity.setWatch_duration(diffInActivity);
            this.activityRepository.save((Object)activity);
        }
        return new ResponseEntity((Object)activities, HttpStatus.OK);
    }
}

