/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.activity.service;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.ActivityRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.activity.service.ActivityServiceImpl;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.TimeLine;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.UnitExpression;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityServiceImpl
implements ActivityService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ActivityRepository activityRepository;
    String forwardSlash = "/";

    public List<Activity> getAllStudentActivitiesByActivityType(GetDataDashBoardRequest request, Long activity_type_id) {
        TimeLine timeLine = request.getTimeLine();
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            UnitExpression year = new UnitExpression(null, String.class, "YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            CriteriaBuilder.In gradePredicate = qb.in((Expression)s.get("grade_id")).value((Object)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("class_id")).value((Object)request.getClassIds());
            predicates.add(classesPredicate);
        }
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        if (timeLine != null) {
            Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
            System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new Date()));
            predicates.add(qb.greaterThan((Expression)root.get("start_date_time"), (Comparable)toDate));
        } else if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getAllStudentActivitiesByActivityType FromDate " + DateUtils.dayWitTimeFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dayWitTimeFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = typedQuery.getResultList();
        System.out.println("Activity Count = " + activityList.size());
        return activityList;
    }

    public List<Activity> getAllInstructorActivitiesByActivityType(GetDataDashBoardRequest request, Long activity_type_id) {
        TimeLine timeLine = request.getTimeLine();
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join i = root.join("instructor", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            CriteriaBuilder.In gradePredicate = qb.in((Expression)i.get("grade_id")).value((Object)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        predicates.add(qb.notEqual((Expression)i.get("instructor_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        if (timeLine != null) {
            Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
            System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new Date()));
            predicates.add(qb.greaterThan((Expression)root.get("start_date_time"), (Comparable)toDate));
        } else if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getAllInstructorActivitiesByActivityType FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = typedQuery.getResultList();
        System.out.println("Activity Count = " + activityList.size());
        return activityList;
    }

    public List<Long> getAllStudentActivitiesByActivityTypeIdAndEnitityId(GetDataDashBoardRequest request, Long activity_type_id, Long enitity_id) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Long.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            UnitExpression year = new UnitExpression(null, String.class, "YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            CriteriaBuilder.In gradePredicate = qb.in((Expression)s.get("grade_id")).value((Object)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("class_id")).value((Object)request.getClassIds());
            predicates.add(classesPredicate);
        }
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)activity_type_id));
        predicates.add(qb.equal((Expression)root.get("entity_id"), (Object)enitity_id));
        query.select((Selection)root.get("activity_id")).where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activity_ids = typedQuery.getResultList();
        System.out.println("Activity Count = " + activity_ids.size());
        return activity_ids;
    }

    public List<Activity> getTimeSpentByStudentIds(List<Long> student_ids, TimeLine timeLine) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        predicates.add(criteriaBuilder.equal((Expression)root.get("activity_type_id"), (Object)1));
        if (AppUtils.isNotNullOrEmpty(student_ids)) {
            CriteriaBuilder.In genderPredicate = criteriaBuilder.in((Expression)s.get("student_id")).value(student_ids);
            predicates.add(genderPredicate);
        }
        Date toDate = DateUtils.getToDateByTimeLine((TimeLine)timeLine);
        System.out.println(timeLine.toString() + " - ToDate " + DateUtils.dailyDateFormat.format(toDate) + " - FromDate " + DateUtils.dailyDateFormat.format(new Date()));
        predicates.add(criteriaBuilder.greaterThan((Expression)root.get("start_date_time"), (Comparable)toDate));
        query.where(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activityList = typedQuery.getResultList();
        System.out.println("Activity Count = " + activityList.size());
        return activityList;
    }

    public LinkedHashMap<String, List<Activity>> getActivityMapByTimeLine(TimeLine timeLine, List<Activity> activityList) {
        LinkedHashMap activityMap = null;
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$TimeLine[timeLine.ordinal()]) {
            case 1: {
                activityMap = this.fillActivityMap(DateUtils.getDailyLabels());
                for (Activity activity : activityList) {
                    String key = DateUtils.dailyDateFormat.format(activity.getStart_date_time());
                    AppUtils.addValueTotMap((LinkedHashMap)activityMap, (String)key, (Object)activity);
                }
                break;
            }
            case 2: {
                activityMap = this.fillActivityMap(DateUtils.getWeeklyLabels());
                for (Activity activity : activityList) {
                    String key = DateUtils.getWeekendByDate((Date)activity.getStart_date_time());
                    AppUtils.addValueTotMap((LinkedHashMap)activityMap, (String)key, (Object)activity);
                }
                break;
            }
            case 3: {
                activityMap = this.fillActivityMap(DateUtils.getMonthlyLabels());
                for (Activity activity : activityList) {
                    String key = DateUtils.monthlyDateFormat.format(activity.getStart_date_time());
                    AppUtils.addValueTotMap((LinkedHashMap)activityMap, (String)key, (Object)activity);
                }
                break;
            }
            case 4: {
                activityMap = this.fillActivityMap(DateUtils.getYearlyLabels());
                for (Activity activity : activityList) {
                    String key = DateUtils.yearlyDateFormat.format(activity.getStart_date_time());
                    AppUtils.addValueTotMap((LinkedHashMap)activityMap, (String)key, (Object)activity);
                }
                break;
            }
        }
        return activityMap;
    }

    private LinkedHashMap<String, List<Activity>> fillActivityMap(List<String> keys) {
        LinkedHashMap<String, List<Activity>> map = new LinkedHashMap<String, List<Activity>>();
        for (String key : keys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    public List<Activity> getMoodInsightByInstructerId(GetDataDashBoardRequest request) {
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Activity.class);
        Root root = query.from(Activity.class);
        Join s = root.join("student", JoinType.LEFT);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            CriteriaBuilder.In genderPredicate = qb.in((Expression)s.get("gender")).value((Object)request.getGenders());
            predicates.add(genderPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            UnitExpression year = new UnitExpression(null, String.class, "YEAR");
            Expression timeInYears = qb.function("TIMESTAMPDIFF", Integer.class, new Expression[]{year, s.get("date_of_birth"), qb.literal((Object)Timestamp.valueOf(LocalDateTime.now()))});
            CriteriaBuilder.In inClause = qb.in(timeInYears);
            for (Integer age : request.getAges()) {
                inClause.value((Object)age);
            }
            predicates.add(inClause);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            CriteriaBuilder.In ethnicityPredicate = qb.in((Expression)s.get("ethnicity")).value((Object)request.getEthnicity());
            predicates.add(ethnicityPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            CriteriaBuilder.In gradePredicate = qb.in((Expression)s.get("grade_id")).value((Object)request.getGradeIds());
            predicates.add(gradePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            CriteriaBuilder.In classesPredicate = qb.in((Expression)s.get("class_id")).value((Object)request.getClassIds());
            predicates.add(classesPredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_before())) {
            CriteriaBuilder.In moodUpdateBeforePredicate = qb.in((Expression)root.get("mood_update_before")).value((Object)request.getMood_update_before());
            predicates.add(moodUpdateBeforePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getMood_update_after())) {
            CriteriaBuilder.In moodUpdateAfterPredicate = qb.in((Expression)root.get("mood_update_after")).value((Object)request.getMood_update_after());
            predicates.add(moodUpdateAfterPredicate);
        }
        if (request.getFromDate() != null && request.getToDate() != null) {
            System.out.println("getMoodInsightByInstructerId FromDate " + DateUtils.dailyDateFormat.format(request.getFromDate()) + " - ToDate " + DateUtils.dailyDateFormat.format(request.getToDate()));
            predicates.add(qb.between((Expression)root.get("start_date_time"), (Comparable)request.getFromDate(), (Comparable)request.getToDate()));
        }
        predicates.add(qb.notEqual((Expression)s.get("student_id"), (Object)0L));
        predicates.add(qb.equal((Expression)s.get("instructor_id"), (Object)request.getInstructor_id()));
        predicates.add(qb.equal((Expression)root.get("activity_type_id"), (Object)2));
        query.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{qb.asc((Expression)root.get("end_date_time"))});
        TypedQuery typedQuery = this.entityManager.createQuery(query);
        List activities = typedQuery.getResultList();
        return activities;
    }
}

