/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.Status;
import com.infinite.focus.server.auth.Student;
import java.util.Date;
import java.util.Random;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
public class AccessCode {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="access_code_id")
    private long accessCodeId;
    @Transient
    private long student_id;
    @Transient
    private long instructor_id;
    @Column(name="access_code")
    private String accessCode;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", columnDefinition="enum('PENDING','ACCEPTED','REJECTED')")
    private Status status;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @OneToOne(targetEntity=Student.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="student_id")
    private Student student;
    @OneToOne(targetEntity=Instructor.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="instructor_id")
    private Instructor instructor;

    public AccessCode() {
    }

    public AccessCode(Student student, Instructor instructor) {
        this.student = student;
        this.instructor = instructor;
        this.accessCode = this.getRandomNumberString();
        this.status = Status.PENDING;
        this.createdDate = new Date();
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public long getStudent_id() {
        return this.student.getStudent_id();
    }

    public void setStudent_id(long student_id) {
        this.student_id = student_id;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setStudent(Student student) {
        this.student = student;
    }

    public Student getStudent() {
        return this.student;
    }

    public void setInstructor(Instructor instructor) {
        this.instructor = instructor;
    }

    public Instructor getInstructor() {
        return this.instructor;
    }

    public long getInstructor_id() {
        return this.instructor.getInstructor_id();
    }

    public void setInstructor_id(long instructor_id) {
        this.instructor_id = instructor_id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getAccessCodeId() {
        return this.accessCodeId;
    }

    public void setAccessCodeId(long accessCodeId) {
        this.accessCodeId = accessCodeId;
    }

    @JsonIgnore
    public String getRandomNumberString() {
        Random rnd = new Random();
        int number = rnd.nextInt(999999);
        return String.format("%06d", number);
    }
}

