/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.infinite.focus.server.auth.AccessCode;
import com.infinite.focus.server.auth.AccessCodeRepository;
import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountDataWrapper;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Admin;
import com.infinite.focus.server.auth.AdminRepository;
import com.infinite.focus.server.auth.Avatar;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.ChangePasswordRequest;
import com.infinite.focus.server.auth.CheckLicenseKeyStatusRequest;
import com.infinite.focus.server.auth.ConfirmationToken;
import com.infinite.focus.server.auth.ConfirmationTokenRepository;
import com.infinite.focus.server.auth.District;
import com.infinite.focus.server.auth.DistrictRepository;
import com.infinite.focus.server.auth.DistrictSignUpRequest;
import com.infinite.focus.server.auth.EmailSenderService;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.InstructorSignUpRequest;
import com.infinite.focus.server.auth.KeyGenerator;
import com.infinite.focus.server.auth.LicensesStatusResponse;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.NotFoundException;
import com.infinite.focus.server.auth.PayKickStartService;
import com.infinite.focus.server.auth.ResetPasswordRequest;
import com.infinite.focus.server.auth.School;
import com.infinite.focus.server.auth.SchoolRepository;
import com.infinite.focus.server.auth.SchoolSignUpRequest;
import com.infinite.focus.server.auth.Status;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.auth.StudentSignUpRequest;
import com.infinite.focus.server.auth.StudentsSignUpRequest;
import com.infinite.focus.server.auth.TimeOutException;
import com.infinite.focus.server.standard.Standard;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/auth"})
public class AuthenticationController {
    @Value(value="${app.base-url}")
    private String appBaseUrl;
    private static final int INSTRUCTOR = 2;
    private static final int STUDENT = 1;
    private static final int ADMIN = 3;
    private static final int SCHOOL = 4;
    private static final int DISTRICT = 5;
    private static AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private StandardRepository standardRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private AdminRepository adminRepository;
    private SchoolRepository schoolRepository;
    private DistrictRepository districtRepository;
    private AccessCodeRepository accessCodeRepository;
    @Autowired
    private ConfirmationTokenRepository confirmationTokenRepository;
    @Autowired
    private EmailSenderService emailSenderService;
    @Autowired
    private PayKickStartService payKickStartService;

    public AuthenticationController(DistrictRepository districtRepository, SchoolRepository schoolRepository, AdminRepository adminRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, StandardRepository standardRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder, AccessCodeRepository accessCodeRepository) {
        this.districtRepository = districtRepository;
        this.schoolRepository = schoolRepository;
        this.adminRepository = adminRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.standardRepository = standardRepository;
        AuthenticationController.accountRepository = accountRepository;
        this.accessCodeRepository = accessCodeRepository;
    }

    @GetMapping(value={"/get/data"})
    public ResponseEntity<AccountDataWrapper> getUserData(@RequestHeader(value="Authorization") String token, @RequestHeader(value="operating_system", required=false) String operating_system, @RequestHeader(value="browser", required=false) String browser) throws IOException {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = accountRepository.findByUsername(user);
                if (a == null && (a = accountRepository.findByUsername2(user)) == null) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                Admin ad = this.adminRepository.findByUserName(user);
                if (ad != null) {
                    AccountDataWrapper adw = new AccountDataWrapper();
                    adw.setType(3);
                    Instructor i = this.instructorRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                    if (i != null) {
                        adw.setI(i);
                    }
                    return new ResponseEntity((Object)adw, HttpStatus.OK);
                }
                Instructor i = this.instructorRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                if (i != null) {
                    if (i.getLicense_key() == null) {
                        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The license key is not found!!!.");
                    }
                    LicensesStatusResponse licensesStatusResponse = this.payKickStartService.getLicensesStatus(i.getLicense_key());
                    if (licensesStatusResponse.getData() == null) {
                        throw new ResponseStatusException(HttpStatus.CONFLICT, licensesStatusResponse.getMessage());
                    }
                    if (licensesStatusResponse.getData().getValid() != 1) {
                        throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not a valid license Key.");
                    }
                    if (licensesStatusResponse.getData().getActive() != 1) {
                        throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not an active license Key.");
                    }
                    i.setOperating_system(operating_system);
                    i.setBrowser(browser);
                    this.instructorRepository.save((Object)i);
                    AccountDataWrapper adw = new AccountDataWrapper();
                    adw.setI(i);
                    adw.setType(2);
                    return new ResponseEntity((Object)adw, HttpStatus.OK);
                }
                Student s = this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                if (s != null) {
                    Instructor instructor;
                    s.setIsVerified(true);
                    AccessCode accessCode = this.accessCodeRepository.findByStudentId(Long.valueOf(s.getStudent_id()));
                    if (accessCode != null) {
                        if (accessCode.getStatus() == Status.PENDING) {
                            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The teacher has not verified your account.");
                        }
                        if (accessCode.getStatus() == Status.REJECTED) {
                            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The teacher has rejected your account.");
                        }
                    }
                    if ((instructor = this.instructorRepository.findByInstructorId(Long.valueOf(s.getInstructor_id()))).getLicense_key() == null) {
                        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The license key is not found!!!.");
                    }
                    LicensesStatusResponse licensesStatusResponse = this.payKickStartService.getLicensesStatus(instructor.getLicense_key());
                    if (licensesStatusResponse.getData() == null) {
                        throw new ResponseStatusException(HttpStatus.CONFLICT, licensesStatusResponse.getMessage());
                    }
                    if (licensesStatusResponse.getData().getValid() != 1) {
                        throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not a valid license Key.");
                    }
                    if (licensesStatusResponse.getData().getActive() != 1) {
                        throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not an active license Key.");
                    }
                    s.setOperating_system(operating_system);
                    s.setBrowser(browser);
                    this.studentRepository.save((Object)s);
                    AccountDataWrapper adw = new AccountDataWrapper();
                    if (s.getStandard_id() > 0L) {
                        Standard standard = s.getStandard();
                        adw.setStd(standard);
                    }
                    adw.setS(s);
                    adw.setType(1);
                    return new ResponseEntity((Object)adw, HttpStatus.OK);
                }
                School school = this.schoolRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                if (school != null) {
                    AccountDataWrapper adw = new AccountDataWrapper();
                    adw.setSchool(school);
                    adw.setType(4);
                    return new ResponseEntity((Object)adw, HttpStatus.OK);
                }
                District district = this.districtRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                if (district != null) {
                    AccountDataWrapper adw = new AccountDataWrapper();
                    adw.setDistrict(district);
                    adw.setType(5);
                    return new ResponseEntity((Object)adw, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/sign-up/instructor"})
    @ResponseBody
    public ResponseEntity<Instructor> signUpInstructor(@RequestBody InstructorSignUpRequest request) throws IOException {
        Account a = accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        this.checkLicenseKeyStatus(request.getInstructor().getLicense_key());
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)accountRepository.save((Object)account);
        Instructor instructor = new Instructor();
        instructor.setFirst_name(request.getInstructor().getFirst_name());
        instructor.setLast_name(request.getInstructor().getLast_name());
        instructor.setAccount_id(a.getAccount_id());
        instructor.setSchool_id(request.getInstructor().getSchool_id());
        instructor.setGrade_id(request.getInstructor().getGrade_id());
        instructor.setStandard_id(request.getInstructor().getStandard_id());
        instructor.setLicense_key(request.getInstructor().getLicense_key());
        instructor.setState(request.getInstructor().getState());
        instructor.setCity(request.getInstructor().getCity());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            Instructor x = this.instructorRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                instructor.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        Instructor i = (Instructor)this.instructorRepository.save((Object)instructor);
        return new ResponseEntity((Object)i, HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/district"})
    @ResponseBody
    public ResponseEntity<District> signUpDistrict(@RequestBody DistrictSignUpRequest request) {
        Account a = accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)accountRepository.save((Object)account);
        District d = new District();
        d.setDistrict_name(request.getDistrict().getDistrict_name());
        d.setCity(request.getDistrict().getCity());
        d.setState(request.getDistrict().getState());
        d.setAccount_id(a.getAccount_id());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            District x = this.districtRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                d.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        this.districtRepository.save((Object)d);
        return new ResponseEntity((Object)d, HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/school"})
    @ResponseBody
    public ResponseEntity<School> signUpSchool(@RequestBody SchoolSignUpRequest request) throws IOException {
        Account a = accountRepository.findByUsername(request.getUsername());
        if (a != null) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        this.checkLicenseKeyStatus(request.getSchool().getLicense_key());
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        a = (Account)accountRepository.save((Object)account);
        School s = new School();
        s.setAddress(request.getSchool().getAddress());
        s.setSchool_name(request.getSchool().getSchool_name());
        s.setDistrict_id(request.getSchool().getDistrict_id());
        s.setAccount_id(a.getAccount_id());
        s.setLicense_key(request.getSchool().getLicense_key());
        Boolean isUnique = false;
        while (!isUnique.booleanValue()) {
            String possible_code = KeyGenerator.generateUniqueAuthCode();
            School x = this.schoolRepository.findByRegistrationCode(possible_code);
            if (x == null) {
                isUnique = true;
                s.setRegistration_code(possible_code);
                continue;
            }
            isUnique = false;
        }
        this.schoolRepository.save((Object)s);
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/schools"})
    public ResponseEntity<List<School>> getAllSchools() {
        return new ResponseEntity((Object)this.schoolRepository.findAll(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/all/districts"})
    public ResponseEntity<List<District>> getAllDistricts() {
        return new ResponseEntity((Object)this.districtRepository.findAll(), HttpStatus.OK);
    }

    @PostMapping(value={"/import/students"})
    @ResponseBody
    public ResponseEntity<List<Student>> importStudents(@RequestBody List<StudentsSignUpRequest> students) throws IOException {
        ArrayList<Student> registredStudetns = new ArrayList<Student>();
        for (StudentsSignUpRequest request : students) {
            Account account = new Account();
            account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
            Account a = (Account)accountRepository.save((Object)account);
            this.studentRepository.insertStudent(a.getAccount_id(), 0L, 0L, "", request.getFirst_name(), "", 0L, 0L, request.getLast_name(), false, 0L, null, false, null, null);
            Student s = this.studentRepository.getLastRegisteredStudent();
            registredStudetns.add(s);
        }
        return new ResponseEntity(registredStudetns, HttpStatus.OK);
    }

    @PostMapping(value={"/first/sign-in/student"})
    @ResponseBody
    public ResponseEntity<Student> firstSignInStudent(@RequestBody StudentsSignUpRequest request) throws IOException {
        List students = this.studentRepository.findStudentByFirstNameAndLastName(request.getFirst_name(), request.getLast_name());
        if (AppUtils.isNotNullOrEmpty((List)students)) {
            for (Student student : students) {
                Account a = accountRepository.findByAccountId(student.getAccount_id());
                if (!this.bCryptPasswordEncoder.matches((CharSequence)request.getPassword(), a.getPassword())) continue;
                return new ResponseEntity((Object)student, HttpStatus.OK);
            }
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/first/sign-in/update/student-details"})
    @ResponseBody
    public ResponseEntity<Student> firstSignInUpdateStudentDetails(@RequestBody StudentSignUpRequest request) throws IOException {
        Instructor instructor = this.instructorRepository.findByInstructorId(Long.valueOf(request.getStudent().getInstructor_id()));
        if (instructor.getLicense_key() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The license key is not found!!!.");
        }
        LicensesStatusResponse licensesStatusResponse = this.payKickStartService.getLicensesStatus(instructor.getLicense_key());
        if (licensesStatusResponse.getData() == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, licensesStatusResponse.getMessage());
        }
        if (licensesStatusResponse.getData().getValid() != 1) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not a valid license Key.");
        }
        if (licensesStatusResponse.getData().getActive() != 1) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not an active license Key.");
        }
        Account a = accountRepository.findByUsername(request.getUsername());
        Account b = accountRepository.findByUsername2(request.getUsername2());
        if (a != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The email address is already exist!!!");
        }
        if (b != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The username is already exist!!!");
        }
        int age = DateUtils.getAge((Date)request.getStudent().getDate_of_birth());
        if (age < 4 || age > 19) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The age must be 4-19.");
        }
        Account account = accountRepository.findByAccountId(request.getStudent().getAccount_id());
        if (account == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Account not found!!!");
        }
        account.setUsername(request.getUsername());
        account.setUsername2(request.getUsername2());
        a = (Account)accountRepository.save((Object)account);
        Avatar avatar = (Avatar)this.avatarRepository.getOne((Object)request.getStudent().getAvatar_id());
        Standard std = (Standard)this.standardRepository.getOne((Object)request.getStudent().getStandard_id());
        Student student = this.studentRepository.findByStudenttId(Long.valueOf(request.getStudent().getStudent_id()));
        if (student == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Student not found!!!");
        }
        student.setFirst_name(request.getStudent().getFirst_name());
        student.setLast_name(request.getStudent().getLast_name());
        student.setInstructor_id(request.getStudent().getInstructor_id());
        student.setAccount(a);
        student.setAvatar(avatar);
        student.setDate_of_birth(request.getStudent().getDate_of_birth());
        student.setEthnicity(request.getStudent().getEthnicity());
        student.setGender(request.getStudent().getGender());
        student.setGrade_id(request.getStudent().getGrade_id());
        student.setStandard(std);
        student.setAppType(request.getStudent().getAppType());
        student.setOperating_system(request.getStudent().getOperating_system());
        student.setBrowser(request.getStudent().getBrowser());
        Student s = (Student)this.studentRepository.save((Object)student);
        Instructor i = this.instructorRepository.findByInstructorId(Long.valueOf(request.getStudent().getInstructor_id()));
        AccessCode accessCode = new AccessCode(s, i);
        this.accessCodeRepository.save((Object)accessCode);
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @PostMapping(value={"/sign-up/student"})
    @ResponseBody
    public ResponseEntity<Student> signUpCompany(@RequestBody StudentSignUpRequest request) throws IOException {
        Instructor instructor = this.instructorRepository.findByInstructorId(Long.valueOf(request.getStudent().getInstructor_id()));
        if (instructor.getLicense_key() == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The license key is not found!!!.");
        }
        LicensesStatusResponse licensesStatusResponse = this.payKickStartService.getLicensesStatus(instructor.getLicense_key());
        if (licensesStatusResponse.getData() == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, licensesStatusResponse.getMessage());
        }
        if (licensesStatusResponse.getData().getValid() != 1) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not a valid license Key.");
        }
        if (licensesStatusResponse.getData().getActive() != 1) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not an active license Key.");
        }
        Account a = accountRepository.findByUsername(request.getUsername());
        Account b = accountRepository.findByUsername2(request.getUsername2());
        if (a != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The email address is already exist!!!");
        }
        if (b != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The username is already exist!!!");
        }
        int age = DateUtils.getAge((Date)request.getStudent().getDate_of_birth());
        if (age < 4 || age > 19) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The age must be 4-19.");
        }
        Account account = new Account();
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)request.getPassword()));
        account.setUsername(request.getUsername());
        account.setUsername2(request.getUsername2());
        a = (Account)accountRepository.save((Object)account);
        Avatar avatar = (Avatar)this.avatarRepository.getOne((Object)request.getStudent().getAvatar_id());
        Standard std = (Standard)this.standardRepository.getOne((Object)request.getStudent().getStandard_id());
        Student student = new Student();
        student.setFirst_name(request.getStudent().getFirst_name());
        student.setLast_name(request.getStudent().getLast_name());
        student.setInstructor_id(request.getStudent().getInstructor_id());
        student.setAccount(a);
        student.setAvatar(avatar);
        student.setDate_of_birth(request.getStudent().getDate_of_birth());
        student.setEthnicity(request.getStudent().getEthnicity());
        student.setGender(request.getStudent().getGender());
        student.setGrade_id(request.getStudent().getGrade_id());
        student.setStandard(std);
        student.setAppType(request.getStudent().getAppType());
        student.setOperating_system(request.getStudent().getOperating_system());
        student.setBrowser(request.getStudent().getBrowser());
        Student s = (Student)this.studentRepository.save((Object)student);
        Instructor i = this.instructorRepository.findByInstructorId(Long.valueOf(request.getStudent().getInstructor_id()));
        AccessCode accessCode = new AccessCode(s, i);
        this.accessCodeRepository.save((Object)accessCode);
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @GetMapping(value={"/search/school"})
    public ResponseEntity<School> searchForSchool(@RequestParam(value="code", defaultValue="aEn24") String code) {
        School s = this.schoolRepository.findByRegistrationCode(code);
        if (s == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.schoolRepository.findByRegistrationCode(code), HttpStatus.OK);
    }

    @GetMapping(value={"/search/district"})
    public ResponseEntity<District> searchForDistrict(@RequestParam(value="code", defaultValue="aEn24") String code) {
        District d = this.districtRepository.findByRegistrationCode(code);
        if (d == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.districtRepository.findByRegistrationCode(code), HttpStatus.OK);
    }

    @GetMapping(value={"/search/instructor"})
    public ResponseEntity<Instructor> searchForInstructor(@RequestParam(value="code", defaultValue="aEn24") String code) {
        Instructor i = this.instructorRepository.findByRegistrationCode(code);
        if (i == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.instructorRepository.findByRegistrationCode(code), HttpStatus.OK);
    }

    @GetMapping(value={"/search/instructorWithGradeId"})
    public ResponseEntity<Instructor> searchForInstructorWithGrade(@RequestParam(value="code", defaultValue="aEn24") String code, @RequestParam(value="grade_id", defaultValue="aEn24") Integer grade_id) {
        Instructor i = this.instructorRepository.findByRegistrationCodeAndGradeId(code, grade_id);
        if (i == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Teacher could not be found");
        }
        return new ResponseEntity((Object)this.instructorRepository.findByRegistrationCode(code), HttpStatus.OK);
    }

    @GetMapping(value={"/set/avatar"})
    public ResponseEntity<Student> searchForInstructor(@RequestParam(value="student_id", defaultValue="aEn24") long student_id, @RequestParam(value="avatar_id", defaultValue="aEn24") long avatar_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        Avatar a = (Avatar)this.avatarRepository.getOne((Object)avatar_id);
        if (a == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        s.setAvatar_id(avatar_id);
        return new ResponseEntity((Object)((Student)this.studentRepository.save((Object)s)), HttpStatus.OK);
    }

    @GetMapping(value={"/get/avatars"})
    public ResponseEntity<List<Avatar>> getAvatars() {
        return new ResponseEntity((Object)this.avatarRepository.findAll(), HttpStatus.OK);
    }

    @GetMapping(value={"/check-username-availability"})
    public ResponseEntity<Message> checkUsernameAvailability(@RequestParam(value="username") String username) {
        Account account = accountRepository.findByUsername(username);
        if (account != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "This email already registered.");
        }
        Message message = new Message("This email not registred.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @GetMapping(value={"/check-username2-availability"})
    public ResponseEntity<Message> checkUsername2Availability(@RequestParam(value="username2") String username2) {
        Account existingUser = accountRepository.findByUsername2(username2);
        if (existingUser != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "This user name is not available.");
        }
        Message message = new Message("This user name is available.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/check-licenses-key-status"})
    public ResponseEntity<Message> checkLicenseKeyStatus(@RequestBody CheckLicenseKeyStatusRequest request) throws IOException {
        this.checkLicenseKeyStatus(request.getLicense_key());
        Message message = new Message("The license key is an active license Key.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    private void checkLicenseKeyStatus(String license_key) throws IOException {
        List instructors = this.instructorRepository.findByLicenseKey(license_key);
        if (instructors != null && !instructors.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is already exists.");
        }
        List schools = this.schoolRepository.findByLicenseKey(license_key);
        if (schools != null && !schools.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is already exists.");
        }
        this.isActiveAndValidLicenseKey(license_key);
    }

    private void isActiveAndValidLicenseKey(String license_key) throws IOException {
        LicensesStatusResponse licensesStatusResponse = this.payKickStartService.getLicensesStatus(license_key);
        if (licensesStatusResponse.getData() == null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, licensesStatusResponse.getMessage());
        }
        if (licensesStatusResponse.getData().getValid() != 1) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not a valid license Key.");
        }
        if (licensesStatusResponse.getData().getActive() != 1) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The license key is not an active license Key.");
        }
    }

    @PostMapping(value={"/is-active-user"})
    public ResponseEntity<Message> isActiveUser(@RequestHeader(value="Authorization") String token) throws IOException {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account a = accountRepository.findByUsername(user);
            if (a == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            String license_key = null;
            Instructor instructor = this.instructorRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
            if (instructor == null) {
                School school = this.schoolRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
                if (school == null) {
                    throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
                }
                license_key = school.getLicense_key();
            } else {
                license_key = instructor.getLicense_key();
            }
            if (license_key == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The license key is not found!!!.");
            }
            this.isActiveAndValidLicenseKey(license_key);
            Message message = new Message("The license key is an active license Key.");
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        throw new NotFoundException("User not found!!!");
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<Message> forgotUserPassword(@RequestParam(value="username") String username) {
        Account account = accountRepository.findByUsername(username);
        String errorMessage = "This email does not exist!";
        if (account == null) {
            account = accountRepository.findByUsername2(username);
            errorMessage = "This email or username does not exist!";
        }
        if (account == null) {
            throw new NotFoundException(errorMessage);
        }
        ConfirmationToken confirmationToken = new ConfirmationToken(account);
        this.confirmationTokenRepository.save((Object)confirmationToken);
        String baseUrl = this.appBaseUrl + "#/reset/password/";
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(account.getUsername());
        mailMessage.setSubject("Reset Your Infinite Focus Schools Password");
        mailMessage.setText("Forgot your password? Let's get you a new one.\r\nWe got a request to change the password for your account.\r\n\r\n\n\nIf you don't want to reset your password, you can ignore this email.\r\n\r\n\n\nReset Password " + baseUrl + confirmationToken.getConfirmationToken() + "\r\n\n\nThanks,\r\nInfinite Focus Schools");
        this.emailSenderService.sendEmail(mailMessage);
        Message message = new Message("Request to reset password received. Check your inbox for the reset link.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    @PostMapping(value={"/confirm-reset"})
    public ResponseEntity<Message> validateResetToken(@RequestBody ResetPasswordRequest resetPasswordRequest) {
        ConfirmationToken token = this.confirmationTokenRepository.findByConfirmationToken(resetPasswordRequest.getToken());
        if (token != null) {
            long diff = new Date().getTime() - token.getCreatedDate().getTime();
            long diffMinutes = diff / 60000L;
            if (diffMinutes > 15L) {
                throw new TimeOutException("The link has been expired." + diffMinutes);
            }
            Message message = new Message("The tokne matched.");
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        throw new NotFoundException("The tokne not found.");
    }

    @PostMapping(value={"/reset-password"})
    public ResponseEntity<Message> resetUserPassword(@RequestBody ResetPasswordRequest resetPasswordRequest) {
        ConfirmationToken token = this.confirmationTokenRepository.findByConfirmationToken(resetPasswordRequest.getToken());
        if (token == null) {
            throw new NotFoundException("The tokne not found.");
        }
        String username = token.getAccount().getUsername();
        if (username == null || username.isEmpty()) {
            throw new NotFoundException("The email not found.");
        }
        long diff = new Date().getTime() - token.getCreatedDate().getTime();
        long diffMinutes = diff / 60000L;
        if (diffMinutes > 15L) {
            throw new TimeOutException("The link has been expired." + diffMinutes);
        }
        Account account = accountRepository.findByUsername(username);
        account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)resetPasswordRequest.getPassword()));
        accountRepository.save((Object)account);
        this.confirmationTokenRepository.delete((Object)token);
        Message message = new Message("Password successfully reset. You can now log in with the new credentials.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    public static boolean isValid(String email) {
        String regex = "^[\\w-_\\.+]*[\\w-_\\.]\\@([\\w]+\\.)+[\\w]+[\\w]$";
        return email.matches(regex);
    }

    @PostMapping(value={"/change-password"})
    public ResponseEntity<Message> changePassword(@RequestHeader(value="Authorization") String token, @RequestBody ChangePasswordRequest changePasswordRequest) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account account = accountRepository.findByUsername(user);
            if (account == null && (account = accountRepository.findByUsername2(user)) == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Accout not found.");
            }
            if (changePasswordRequest == null) {
                throw new ResponseStatusException(HttpStatus.CONFLICT, "The request params does not match.");
            }
            changePasswordRequest.validatePassword(this.bCryptPasswordEncoder, account.getPassword());
            account.setPassword(this.bCryptPasswordEncoder.encode((CharSequence)changePasswordRequest.getNewPassword()));
            accountRepository.save((Object)account);
            Message message = new Message("Password successfully reset. You can now log in with the new credentials.");
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "");
    }

    public static boolean isAuthenticated(String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = accountRepository.findByUsername(user);
                if (a == null && (a = accountRepository.findByUsername2(user)) == null) {
                    throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
                }
                return true;
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
    }
}

