/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.infinite.focus.server.auth.Instructor;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface InstructorRepository
extends JpaRepository<Instructor, Long> {
    @Query(value="SELECT * FROM instructor ORDER BY instructor_id", nativeQuery=true)
    public List<Instructor> findAllOrderById();

    @Query(value="SELECT * FROM instructor WHERE account_id = ?1 ", nativeQuery=true)
    public Instructor findByAccountId(Long var1);

    @Query(value="SELECT * FROM instructor WHERE instructor_id = ?1 ", nativeQuery=true)
    public Instructor findByInstructorId(Long var1);

    @Query(value="SELECT * FROM instructor WHERE school_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<Instructor> findBySchoolId(Long var1);

    @Query(value="SELECT * FROM instructor WHERE registration_code = ?1", nativeQuery=true)
    public Instructor findByRegistrationCode(String var1);

    @Query(value="SELECT * FROM instructor WHERE registration_code = ?1 AND grade_id = ?2", nativeQuery=true)
    public Instructor findByRegistrationCodeAndGradeId(String var1, Integer var2);

    @Query(value="SELECT * FROM instructor WHERE license_key = ?1", nativeQuery=true)
    public List<Instructor> findByLicenseKey(String var1);

    @Query(value="SELECT COUNT(*) FROM instructor WHERE grade_id = ?1", nativeQuery=true)
    public Long getCountByGradeId(Long var1);

    @Query(value="SELECT COUNT(*) FROM instructor WHERE standard_id = ?1", nativeQuery=true)
    public Long getCountByStandardId(Long var1);

    @Query(value="SELECT a.username FROM instructor i LEFT JOIN account a ON a.account_id = i.account_id", nativeQuery=true)
    public List<String> getAllInstructorsEmailAddresses();

    @Query(value="SELECT COALESCE(inst.operating_system, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM instructor)),2) as percentage FROM instructor inst group by inst.operating_system", nativeQuery=true)
    public List<Object[]> getInstructorCountAndPercentageByUseOfOS();

    @Query(value="SELECT COALESCE(inst.browser, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM instructor)),2) as percentage FROM instructor inst group by inst.browser", nativeQuery=true)
    public List<Object[]> getInstructorCountAndPercentageByUseOfBrowser();
}

