/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JWTAuthorizationFilter
extends BasicAuthenticationFilter {
    public JWTAuthorizationFilter(AuthenticationManager authManager) {
        super(authManager);
    }

    protected void doFilterInternal(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String header = req.getHeader("Authorization");
        if (header == null || !header.startsWith("Bearer ")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(req);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token == "" || token.contains("undefined")) {
            return null;
        }
        if (token != null) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                return new UsernamePasswordAuthenticationToken((Object)user, null, new ArrayList());
            }
            return null;
        }
        return null;
    }
}

