/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.infinite.focus.server.auth.AccessCode;
import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.Avatar;
import com.infinite.focus.server.auth.Status;
import com.infinite.focus.server.standard.Standard;
import com.infinite.focus.server.students.AppType;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
public class Student {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long student_id;
    @Transient
    private long account_id;
    @Transient
    private long standard_id;
    private long class_id;
    private long grade_id;
    private long instructor_id;
    private String first_name;
    private String last_name;
    private String gender;
    private String ethnicity;
    @Transient
    private long avatar_id;
    private boolean is_verified = false;
    private boolean should_force_socio_emotional_assessment = false;
    @Transient
    public String username;
    @Transient
    public String username2;
    @Transient
    public String avatar_name;
    @Transient
    public String avatar_url;
    @Transient
    private Status status;
    @OneToOne(targetEntity=Standard.class, fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="standard_id")
    @JsonIgnore
    private Standard standard;
    @OneToOne(targetEntity=Avatar.class, fetch=FetchType.LAZY)
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinColumn(nullable=true, name="avatar_id")
    @JsonIgnore
    private Avatar avatar;
    @OneToOne(targetEntity=Account.class, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="account_id")
    @JsonIgnore
    private Account account;
    @OneToOne(fetch=FetchType.EAGER, mappedBy="student")
    @JsonIgnore
    private AccessCode accessCode;
    private String fcm_token;
    @Enumerated(value=EnumType.STRING)
    @Column(name="app_type", columnDefinition="enum('ANDROID','WEB')")
    private AppType appType;
    private Date date_of_birth;
    private String operating_system;
    private String browser;

    public long getStudent_id() {
        return this.student_id;
    }

    public void setStudent_id(long student_id) {
        this.student_id = student_id;
    }

    public long getAccount_id() {
        return this.account == null ? this.account_id : this.account.getAccount_id();
    }

    public void setAccount_id(long account_id) {
        this.account_id = account_id;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public long getStandard_id() {
        return this.standard == null ? this.standard_id : this.standard.getStandard_id();
    }

    public void setStandard_id(long standard_id) {
        this.standard_id = standard_id;
    }

    public Standard getStandard() {
        return this.standard;
    }

    public void setStandard(Standard standard) {
        this.standard = standard;
    }

    public AccessCode getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(AccessCode accessCode) {
        this.accessCode = accessCode;
    }

    public Status getStatus() {
        return this.accessCode == null ? this.status : this.accessCode.getStatus();
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getInstructor_id() {
        return this.instructor_id;
    }

    public void setInstructor_id(long instructor_id) {
        this.instructor_id = instructor_id;
    }

    public String getFirst_name() {
        return this.first_name;
    }

    public void setFirst_name(String first_name) {
        this.first_name = first_name;
    }

    public String getLast_name() {
        return this.last_name;
    }

    public void setLast_name(String last_name) {
        this.last_name = last_name;
    }

    public long getAvatar_id() {
        return this.avatar == null ? this.avatar_id : this.avatar.getAvatar_id();
    }

    public void setAvatar_id(long avatar_id) {
        this.avatar_id = avatar_id;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public long getGrade_id() {
        return this.grade_id;
    }

    public void setGrade_id(long grade_id) {
        this.grade_id = grade_id;
    }

    public long getClass_id() {
        return this.class_id;
    }

    public void setClass_id(long class_id) {
        this.class_id = class_id;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    public String getUsername() {
        return this.account == null ? this.username : this.account.getUsername();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername2() {
        return this.account == null ? this.username2 : this.account.getUsername2();
    }

    public void setUsername2(String username2) {
        this.username2 = username2;
    }

    public String getAvatar_name() {
        if (this.avatar != null) {
            return this.avatar.getAvatar_name();
        }
        return null;
    }

    public void setAvatar_name(String avatar_name) {
        this.avatar_name = avatar_name;
    }

    public String getAvatar_url() {
        if (this.avatar != null) {
            return this.avatar.getPreview_url();
        }
        return null;
    }

    public void setAvatar_url(String avatar_url) {
        this.avatar_url = avatar_url;
    }

    public boolean isVerified() {
        return this.is_verified;
    }

    public void setIsVerified(boolean is_verified) {
        this.is_verified = is_verified;
    }

    public String getFcm_token() {
        return this.fcm_token;
    }

    public void setFcm_token(String fcm_token) {
        this.fcm_token = fcm_token;
    }

    public boolean isShould_force_socio_emotional_assessment() {
        return this.should_force_socio_emotional_assessment;
    }

    public void setShould_force_socio_emotional_assessment(boolean should_force_socio_emotional_assessment) {
        this.should_force_socio_emotional_assessment = should_force_socio_emotional_assessment;
    }

    public AppType getAppType() {
        return this.appType;
    }

    public void setAppType(AppType appType) {
        this.appType = appType;
    }

    public Date getDate_of_birth() {
        return this.date_of_birth;
    }

    public void setDate_of_birth(Date date_of_birth) {
        this.date_of_birth = date_of_birth;
    }

    public String getOperating_system() {
        return this.operating_system;
    }

    public void setOperating_system(String operating_system) {
        this.operating_system = operating_system;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }
}

