/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth;

import com.infinite.focus.server.auth.Student;
import java.math.BigInteger;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface StudentRepository
extends JpaRepository<Student, Long> {
    @Query(value="SELECT * FROM student WHERE account_id = ?1", nativeQuery=true)
    public Student findByAccountId(Long var1);

    @Query(value="SELECT * FROM student WHERE student_id = ?1", nativeQuery=true)
    public Student findByStudenttId(Long var1);

    @Query(value="SELECT * FROM student WHERE instructor_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<Student> findByInstructorId(Long var1);

    @Query(value="SELECT * FROM student WHERE class_id = ?1 ORDER BY first_name", nativeQuery=true)
    public List<Student> findByClassId(Long var1);

    @Query(value="SELECT * FROM student ORDER BY student_id", nativeQuery=true)
    public List<Student> findAllOrderById();

    @Query(value="SELECT * FROM student WHERE student_id in :ids ORDER BY student_id", nativeQuery=true)
    public List<Student> findByStudentIds(@Param(value="ids") List<Long> var1);

    @Query(value="SELECT gender FROM student GROUP BY gender", nativeQuery=true)
    public List<String> groupByGender();

    @Query(value="SELECT TIMESTAMPDIFF(YEAR, date_of_birth, NOW()) AS age FROM student GROUP BY age", nativeQuery=true)
    public List<Integer> groupByAge();

    @Query(value="SELECT ethnicity FROM student GROUP BY ethnicity", nativeQuery=true)
    public List<String> groupByEthnicity();

    @Query(value="SELECT grade_id FROM student GROUP BY grade_id", nativeQuery=true)
    public List<BigInteger> groupByGradeId();

    @Query(value="SELECT standard_id FROM student GROUP BY standard_id", nativeQuery=true)
    public List<BigInteger> groupByStandardId();

    @Query(value="SELECT COUNT(*) FROM student WHERE grade_id = ?1", nativeQuery=true)
    public Long getCountByGradeId(Long var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE standard_id = ?1", nativeQuery=true)
    public Long getCountByStandardId(Long var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE standard_id IS NULL", nativeQuery=true)
    public Long getCountByStandardIdIsNull();

    @Query(value="SELECT COUNT(*) FROM student WHERE grade_id = ?1 AND gender = ?2", nativeQuery=true)
    public Long getCountByGradeIdAndGender(Long var1, String var2);

    @Query(value="SELECT COUNT(*) FROM student WHERE grade_id = ?1 AND ethnicity = ?2", nativeQuery=true)
    public Long getCountByGradeIdAndEthnicity(Long var1, String var2);

    @Query(value="SELECT COUNT(*) FROM student WHERE grade_id = ?1 AND class_id = ?2", nativeQuery=true)
    public Long getCountByGradeIdAndClassId(Long var1, Long var2);

    @Query(value="SELECT COUNT(*) FROM student WHERE gender = ?1", nativeQuery=true)
    public Long getCountByGender(String var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE ethnicity = ?1", nativeQuery=true)
    public Long getCountByEthnicity(String var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE TIMESTAMPDIFF(YEAR, date_of_birth, NOW()) = ?1", nativeQuery=true)
    public Long getCountByAge(Integer var1);

    @Query(value="SELECT class_id FROM student GROUP BY class_id", nativeQuery=true)
    public List<BigInteger> groupByClassId();

    @Query(value="SELECT COUNT(*) FROM student WHERE class_id = ?1", nativeQuery=true)
    public Long getCountByClassId(Long var1);

    @Query(value="SELECT COUNT(*) FROM student WHERE standard_id = ?1 AND gender = ?2", nativeQuery=true)
    public Long getCountByStandardIdAndGender(Long var1, String var2);

    @Query(value="SELECT COUNT(*) FROM student WHERE standard_id = ?1 AND TIMESTAMPDIFF(YEAR, date_of_birth, NOW()) = ?2", nativeQuery=true)
    public Long getCountByStandardIdAndAge(Long var1, Integer var2);

    @Query(value="SELECT COUNT(*) FROM student WHERE standard_id = ?1 AND ethnicity = ?2", nativeQuery=true)
    public Long getCountByStandardIdAndEthnicity(Long var1, String var2);

    @Query(value="SELECT COUNT(*) FROM student WHERE standard_id = ?1 AND class_id = ?2", nativeQuery=true)
    public Long getCountByStandardIdAndClassId(Long var1, Long var2);

    @Query(value="SELECT COALESCE(stu.operating_system, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM student)),2) as percentage FROM student stu group by stu.operating_system", nativeQuery=true)
    public List<Object[]> getStudentCountAndPercentageByUseOfOS();

    @Query(value="SELECT COALESCE(stu.browser, 'N/A'), count(*), round((count(*) * 100 / (SELECT count(*) FROM student)),2) as percentage FROM student stu group by stu.browser", nativeQuery=true)
    public List<Object[]> getStudentCountAndPercentageByUseOfBrowser();

    @Transactional
    @Modifying
    @Query(value="insert into student (account_id, avatar_id, class_id, ethnicity, first_name, gender, grade_id, instructor_id, last_name, is_verified, standard_id, fcm_token, should_force_socio_emotional_assessment, operating_system, browser) values (:account_id, :avatar_id, :class_id, :ethnicity, :first_name, :gender, :grade_id, :instructor_id, :last_name, :is_verified, :standard_id, :fcm_token, :should_force_socio_emotional_assessment, :operating_system, :browser)", nativeQuery=true)
    public void insertStudent(@Param(value="account_id") long var1, @Param(value="avatar_id") long var3, @Param(value="class_id") long var5, @Param(value="ethnicity") String var7, @Param(value="first_name") String var8, @Param(value="gender") String var9, @Param(value="grade_id") long var10, @Param(value="instructor_id") long var12, @Param(value="last_name") String var14, @Param(value="is_verified") boolean var15, @Param(value="standard_id") long var16, @Param(value="fcm_token") String var18, @Param(value="should_force_socio_emotional_assessment") boolean var19, @Param(value="operating_system") String var20, @Param(value="browser") String var21);

    @Query(value="SELECT * FROM student ORDER BY student_id DESC LIMIT 1", nativeQuery=true)
    public Student getLastRegisteredStudent();

    @Query(value="SELECT * FROM student stu WHERE stu.first_name = ?1 AND stu.last_name = ?2 ORDER BY student_id ASC", nativeQuery=true)
    public List<Student> findStudentByFirstNameAndLastName(String var1, String var2);
}

