/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.auth.service;

import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Admin;
import com.infinite.focus.server.auth.AdminRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.NotFoundException;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.auth.service.AuthService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class AuthServiceImpl
implements AuthService {
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    AdminRepository adminRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    StudentRepository studentRepository;

    public boolean isAuthenticated(String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                    throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
                }
                return true;
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
    }

    public boolean isAdmin(String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Admin ad;
                Account a = this.accountRepository.findByUsername(user);
                if (a != null && (ad = this.adminRepository.findByUserName(a.getUsername())) != null) {
                    return true;
                }
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user is not admin!!!.");
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
    }

    public Instructor isInstructor(String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Instructor i;
                Account a = this.accountRepository.findByUsername(user);
                if (a != null && (i = this.instructorRepository.findByAccountId(Long.valueOf(a.getAccount_id()))) != null) {
                    return i;
                }
                throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user is not Instructor!!!.");
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "The user not found!!!.");
        }
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
    }

    public Student isStudent(String token) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account a = this.accountRepository.findByUsername(user);
            if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            Student student = this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
            if (student == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The User is not a Student!!!");
            }
            return student;
        }
        throw new NotFoundException("User not found!!!");
    }
}

