/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.categories;

import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.categories.Category;
import com.infinite.focus.server.categories.CategoryPagingAndSortingRepository;
import com.infinite.focus.server.categories.CategoryRepository;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/category"})
public class CategoryController {
    @Autowired
    CategoryPagingAndSortingRepository categoryPagingAndSortingRepository;
    @Autowired
    CategoryRepository categoryRepository;

    @GetMapping(value={"/get/categories"})
    public ResponseEntity<Page<Category>> getCategories(@RequestHeader(value="Authorization") String token, @RequestParam(value="category_name", defaultValue="") String categoryName, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="category_id") String sortBy, @RequestParam(value="orderBy", defaultValue="asc") String orderBy) {
        AuthenticationController.isAuthenticated((String)token);
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = categoryName == null || categoryName.isEmpty() ? this.categoryPagingAndSortingRepository.findAllCategories((Pageable)paging) : this.categoryPagingAndSortingRepository.findByCategoryName(categoryName, (Pageable)paging);
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/category/{category_id}"})
    public ResponseEntity<Category> getCategoryById(@PathVariable(value="category_id") Long category_id) {
        Category category = this.categoryRepository.findByCategoryId(category_id);
        if (category == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The category not found.");
        }
        return new ResponseEntity((Object)category, HttpStatus.OK);
    }

    @PostMapping(value={"/create/category"})
    @ResponseBody
    public ResponseEntity<Category> createCategory(@RequestHeader(value="Authorization") String token, @RequestBody Category request) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)((Category)this.categoryRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/category"})
    @ResponseBody
    public ResponseEntity<Category> updateCategory(@RequestHeader(value="Authorization") String token, @RequestBody Category request) {
        AuthenticationController.isAuthenticated((String)token);
        Category category = (Category)this.categoryRepository.getOne((Object)request.getCategory_id());
        category.setCategory_name(request.getCategory_name());
        category.setStatus(request.getStatus());
        category.setCreatedAt(category.getCreatedAt());
        category.setUpdateAt(new Date());
        return new ResponseEntity((Object)((Category)this.categoryRepository.save((Object)category)), HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/category/{category_id}"})
    public ResponseEntity<Message> deleteCategory(@RequestHeader(value="Authorization") String token, @PathVariable(value="category_id") Long category_id) {
        AuthenticationController.isAuthenticated((String)token);
        Category category = (Category)this.categoryRepository.getOne((Object)category_id);
        if (category == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The category not found!");
        }
        this.categoryRepository.deleteById((Object)category_id);
        Message message = new Message();
        message.setMessage("The Category is deleted successfully.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

