/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.categories;

import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.categories.Category;
import com.infinite.focus.server.categories.CategoryPagingAndSortingRepository;
import com.infinite.focus.server.categories.CategoryRepository;
import com.infinite.focus.server.encryptdecrypthelper.EncryptDecryptHelper;
import com.infinite.focus.server.encryptdecrypthelper.EncryptRequest;
import java.util.Date;
import org.cloudinary.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/category/encrypt"})
public class CategoryEncryptController {
    @Autowired
    CategoryPagingAndSortingRepository categoryPagingAndSortingRepository;
    @Autowired
    CategoryRepository categoryRepository;

    @PostMapping(value={"/get/categories"})
    @ResponseBody
    public ResponseEntity<Object> getCategories(@RequestHeader(value="Authorization") String token, @RequestBody EncryptRequest request) throws Exception {
        AuthenticationController.isAuthenticated((String)token);
        String category_name = "";
        Integer pageNo = 0;
        Integer pageSize = 10;
        String sortBy = "category_id";
        String orderBy = "asc";
        try {
            JSONObject jsonObj = EncryptDecryptHelper.getDataFromEncryptRequest((EncryptRequest)request);
            if (jsonObj.has("category_name")) {
                category_name = jsonObj.getString("category_name");
            }
            if (jsonObj.has("pageNo")) {
                pageNo = jsonObj.getInt("pageNo");
            }
            if (jsonObj.has("pageSize")) {
                pageSize = jsonObj.getInt("pageSize");
            }
            if (jsonObj.has("sortBy")) {
                sortBy = jsonObj.getString("sortBy");
            }
            if (jsonObj.has("orderBy")) {
                orderBy = jsonObj.getString("orderBy");
            }
        }
        catch (Exception e) {
            throw new Exception(e.getLocalizedMessage());
        }
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = category_name == null || category_name.isEmpty() ? this.categoryPagingAndSortingRepository.findAllCategories((Pageable)paging) : this.categoryPagingAndSortingRepository.findByCategoryName(category_name, (Pageable)paging);
        return new ResponseEntity(EncryptDecryptHelper.getEncryptResponse((EncryptRequest)request, (Object)pagedResult), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @PostMapping(value={"/get/category"})
    @ResponseBody
    public ResponseEntity<Object> getCategoryById(@RequestHeader(value="Authorization") String token, @RequestBody EncryptRequest request) throws Exception {
        Long category_id = EncryptDecryptHelper.getIdFromEncryptRequestByKey((EncryptRequest)request, (String)"category_id");
        Category category = this.categoryRepository.findByCategoryId(category_id);
        if (category == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The category not found.");
        }
        return new ResponseEntity(EncryptDecryptHelper.getEncryptResponse((EncryptRequest)request, (Object)category), HttpStatus.OK);
    }

    @PostMapping(value={"/create/category"})
    @ResponseBody
    public ResponseEntity<Object> createCategory(@RequestHeader(value="Authorization") String token, @RequestBody EncryptRequest request) throws Exception {
        AuthenticationController.isAuthenticated((String)token);
        Category category = (Category)EncryptDecryptHelper.getDataClassFromEncryptRequest((EncryptRequest)request, Category.class);
        return new ResponseEntity(EncryptDecryptHelper.getEncryptResponse((EncryptRequest)request, (Object)this.categoryRepository.save((Object)category)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/category"})
    @ResponseBody
    public ResponseEntity<Object> updateCategory(@RequestHeader(value="Authorization") String token, @RequestBody EncryptRequest request) throws Exception {
        AuthenticationController.isAuthenticated((String)token);
        Category categoryRequest = (Category)EncryptDecryptHelper.getDataClassFromEncryptRequest((EncryptRequest)request, Category.class);
        Category category = (Category)this.categoryRepository.getOne((Object)categoryRequest.getCategory_id());
        category.setCategory_name(categoryRequest.getCategory_name());
        category.setStatus(categoryRequest.getStatus());
        category.setCreatedAt(category.getCreatedAt());
        category.setUpdateAt(new Date());
        return new ResponseEntity(EncryptDecryptHelper.getEncryptResponse((EncryptRequest)request, (Object)this.categoryRepository.save((Object)category)), HttpStatus.OK);
    }

    @PostMapping(value={"/delete/category"})
    public ResponseEntity<Object> deleteCategory(@RequestHeader(value="Authorization") String token, @RequestBody EncryptRequest request) throws Exception {
        AuthenticationController.isAuthenticated((String)token);
        Long category_id = EncryptDecryptHelper.getIdFromEncryptRequestByKey((EncryptRequest)request, (String)"category_id");
        Category category = (Category)this.categoryRepository.getOne((Object)category_id);
        if (category == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The category not found!");
        }
        this.categoryRepository.deleteById((Object)category_id);
        Message message = new Message();
        message.setMessage("The Category is deleted successfully.");
        return new ResponseEntity(EncryptDecryptHelper.getEncryptResponse((EncryptRequest)request, (Object)message), HttpStatus.OK);
    }
}

