/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.contents;

import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.contents.Content;
import com.infinite.focus.server.contents.ContentPagingAndSortingRepository;
import com.infinite.focus.server.contents.ContentRepository;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/content"})
public class ContentController {
    @Autowired
    ContentPagingAndSortingRepository contentPagingAndSortingRepository;
    @Autowired
    ContentRepository contentRepository;

    @GetMapping(value={"/get/contents"})
    public ResponseEntity<Page<Content>> getContents(@RequestHeader(value="Authorization") String token, @RequestParam(value="content_name", defaultValue="") String contentName, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="content_id") String sortBy, @RequestParam(value="orderBy", defaultValue="asc") String orderBy) {
        AuthenticationController.isAuthenticated((String)token);
        PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        Page pagedResult = null;
        pagedResult = contentName == null || contentName.isEmpty() ? this.contentPagingAndSortingRepository.findAllContents((Pageable)paging) : this.contentPagingAndSortingRepository.findByContentName(contentName, (Pageable)paging);
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/content/{content_id}"})
    public ResponseEntity<Content> getContentById(@PathVariable(value="content_id") Long content_id) {
        Content content = this.contentRepository.findByContentId(content_id);
        if (content == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The content not found.");
        }
        return new ResponseEntity((Object)content, HttpStatus.OK);
    }

    @PostMapping(value={"/create/content"})
    @ResponseBody
    public ResponseEntity<Content> createContent(@RequestHeader(value="Authorization") String token, @RequestBody Content request) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)((Content)this.contentRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/content"})
    @ResponseBody
    public ResponseEntity<Content> updateContent(@RequestHeader(value="Authorization") String token, @RequestBody Content request) {
        AuthenticationController.isAuthenticated((String)token);
        Content content = (Content)this.contentRepository.getOne((Object)request.getContent_id());
        content.setContent_name(request.getContent_name());
        content.setStatus(request.getStatus());
        content.setCreatedAt(content.getCreatedAt());
        content.setUpdateAt(new Date());
        return new ResponseEntity((Object)((Content)this.contentRepository.save((Object)content)), HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/content/{content_id}"})
    public ResponseEntity<Message> deleteContent(@RequestHeader(value="Authorization") String token, @PathVariable(value="content_id") Long content_id) {
        AuthenticationController.isAuthenticated((String)token);
        Content content = (Content)this.contentRepository.getOne((Object)content_id);
        if (content == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The content not found!");
        }
        this.contentRepository.deleteById((Object)content_id);
        Message message = new Message();
        message.setMessage("The Content is deleted successfully.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

