/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.stats;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.ActivityRepository;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.DashboardController;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.LabelAndValue;
import com.infinite.focus.server.dashboard.stats.StatsService;
import com.infinite.focus.server.dashboard.stats.StatsServiceImpl;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.lessons.Lesson;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatsServiceImpl
implements StatsService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    LessonRepository lessonRepository;
    @Autowired
    ActivityService activityService;
    String forwardSlash = "/";

    public Object getVideoViewList(GetDataDashBoardRequest request) {
        List results = request.getAscOrDesc().equals("DESC") ? this.activityRepository.getVideoViewListOrderByCountAndFullWatchedPercentageDesc() : this.activityRepository.getVideoViewListOrderByCountAndFullWatchedPercentageASC();
        LinkedList videoViewList = new LinkedList();
        for (Object[] result : results) {
            LinkedHashMap<String, Object> videosMap = new LinkedHashMap<String, Object>();
            Long entity_id = ((Number)result[0]).longValue();
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)entity_id);
            videosMap.put("Lesson", lesson);
            int count = ((Number)result[1]).intValue();
            if (count > 0) {
                videosMap.put("Views", count);
                String fullWatchPercentage = result[2].toString();
                videosMap.put("Full_Watch_Percentage", fullWatchPercentage);
                Long countOfWhoWatched = this.activityRepository.getCountOfStudentsWhoWatchedVideoByEnitityId(entity_id);
                videosMap.put("Unique_Users_That_Watched_Video", countOfWhoWatched);
                List repeateStudents = this.activityRepository.getRepeteVideoWatchStudentIdListByEntityId(entity_id);
                videosMap.put("Unique_Users_That_Watched_Video_Again", repeateStudents.size());
                long totalTime = ((Number)result[3]).longValue();
                videosMap.put("Time", this.getTimeInString(totalTime));
                long avgTime = ((Number)result[4]).longValue();
                videosMap.put("Avg_Time", this.getTimeInString(avgTime));
            } else {
                videosMap.put("Views", "-");
                videosMap.put("Full_Watch_Percentage", "-");
                videosMap.put("Unique_Users_That_Watched_Video", "-");
                videosMap.put("Unique_Users_That_Watched_Video_Again", "-");
                videosMap.put("Time", "-");
                videosMap.put("Avg_Time", "-");
            }
            videoViewList.add(videosMap);
        }
        return videoViewList;
    }

    public List<LabelAndValue> getVideosDemographicData(GetDataDashBoardRequest request) {
        ArrayList<LabelAndValue> graphData;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            graphData = new ArrayList<LabelAndValue>();
                            if (!AppUtils.isNotNullOrEmpty((List)request.getGenders())) break block5;
                            for (String gender : request.getGenders()) {
                                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                                getDataDashBoardRequest.getGenders().add(gender);
                                graphData.add(new LabelAndValue(gender, (double)this.getVideosDemographic(getDataDashBoardRequest)));
                            }
                            break block6;
                        }
                        if (!AppUtils.isNotNullOrEmpty((List)request.getAges())) break block7;
                        for (Integer age : request.getAges()) {
                            GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                            getDataDashBoardRequest.getAges().add(age);
                            graphData.add(new LabelAndValue(String.valueOf(age), (double)this.getVideosDemographic(getDataDashBoardRequest)));
                        }
                        break block6;
                    }
                    if (!AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) break block8;
                    for (String ethnicity : request.getEthnicity()) {
                        GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                        getDataDashBoardRequest.getEthnicity().add(ethnicity);
                        graphData.add(new LabelAndValue(ethnicity, (double)this.getVideosDemographic(getDataDashBoardRequest)));
                    }
                    break block6;
                }
                if (!AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) break block9;
                for (Long grade_id : request.getGradeIds()) {
                    GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                    getDataDashBoardRequest.getGradeIds().add(grade_id);
                    graphData.add(new LabelAndValue(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), (double)this.getVideosDemographic(getDataDashBoardRequest)));
                }
                break block6;
            }
            if (!AppUtils.isNotNullOrEmpty((List)request.getClassIds())) break block6;
            for (Long class_id : request.getClassIds()) {
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                graphData.add(new LabelAndValue(DashboardController.getClassNameWithInstructorFullName((Long)class_id, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), (double)this.getVideosDemographic(getDataDashBoardRequest)));
            }
        }
        return graphData;
    }

    public long getVideosDemographic(GetDataDashBoardRequest request) {
        List activities = this.activityService.getAllStudentActivitiesByActivityTypeIdAndEnitityId(request, Long.valueOf(2L), request.getEntity_id());
        return activities.size();
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> getTimeSpentByStudents(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        List students = this.studentRepository.findAllOrderById();
        System.out.println("Students - " + students.size());
        Date fromDate = AppUtils.isNullOrEmpty((List)students) ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)((Student)students.get(0)).getAccount().getCreatedAt());
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>>();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                System.out.println("----------------------------- " + gender + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGenders().add(gender);
                genders.put(gender, this.getTimeSpent(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate));
            }
            graphData.put("Gender", genders);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages = new LinkedHashMap<String, LinkedList>();
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getAges().add(age);
                ages.put(String.valueOf(age), this.getTimeSpent(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate));
            }
            graphData.put("Age", ages);
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap = new LinkedHashMap<String, LinkedList>();
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getEthnicity().add(ethnicity);
                ethnicityMap.put(ethnicity, this.getTimeSpent(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate));
            }
            graphData.put("Ethnicity", ethnicityMap);
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getTimeSpent(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate));
            }
            graphData.put("Grade", grades);
        }
        System.out.println("----------------------------- Class ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, LinkedList> classes = new LinkedHashMap<String, LinkedList>();
            for (Long class_id : request.getClassIds()) {
                System.out.println("-----------------------------" + class_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                classes.put(DashboardController.getClassNameWithInstructorFullName((Long)class_id, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), this.getTimeSpent(this.activityService.getAllStudentActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate));
            }
            graphData.put("Classroom", classes);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> getTimeSpentByTeachers(GetDataDashBoardRequest request) {
        System.out.println("----------------------------- TIME_SPENT_BY_TEACHERS------------------------------");
        List instructors = this.instructorRepository.findAllOrderById();
        System.out.println("Instructors - " + instructors.size());
        Date fromDate = AppUtils.isNullOrEmpty((List)instructors) ? DateUtils.setTimeToFromDate((Date)new Date()) : this.accountRepository.findByAccountId(((Instructor)instructors.get(0)).getAccount_id()).getCreatedAt();
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<String>>>();
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getTimeSpent(this.activityService.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)), fromDate, toDate));
            }
            graphData.put("Grade", grades);
        }
        return graphData;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setEntity_id(request.getEntity_id());
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }

    public LinkedList<String> getTimeSpent(List<Activity> activities, Date fromDate, Date toDate) {
        LinkedList<String> reportings = new LinkedList<String>();
        if (AppUtils.isNotNullOrEmpty(activities)) {
            long timeSpent = this.getTotalTimeSpent(activities);
            System.out.println("Time Spent Diff - " + timeSpent + " FromDate - " + DateUtils.dailyDateFormat.format(fromDate) + " ToDate - " + DateUtils.dailyDateFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Long dailyTimeSpent = Math.round((double)timeSpent / days);
            System.out.println("dailyTimeSpent - " + dailyTimeSpent + " = timeSpent: " + timeSpent + " / Days: " + days);
            reportings.add(this.getTimeInString(dailyTimeSpent.longValue()));
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Long weeklyTimeSpent = Math.round((double)timeSpent / weeks);
            System.out.println("weeklyTimeSpent - " + weeklyTimeSpent + " = timeSpent: " + timeSpent + " / Weeks: " + weeks);
            reportings.add(this.getTimeInString(weeklyTimeSpent.longValue()));
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Long monthlyTimeSpent = Math.round((double)timeSpent / months);
            System.out.println("monthlyReporting - " + monthlyTimeSpent + " = timeSpent: " + timeSpent + " / Months: " + months);
            reportings.add(this.getTimeInString(monthlyTimeSpent.longValue()));
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            Long yearlyTimeSpent = Math.round((double)timeSpent / years);
            System.out.println("yearlyTimeSpent - " + yearlyTimeSpent + " = timeSpent: " + timeSpent + " / Years: " + years);
            reportings.add(this.getTimeInString(yearlyTimeSpent.longValue()));
        } else {
            reportings.add("00:00:00");
            reportings.add("00:00:00");
            reportings.add("00:00:00");
            reportings.add("00:00:00");
        }
        return reportings;
    }

    private String getTimeInString(long time) {
        String timeString = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(time), TimeUnit.MILLISECONDS.toMinutes(time) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(time) % TimeUnit.MINUTES.toSeconds(1L));
        return timeString;
    }

    private Long getTotalTimeSpent(List<Activity> activities) {
        Long totalTimeSpent = 0L;
        for (int i = 0; i < activities.size(); ++i) {
            Activity activity = activities.get(i);
            long appUsedTime = activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime();
            totalTimeSpent = totalTimeSpent + appUsedTime;
        }
        return totalTimeSpent;
    }

    public LinkedHashMap<String, List<LabelAndValue>> getTimeSpentByDemographicsData(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        LinkedHashMap<String, List<LabelAndValue>> graphData = new LinkedHashMap<String, List<LabelAndValue>>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGenders().addAll(request.getGenders());
            graphData.put("Gender", this.getTimeSpentByDemographics(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getAges().addAll(request.getAges());
            graphData.put("Age", this.getTimeSpentByDemographics(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getEthnicity().addAll(request.getEthnicity());
            graphData.put("Ethnicity", this.getTimeSpentByDemographics(getDataDashBoardRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().addAll(request.getGradeIds());
            graphData.put("Grade", this.getTimeSpentByDemographics(getSocioEmotionalDataAnalyticsRequest));
        }
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getClassIds().addAll(request.getClassIds());
            graphData.put("Classroom", this.getTimeSpentByDemographics(getDataDashBoardRequest));
        }
        return graphData;
    }

    public List<LabelAndValue> getTimeSpentByDemographics(GetDataDashBoardRequest request) {
        List activities = this.activityService.getAllStudentActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activityMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities);
        ArrayList<LabelAndValue> labelAndValues = new ArrayList<LabelAndValue>();
        for (String key : activityMap.keySet()) {
            List values = (List)activityMap.get(key);
            if (!values.isEmpty()) {
                long timeSpent = this.getTotalTimeSpent(values);
                double avgTime = DigitUtils.getAverage((Double)Double.valueOf(timeSpent / 1000L), (Double)60.0);
                System.out.println("getTimeSpentByDemographics " + key + "Time in double - " + timeSpent + " - Time in string " + this.getTimeInString(timeSpent));
                labelAndValues.add(new LabelAndValue(key, avgTime));
                continue;
            }
            labelAndValues.add(new LabelAndValue(key, 0.0));
        }
        return labelAndValues;
    }

    public LinkedHashMap<String, LinkedList<Object>> getTimeSpentByDemographicData(GetDataDashBoardRequest request) {
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$DemographicType[request.getDemographicType().ordinal()]) {
            case 1: {
                return this.getStudentsTimeSpentByGender(request);
            }
            case 2: {
                return this.getStudentsTimeSpentByAge(request);
            }
            case 3: {
                return this.getStudentsTimeSpentByEthnicity(request);
            }
            case 4: {
                return this.getStudentsTimeSpentByGrade(request);
            }
            case 5: {
                return this.getStudentsTimeSpentByClassroom(request);
            }
        }
        return new LinkedHashMap<String, LinkedList<Object>>();
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsTimeSpentByGender(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> gendersAndAverageAndTime = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        for (int i = 0; i < request.getGenders().size(); ++i) {
            String key = (String)request.getGenders().get(i);
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGenders().clear();
            getSocioEmotionalDataAnalyticsRequest.getGenders().add(key);
            List activities = this.activityService.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            long timeSpent = this.getTotalTimeSpent(activities);
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            System.out.println("Gender " + key + " Time Spent " + this.getTimeInString(timeSpent) + " Total Time Spent" + (totalTimeSpent += timeSpent));
            gendersAndTime.put(key, list);
        }
        for (String key : gendersAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(this.getTimeInString(timeSpent));
            gendersAndAverageAndTime.put(key, list);
        }
        return gendersAndAverageAndTime;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsTimeSpentByAge(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> gendersAndAverageAndTime = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        for (int i = 0; i < request.getAges().size(); ++i) {
            Object key = (Integer)request.getAges().get(i);
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getAges().clear();
            getSocioEmotionalDataAnalyticsRequest.getAges().add(key);
            List activities = this.activityService.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            long timeSpent = this.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            gendersAndTime.put(String.valueOf(key), list);
        }
        for (Object key : gendersAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(this.getTimeInString(timeSpent));
            gendersAndAverageAndTime.put((String)key, list);
        }
        return gendersAndAverageAndTime;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsTimeSpentByEthnicity(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> gendersAndAverageAndTime = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        for (int i = 0; i < request.getEthnicity().size(); ++i) {
            String key = (String)request.getEthnicity().get(i);
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getEthnicity().clear();
            getSocioEmotionalDataAnalyticsRequest.getEthnicity().add(key);
            List activities = this.activityService.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            long timeSpent = this.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            gendersAndTime.put(key, list);
        }
        for (String key : gendersAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(this.getTimeInString(timeSpent));
            gendersAndAverageAndTime.put(key, list);
        }
        return gendersAndAverageAndTime;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsTimeSpentByGrade(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> gendersAndAverageAndTime = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        for (int i = 0; i < request.getGradeIds().size(); ++i) {
            Object key = (Long)request.getGradeIds().get(i);
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().clear();
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().add(key);
            List activities = this.activityService.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            long timeSpent = this.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            gendersAndTime.put(((Grade)this.gradeRepository.getOne(key)).getGrade_name(), list);
        }
        for (Object key : gendersAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(this.getTimeInString(timeSpent));
            gendersAndAverageAndTime.put((String)key, list);
        }
        return gendersAndAverageAndTime;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsTimeSpentByClassroom(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> gendersAndAverageAndTime = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedHashMap gendersAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        for (int i = 0; i < request.getClassIds().size(); ++i) {
            Object key = (Long)request.getClassIds().get(i);
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getClassIds().clear();
            getSocioEmotionalDataAnalyticsRequest.getClassIds().add(key);
            List activities = this.activityService.getAllStudentActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            long timeSpent = this.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            gendersAndTime.put(DashboardController.getClassNameWithInstructorFullName((Long)key, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), list);
        }
        for (Object key : gendersAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gendersAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(this.getTimeInString(timeSpent));
            gendersAndAverageAndTime.put((String)key, list);
        }
        return gendersAndAverageAndTime;
    }

    public LinkedHashMap<String, List<LabelAndValue>> getTimeSpentByGradesData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, List<LabelAndValue>> graphData = new LinkedHashMap<String, List<LabelAndValue>>();
        for (Long grade_id : request.getGradeIds()) {
            GetDataDashBoardRequest getSocioEmotionalDataAnalyticsRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getSocioEmotionalDataAnalyticsRequest.getGradeIds().add(grade_id);
            List activities = this.activityService.getAllInstructorActivitiesByActivityType(getSocioEmotionalDataAnalyticsRequest, Long.valueOf(1L));
            LinkedHashMap activityMap = this.activityService.getActivityMapByTimeLine(getSocioEmotionalDataAnalyticsRequest.getTimeLine(), activities);
            ArrayList<LabelAndValue> labelAndValues = new ArrayList<LabelAndValue>();
            for (String key : activityMap.keySet()) {
                List values = (List)activityMap.get(key);
                if (!values.isEmpty()) {
                    double appUsedTime = 0.0;
                    for (Activity activity : values) {
                        double differnce = (activity.getEnd_date_time().getTime() - activity.getStart_date_time().getTime()) / 1000L;
                        if (!(differnce >= 1.0)) continue;
                        appUsedTime += differnce;
                    }
                    labelAndValues.add(new LabelAndValue(key, DigitUtils.getAverage((Double)appUsedTime, (Double)60.0).doubleValue()));
                    continue;
                }
                labelAndValues.add(new LabelAndValue(key, 0.0));
            }
            graphData.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), labelAndValues);
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<Object>> getTimeSpentByGradeData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> gradesAndAverageAndTime = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedHashMap gradesAndTime = new LinkedHashMap();
        long totalTimeSpent = 0L;
        ArrayList grade_ids = new ArrayList();
        grade_ids.addAll(request.getGradeIds());
        for (int i = 0; i < grade_ids.size(); ++i) {
            Object key = (Long)grade_ids.get(i);
            request.getGradeIds().clear();
            request.getGradeIds().add(key);
            List activities = this.activityService.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
            long timeSpent = this.getTotalTimeSpent(activities);
            totalTimeSpent += timeSpent;
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(timeSpent);
            gradesAndTime.put(((Grade)this.gradeRepository.getOne(key)).getGrade_name(), list);
        }
        for (Object key : gradesAndTime.keySet()) {
            long timeSpent = (Long)((LinkedList)gradesAndTime.get(key)).get(0);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(DigitUtils.formatDoubleInTwoDigit((Double)DigitUtils.getPercentage((Long)timeSpent, (Long)totalTimeSpent)));
            list.add(this.getTimeInString(timeSpent));
            gradesAndAverageAndTime.put((String)key, list);
        }
        return gradesAndAverageAndTime;
    }
}

