/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.dashboard.userstats;

import com.infinite.focus.server.activity.Activity;
import com.infinite.focus.server.activity.service.ActivityService;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.dashboard.DashboardController;
import com.infinite.focus.server.dashboard.GetDataDashBoardRequest;
import com.infinite.focus.server.dashboard.LabelAndValue;
import com.infinite.focus.server.dashboard.userstats.UserStatsService;
import com.infinite.focus.server.dashboard.userstats.UserStatsServiceImpl;
import com.infinite.focus.server.grade.Grade;
import com.infinite.focus.server.grade.GradeRepository;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.students.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.utils.DigitUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserStatsServiceImpl
implements UserStatsService {
    @Autowired
    EntityManager entityManager;
    @Autowired
    AccountRepository accountRepository;
    @Autowired
    GradeRepository gradeRepository;
    @Autowired
    StandardRepository standardRepository;
    @Autowired
    StudentRepository studentRepository;
    @Autowired
    InstructorRepository instructorRepository;
    @Autowired
    ClassRepository classRepository;
    @Autowired
    ActivityService activityService;
    @Autowired
    StudentService studentService;
    String forwardSlash = "/";

    public LinkedHashMap<String, LinkedList<Object>> getOverall(GetDataDashBoardRequest request) {
        System.out.println("-----------------------OVERALL-----------------------------");
        long studentCount = this.studentRepository.count();
        long instructorCount = this.instructorRepository.count();
        long totalCount = studentCount + instructorCount;
        System.out.println("Stduent's count\t\t\t\t\t" + studentCount);
        System.out.println("Instructor's count\t\t\t\t" + instructorCount);
        System.out.println("------------------------------------------------------------");
        System.out.println("Total count\t\t\t\t\t" + totalCount);
        BigDecimal avgStudents = DigitUtils.getPercentageBigDecimal((Long)studentCount, (Long)totalCount);
        BigDecimal avgInstructors = DigitUtils.getPercentageBigDecimal((Long)instructorCount, (Long)totalCount);
        System.out.println("------------------------------------------------------------");
        System.out.println("---------Percentage = (Value " + this.forwardSlash + " Total Value) \ufffd 100-----------");
        System.out.println("Average Stduents\t\t\t\t" + avgStudents);
        System.out.println("Average Instructors\t\t\t\t" + avgInstructors);
        LinkedHashMap<String, LinkedList<Object>> graphData = new LinkedHashMap<String, LinkedList<Object>>();
        LinkedList<Number> studentsList = new LinkedList<Number>();
        studentsList.add(studentCount);
        studentsList.add(avgStudents);
        graphData.put("Students", studentsList);
        LinkedList<Number> instructorsList = new LinkedList<Number>();
        instructorsList.add(instructorCount);
        instructorsList.add(avgInstructors);
        graphData.put("Instructors", instructorsList);
        return graphData;
    }

    public LinkedHashMap<String, LinkedList<Object>> getTeachers(GetDataDashBoardRequest request) {
        System.out.println("------------------------------------ TEACHERS ---------------------------------------");
        return this.getTeachersByGrade(request);
    }

    public LinkedHashMap<String, LinkedList<Object>> getTeachersByGrade(GetDataDashBoardRequest request) {
        System.out.println("------------------------------------ TEACHERS BY GRADE ---------------------------------------");
        List grades = this.gradeRepository.findAll();
        LinkedHashMap<String, Long> gradeAndCountMap = new LinkedHashMap<String, Long>();
        Long totalCount = 0L;
        for (int i = 0; i < grades.size(); ++i) {
            String key = ((Grade)grades.get(i)).getGrade_name();
            Long count = this.instructorRepository.getCountByGradeId(Long.valueOf(((Grade)grades.get(i)).getGrade_id()));
            totalCount = totalCount + count;
            gradeAndCountMap.put(key, count);
            System.out.println(key + " \t\t\t\t" + count);
        }
        System.out.println("-----------------------------------------------------------------------------");
        System.out.println("Total \t\t\t\t" + totalCount);
        System.out.println("----------------Percentage = (Value " + this.forwardSlash + " Total Value) \ufffd 100---------------------");
        LinkedHashMap<String, LinkedList<Object>> graphData = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalPercentage = 0.0;
        for (String key : gradeAndCountMap.keySet()) {
            LinkedList<Number> list = new LinkedList<Number>();
            Long count = (Long)gradeAndCountMap.get(key);
            list.add(count);
            BigDecimal percentag = DigitUtils.getPercentageBigDecimal((Long)count, (Long)totalCount);
            list.add(percentag);
            totalPercentage = totalPercentage + percentag.doubleValue();
            System.out.println(key + " \t\t\t\t" + count + "\t\t" + totalCount + "\t\t" + percentag);
            graphData.put(key, list);
        }
        totalPercentage = DigitUtils.formatDouble((Double)totalPercentage);
        LinkedList<Number> list = new LinkedList<Number>();
        list.add(totalCount);
        list.add(DigitUtils.formatBigDecimal((BigDecimal)new BigDecimal(totalPercentage)));
        graphData.put("Total", list);
        System.out.println("-----------------------------------------------------------------------------");
        System.out.println("Total \t\t\t\t" + totalCount + "\t\t" + totalCount + "\t\t" + totalPercentage);
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> getStudents(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest;
        System.out.println("------------------------------User Stats's Student --------------------------------");
        List students = this.studentRepository.findAllOrderById();
        System.out.println("Students - " + students.size());
        Date fromDate = AppUtils.isNullOrEmpty((List)students) ? DateUtils.setTimeToFromDate((Date)new Date()) : DateUtils.setTimeToFromDate((Date)((Student)students.get(0)).getAccount().getCreatedAt());
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        System.out.println("----------------------------- Gender------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGenders())) {
            LinkedHashMap<String, LinkedList> genders = new LinkedHashMap<String, LinkedList>();
            for (String gender : request.getGenders()) {
                System.out.println("----------------------------- " + gender + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGenders().add(gender);
                genders.put(gender, this.getStudent(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Gender", genders);
        }
        System.out.println("----------------------------- Age ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getAges())) {
            LinkedHashMap<String, LinkedList> ages = new LinkedHashMap<String, LinkedList>();
            for (Integer age : request.getAges()) {
                System.out.println("----------------------------- " + age + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getAges().add(age);
                ages.put(String.valueOf(age), this.getStudent(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Age", ages);
        }
        System.out.println("----------------------------- Ethnicity------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getEthnicity())) {
            LinkedHashMap<String, LinkedList> ethnicityMap = new LinkedHashMap<String, LinkedList>();
            for (String ethnicity : request.getEthnicity()) {
                System.out.println("----------------------------- " + ethnicity + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getEthnicity().add(ethnicity);
                ethnicityMap.put(ethnicity, this.getStudent(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Ethnicity", ethnicityMap);
        }
        System.out.println("----------------------------- Grade------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getStudent(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Grade", grades);
        }
        System.out.println("----------------------------- Classroom ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getClassIds())) {
            LinkedHashMap<String, LinkedList> classrooms = new LinkedHashMap<String, LinkedList>();
            for (Long class_id : request.getClassIds()) {
                System.out.println("-----------------------------" + class_id + "------------------------------");
                getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getClassIds().add(class_id);
                classrooms.put(DashboardController.getClassNameWithInstructorFullName((Long)class_id, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), this.getStudent(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Classroom", classrooms);
        }
        return graphData;
    }

    public LinkedList<Object> getStudent(GetDataDashBoardRequest request, Date fromDate, Date toDate) {
        List student_ids = this.studentService.getStudentByDemographics(request);
        LinkedList<Object> reportings = new LinkedList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)student_ids)) {
            Double size = student_ids.size();
            System.out.println("Student List Size - " + size + " FromDate - " + DateUtils.dailyDateFormat.format(fromDate) + " ToDate - " + DateUtils.dailyDateFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsAndDemographicStrands(GetDataDashBoardRequest request) {
        switch (1.$SwitchMap$com$infinite$focus$server$dashboard$DemographicType[request.getDemographicType().ordinal()]) {
            case 1: {
                return this.getStudentsCountByGenders(request);
            }
            case 2: {
                return this.getStudentsCountByAges(request);
            }
            case 3: {
                return this.getStudentsCountByEthnicity(request);
            }
            case 4: {
                return this.getStudentsCountByGrades(request);
            }
            case 5: {
                return this.getStudentsCountByClassrooms(request);
            }
        }
        return new LinkedHashMap<String, LinkedList<Object>>();
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsCountByGenders(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalCount = 0.0;
        List genders = request.getGenders();
        for (int i = 0; i < genders.size(); ++i) {
            String key = (String)genders.get(i);
            Long count = this.studentRepository.getCountByGender(key);
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap.put(key, list);
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap, (Double)totalCount);
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsCountByEthnicity(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalCount = 0.0;
        List ethnicity = request.getEthnicity();
        for (int i = 0; i < ethnicity.size(); ++i) {
            String key = (String)ethnicity.get(i);
            Long count = this.studentRepository.getCountByEthnicity(key);
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap.put(key, list);
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap, (Double)totalCount);
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsCountByAges(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalCount = 0.0;
        List age = request.getAges();
        for (int i = 0; i < age.size(); ++i) {
            Integer key = (Integer)age.get(i);
            Long count = this.studentRepository.getCountByAge(key);
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap.put(String.valueOf(key), list);
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap, (Double)totalCount);
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsCountByGrades(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalCount = 0.0;
        List grade_ids = request.getGradeIds();
        for (int i = 0; i < grade_ids.size(); ++i) {
            Long key = (Long)grade_ids.get(i);
            Long count = this.studentRepository.getCountByGradeId(key);
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap.put(((Grade)this.gradeRepository.getOne((Object)key)).getGrade_name(), list);
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap, (Double)totalCount);
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getStudentsCountByClassrooms(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalCount = 0.0;
        List classrooms = request.getClassIds();
        for (int i = 0; i < classrooms.size(); ++i) {
            Long key = (long)((Long)classrooms.get(i));
            Long count = this.studentRepository.getCountByClassId(key);
            totalCount = totalCount + (double)count.longValue();
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap.put(DashboardController.getClassNameWithInstructorFullName((Long)key, (ClassRepository)this.classRepository, (InstructorRepository)this.instructorRepository), list);
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap, (Double)totalCount);
        return countAndAvgMap;
    }

    public LinkedList<LabelAndValue> getLogiAttemptsStudentsData(GetDataDashBoardRequest request) {
        return this.getLogiAttemptsStudents(request);
    }

    public LinkedList<LabelAndValue> getLogiAttemptsStudents(GetDataDashBoardRequest request) {
        List activities = this.activityService.getAllStudentActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activitiesMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities);
        LinkedList<LabelAndValue> graphData = new LinkedList<LabelAndValue>();
        for (String key : activitiesMap.keySet()) {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
            List values = (List)activitiesMap.get(key);
            for (int i = 0; i < values.size(); ++i) {
                ids.add(((Activity)values.get(i)).getStudent().getStudent_id());
            }
            graphData.add(new LabelAndValue(key, (double)ids.size()));
        }
        return graphData;
    }

    public LinkedHashMap<String, List<LabelAndValue>> getLogiAttemptsTeachersData(GetDataDashBoardRequest request) {
        LinkedHashMap<String, List<LabelAndValue>> graphData = new LinkedHashMap<String, List<LabelAndValue>>();
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            for (Long grade_id : request.getGradeIds()) {
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                graphData.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getLogiAttemptsTeachers(getDataDashBoardRequest));
            }
        }
        return graphData;
    }

    public LinkedList<LabelAndValue> getLogiAttemptsTeachers(GetDataDashBoardRequest request) {
        List activities = this.activityService.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedHashMap activitiesMap = this.activityService.getActivityMapByTimeLine(request.getTimeLine(), activities);
        LinkedList<LabelAndValue> graphData = new LinkedList<LabelAndValue>();
        for (String key : activitiesMap.keySet()) {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
            List values = (List)activitiesMap.get(key);
            for (int i = 0; i < values.size(); ++i) {
                ids.add(((Activity)values.get(i)).getInstructor().getInstructor_id());
            }
            graphData.add(new LabelAndValue(key, (double)ids.size()));
        }
        return graphData;
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> getAverageLoginAttemptTeachers(GetDataDashBoardRequest request) {
        System.out.println("------------------------------User Stats's Average Login Attempts - Teachers --------------------------------");
        List instructors = this.instructorRepository.findAllOrderById();
        System.out.println("Instructors - " + instructors.size());
        Date fromDate = AppUtils.isNullOrEmpty((List)instructors) ? DateUtils.setTimeToFromDate((Date)new Date()) : this.accountRepository.findByAccountId(((Instructor)instructors.get(0)).getAccount_id()).getCreatedAt();
        Date toDate = DateUtils.setTimeToToDate((Date)new Date());
        LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>> graphData = new LinkedHashMap<String, LinkedHashMap<String, LinkedList<Object>>>();
        System.out.println("----------------------------- Grade ------------------------------");
        if (AppUtils.isNotNullOrEmpty((List)request.getGradeIds())) {
            LinkedHashMap<String, LinkedList> grades = new LinkedHashMap<String, LinkedList>();
            for (Long grade_id : request.getGradeIds()) {
                System.out.println("-----------------------------" + grade_id + "------------------------------");
                GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
                getDataDashBoardRequest.getGradeIds().add(grade_id);
                grades.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), this.getAverageLoginAttemptTeachers(getDataDashBoardRequest, fromDate, toDate));
            }
            graphData.put("Grade", grades);
        }
        return graphData;
    }

    public LinkedList<Object> getAverageLoginAttemptTeachers(GetDataDashBoardRequest request, Date fromDate, Date toDate) {
        List activities = this.activityService.getAllInstructorActivitiesByActivityType(request, Long.valueOf(1L));
        LinkedList<Object> reportings = new LinkedList<Object>();
        if (AppUtils.isNotNullOrEmpty((List)activities)) {
            Double size = activities.size();
            System.out.println("Instructor List Size - " + size + " FromDate - " + DateUtils.dailyDateFormat.format(fromDate) + " ToDate - " + DateUtils.dailyDateFormat.format(toDate));
            System.out.println("----------------------------Daily---------------------------------");
            Double days = DateUtils.getDayCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal dailyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)days);
            System.out.println("dailyReporting - " + dailyReporting + " = Size: " + size + " / Days: " + days);
            reportings.add(dailyReporting);
            System.out.println("----------------------------Weekly---------------------------------");
            Double weeks = DateUtils.getWeekCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal weeklyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)weeks);
            System.out.println("weeklyReporting - " + weeklyReporting + " = Size: " + size + " / Weeks: " + weeks);
            reportings.add(weeklyReporting);
            System.out.println("----------------------------Monthly---------------------------------");
            Double months = DateUtils.getMonthCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal monthlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)months);
            System.out.println("monthlyReporting - " + monthlyReporting + " = Size: " + size + " / Months: " + months);
            reportings.add(monthlyReporting);
            System.out.println("----------------------------Yearly---------------------------------");
            Double years = DateUtils.getYearCountByFromDateAndToDate((Date)fromDate, (Date)toDate);
            BigDecimal yearlyReporting = DigitUtils.getAverageBigDecimal((Double)size, (Double)years);
            System.out.println("yearlyReporting - " + yearlyReporting + " = Size: " + size + " / Years: " + years);
            reportings.add(yearlyReporting);
        } else {
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
            reportings.add(DigitUtils.formateZeroToBigDecimal());
        }
        return reportings;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByGrades(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        Double totalCount = 0.0;
        for (int i = 0; i < request.getGradeIds().size(); ++i) {
            Long grade_id = (Long)request.getGradeIds().get(i);
            GetDataDashBoardRequest getDataDashBoardRequest = this.getGetDataDashBoardRequestWithReqeuest(request);
            getDataDashBoardRequest.getGradeIds().add(grade_id);
            long count = this.activityService.getAllInstructorActivitiesByActivityType(getDataDashBoardRequest, Long.valueOf(1L)).size();
            totalCount = totalCount + (double)count;
            LinkedList<Number> list = new LinkedList<Number>();
            list.add(count);
            list.add(0);
            countAndAvgMap.put(((Grade)this.gradeRepository.getOne((Object)grade_id)).getGrade_name(), list);
        }
        DigitUtils.addTotalInMapBigDecimal(countAndAvgMap, (Double)totalCount);
        return countAndAvgMap;
    }

    private GetDataDashBoardRequest getGetDataDashBoardRequestWithReqeuest(GetDataDashBoardRequest request) {
        GetDataDashBoardRequest getDataDashBoardRequest = new GetDataDashBoardRequest();
        getDataDashBoardRequest.setTimeLine(request.getTimeLine());
        getDataDashBoardRequest.setSocio_emotional_test_question_type_id(request.getSocio_emotional_test_question_type_id());
        getDataDashBoardRequest.setGraphType(request.getGraphType());
        getDataDashBoardRequest.setFromDate(request.getFromDate());
        getDataDashBoardRequest.setToDate(request.getToDate());
        return getDataDashBoardRequest;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByOSForStudent(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        List studentsCountAndPercentageByOS = this.studentRepository.getStudentCountAndPercentageByUseOfOS();
        for (int i = 0; i < studentsCountAndPercentageByOS.size(); ++i) {
            Object[] studentCountAndPercentageByOS = (Object[])studentsCountAndPercentageByOS.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(studentCountAndPercentageByOS[1]);
            list.add(studentCountAndPercentageByOS[2]);
            countAndAvgMap.put(studentCountAndPercentageByOS[0].toString(), list);
        }
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByBrowserForStudent(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        List studentsCountAndPercentageByBrowser = this.studentRepository.getStudentCountAndPercentageByUseOfBrowser();
        for (int i = 0; i < studentsCountAndPercentageByBrowser.size(); ++i) {
            Object[] studentCountAndPercentageByBrowser = (Object[])studentsCountAndPercentageByBrowser.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(studentCountAndPercentageByBrowser[1]);
            list.add(studentCountAndPercentageByBrowser[2]);
            countAndAvgMap.put(studentCountAndPercentageByBrowser[0].toString(), list);
        }
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByOSForInstructor(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        List instructorsCountAndPercentageByOS = this.instructorRepository.getInstructorCountAndPercentageByUseOfOS();
        for (int i = 0; i < instructorsCountAndPercentageByOS.size(); ++i) {
            Object[] instructorCountAndPercentageByOS = (Object[])instructorsCountAndPercentageByOS.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(instructorCountAndPercentageByOS[1]);
            list.add(instructorCountAndPercentageByOS[2]);
            countAndAvgMap.put(instructorCountAndPercentageByOS[0].toString(), list);
        }
        return countAndAvgMap;
    }

    public LinkedHashMap<String, LinkedList<Object>> getPercentageByBrowserForInstructor(GetDataDashBoardRequest request) {
        LinkedHashMap<String, LinkedList<Object>> countAndAvgMap = new LinkedHashMap<String, LinkedList<Object>>();
        List instructorsCountAndPercentageByBrowser = this.studentRepository.getStudentCountAndPercentageByUseOfOS();
        for (int i = 0; i < instructorsCountAndPercentageByBrowser.size(); ++i) {
            Object[] instructorCountAndPercentageByBrowser = (Object[])instructorsCountAndPercentageByBrowser.get(i);
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(instructorCountAndPercentageByBrowser[1]);
            list.add(instructorCountAndPercentageByBrowser[2]);
            countAndAvgMap.put(instructorCountAndPercentageByBrowser[0].toString(), list);
        }
        return countAndAvgMap;
    }
}

