/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.data;

import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.data.AssessmentDataWrapper;
import com.infinite.focus.server.data.AssessmentMasterDetailsWrapper;
import com.infinite.focus.server.data.MoodOccurance;
import com.infinite.focus.server.data.SocioEmotionalDataWrapper;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.MoodUpdate;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.lessons.Lesson;
import com.infinite.focus.server.lessons.LessonRecord;
import com.infinite.focus.server.lessons.LessonRecordRepository;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.moods.MoodRepository;
import com.infinite.focus.server.students.Class;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.tests.AnswerRepository;
import com.infinite.focus.server.tests.CorrectAnswerRepository;
import com.infinite.focus.server.tests.MultipleChoiceOptionRepository;
import com.infinite.focus.server.tests.QuestionRepository;
import com.infinite.focus.server.tests.SocioEmotionalTestResult;
import com.infinite.focus.server.tests.SocioEmotionalTestResultRepository;
import com.infinite.focus.server.tests.Test;
import com.infinite.focus.server.tests.TestRepository;
import com.infinite.focus.server.tests.TestResult;
import com.infinite.focus.server.tests.TestResultGrade;
import com.infinite.focus.server.tests.TestResultGradeRepository;
import com.infinite.focus.server.tests.TestResultRepository;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/data"})
public class DataController {
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private ClassRepository classRepository;
    private TestRepository testRepository;
    private QuestionRepository questionRepository;
    private CorrectAnswerRepository correctAnswerRepository;
    private MultipleChoiceOptionRepository multipleChoiceOptionRepository;
    private AnswerRepository answerRepository;
    private TestResultRepository testResultRepository;
    private TestResultGradeRepository testResultGradeRepository;
    private LessonRepository lessonRepository;
    private LessonRecordRepository lessonRecordRepository;
    private SocioEmotionalTestResultRepository socioEmotionalTestResultRepository;
    @Autowired
    private MoodRepository moodRepository;

    public DataController(SocioEmotionalTestResultRepository socioEmotionalTestResultRepository, LessonRecordRepository lessonRecordRepository, LessonRepository lessonRepository, TestResultGradeRepository testResultGradeRepository, TestResultRepository testResultRepository, AnswerRepository answerRepository, TestRepository testRepository, QuestionRepository questionRepository, CorrectAnswerRepository correctAnswerRepository, MultipleChoiceOptionRepository multipleChoiceOptionRepository, ClassRepository classRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.socioEmotionalTestResultRepository = socioEmotionalTestResultRepository;
        this.lessonRecordRepository = lessonRecordRepository;
        this.testResultRepository = testResultRepository;
        this.answerRepository = answerRepository;
        this.testRepository = testRepository;
        this.lessonRepository = lessonRepository;
        this.questionRepository = questionRepository;
        this.correctAnswerRepository = correctAnswerRepository;
        this.multipleChoiceOptionRepository = multipleChoiceOptionRepository;
        this.testResultGradeRepository = testResultGradeRepository;
        this.classRepository = classRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
    }

    @GetMapping(value={"/get/socio/emotional/data"})
    public ResponseEntity<List<SocioEmotionalTestResult>> getSocioEmotionalRecords(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List results = this.socioEmotionalTestResultRepository.findByStudentIdOrderByCreatedAtLatestToOldest(student_id);
        String date = null;
        ArrayList socioEmotionalTestResults = new ArrayList(results);
        for (SocioEmotionalTestResult t : results) {
            String createdAt = format.format(t.getCreatedAt());
            if (date == null || !date.equals(createdAt)) {
                date = createdAt;
                continue;
            }
            if (!date.equals(createdAt)) continue;
            socioEmotionalTestResults.remove(t);
        }
        return new ResponseEntity(socioEmotionalTestResults, HttpStatus.OK);
    }

    @GetMapping(value={"/get/socio/emotional/data/by/class"})
    public ResponseEntity<List<SocioEmotionalDataWrapper>> getSocioEmotionalRecordsByClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        List students = this.studentRepository.findByClassId(class_id);
        ArrayList<SocioEmotionalDataWrapper> list = new ArrayList<SocioEmotionalDataWrapper>();
        for (Student s : students) {
            for (SocioEmotionalTestResult t : this.socioEmotionalTestResultRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
                boolean found = false;
                for (SocioEmotionalDataWrapper sdw : list) {
                    if (t.getCreatedAt().getMonth() + 1 != sdw.month || t.getCreatedAt().getYear() + 1900 != sdw.year) continue;
                    sdw.score += t.score;
                    ++sdw.count;
                    found = true;
                }
                if (found) continue;
                list.add(new SocioEmotionalDataWrapper(t.score, 1, t.getCreatedAt().getMonth() + 1, t.getCreatedAt().getYear() + 1900));
            }
        }
        for (SocioEmotionalDataWrapper a : list) {
            a.score /= a.count;
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/assessment/data/by/class"})
    public ResponseEntity<List<AssessmentDataWrapper>> getAssessmentByClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        List students = this.studentRepository.findByClassId(class_id);
        ArrayList<AssessmentDataWrapper> list = new ArrayList<AssessmentDataWrapper>();
        for (Student s : students) {
            for (LessonRecord l : this.lessonRecordRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
                AssessmentDataWrapper adw = new AssessmentDataWrapper();
                Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
                if (lesson == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                adw.setLesson(lesson);
                Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
                if (test == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                adw.setTest(test);
                TestResult testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), Long.valueOf(s.getStudent_id()));
                if (testResult != null) {
                    TestResultGrade trg = this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id()));
                    if (trg != null) {
                        adw.setGrade(trg.getGrade());
                    } else {
                        adw.setGrade(0.0f);
                    }
                    adw.setTestResult(testResult);
                }
                boolean found = false;
                for (AssessmentDataWrapper a : list) {
                    if (a.getTest().getTest_id() != adw.getTest().getTest_id()) continue;
                    a.setCount(a.getCount() + 1);
                    a.setGrade(a.getGrade() + adw.getGrade());
                    found = true;
                }
                if (found) continue;
                ++adw.count;
                list.add(adw);
            }
        }
        for (AssessmentDataWrapper a : list) {
            a.grade /= (float)a.count;
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/assessment/data"})
    public ResponseEntity<List<AssessmentDataWrapper>> getRecords(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        ArrayList<AssessmentDataWrapper> list = new ArrayList<AssessmentDataWrapper>();
        for (LessonRecord l : this.lessonRecordRepository.findByStudentId(student_id)) {
            AssessmentDataWrapper adw = new AssessmentDataWrapper();
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
            if (lesson == null) {
                new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            adw.setLesson(lesson);
            Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
            if (test == null) {
                new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            adw.setTest(test);
            TestResult testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), student_id);
            if (testResult != null) {
                adw.setGrade(this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id())).getGrade());
                adw.setTestResult(testResult);
            }
            list.add(adw);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/mood/analysis"})
    public ResponseEntity<List<MoodOccurance>> getMoodAnalysis(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        ArrayList<MoodOccurance> list = new ArrayList<MoodOccurance>();
        list.add(new MoodOccurance("happy", Integer.valueOf(0)));
        list.add(new MoodOccurance("angry", Integer.valueOf(0)));
        list.add(new MoodOccurance("sad", Integer.valueOf(0)));
        list.add(new MoodOccurance("mad", Integer.valueOf(0)));
        list.add(new MoodOccurance("scared", Integer.valueOf(0)));
        list.add(new MoodOccurance("annoyed", Integer.valueOf(0)));
        list.add(new MoodOccurance("shy", Integer.valueOf(0)));
        list.add(new MoodOccurance("silly", Integer.valueOf(0)));
        list.add(new MoodOccurance("excited", Integer.valueOf(0)));
        for (MoodUpdate m : this.moodUpdateRepository.findByStudentId(student_id)) {
            if (this.containsMood("excited", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("excited")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("shy", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("shy")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("mad", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("mad")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("annoyed", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("annoyed")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("scared", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("scared")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("silly", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("silly")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("happy", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("happy")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (this.containsMood("sad", m.getText())) {
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("sad")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
            if (!this.containsMood("angry", m.getText())) continue;
            for (MoodOccurance o : list) {
                if (!o.getMood().equals("angry")) continue;
                o.setCount(Integer.valueOf(o.getCount() + 1));
            }
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/mood/analysis/by/class"})
    public ResponseEntity<List<MoodOccurance>> getMoodAnalysisByClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        ArrayList<MoodOccurance> list = new ArrayList<MoodOccurance>();
        List students = this.studentRepository.findByClassId(class_id);
        list.add(new MoodOccurance("happy", Integer.valueOf(0)));
        list.add(new MoodOccurance("angry", Integer.valueOf(0)));
        list.add(new MoodOccurance("sad", Integer.valueOf(0)));
        list.add(new MoodOccurance("mad", Integer.valueOf(0)));
        list.add(new MoodOccurance("scared", Integer.valueOf(0)));
        list.add(new MoodOccurance("annoyed", Integer.valueOf(0)));
        list.add(new MoodOccurance("shy", Integer.valueOf(0)));
        list.add(new MoodOccurance("silly", Integer.valueOf(0)));
        list.add(new MoodOccurance("excited", Integer.valueOf(0)));
        for (Student s : students) {
            for (MoodUpdate m : this.moodUpdateRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
                if (this.containsMood("excited", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("excited")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("shy", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("shy")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("mad", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("mad")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("annoyed", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("annoyed")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("scared", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("scared")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("silly", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("silly")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("happy", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("happy")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("sad", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("sad")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (!this.containsMood("angry", m.getText())) continue;
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("angry")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
        }
        for (MoodOccurance m : list) {
            m.count = m.count / students.size();
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/socio/emotional/data/by/school"})
    public ResponseEntity<List<SocioEmotionalDataWrapper>> getSocioEmotionalRecordsBySchool(@RequestParam(value="school_id", defaultValue="aEn24") Long school_id) {
        List instructors = this.instructorRepository.findBySchoolId(school_id);
        ArrayList students = new ArrayList();
        for (Instructor i : instructors) {
            List classes = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : classes) {
                students.addAll(this.studentRepository.findByClassId(Long.valueOf(c.getClass_id())));
            }
        }
        ArrayList<SocioEmotionalDataWrapper> list = new ArrayList<SocioEmotionalDataWrapper>();
        for (Student s : students) {
            for (SocioEmotionalTestResult t : this.socioEmotionalTestResultRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
                boolean found = false;
                for (SocioEmotionalDataWrapper sdw : list) {
                    if (t.getCreatedAt().getMonth() + 1 != sdw.month || t.getCreatedAt().getYear() + 1900 != sdw.year) continue;
                    sdw.score += t.score;
                    ++sdw.count;
                    found = true;
                }
                if (found) continue;
                list.add(new SocioEmotionalDataWrapper(t.score, 1, t.getCreatedAt().getMonth() + 1, t.getCreatedAt().getYear() + 1900));
            }
        }
        for (SocioEmotionalDataWrapper a : list) {
            a.score /= a.count;
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/assessment/data/by/school"})
    public ResponseEntity<List<AssessmentDataWrapper>> getAssessmentBySchool(@RequestParam(value="school_id", defaultValue="aEn24") Long school_id) {
        List instructors = this.instructorRepository.findBySchoolId(school_id);
        ArrayList students = new ArrayList();
        for (Instructor i : instructors) {
            List classes = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : classes) {
                students.addAll(this.studentRepository.findByClassId(Long.valueOf(c.getClass_id())));
            }
        }
        ArrayList<AssessmentDataWrapper> list = new ArrayList<AssessmentDataWrapper>();
        for (Student s : students) {
            for (LessonRecord l : this.lessonRecordRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
                AssessmentDataWrapper adw = new AssessmentDataWrapper();
                Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
                if (lesson == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                adw.setLesson(lesson);
                Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
                if (test == null) {
                    new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                adw.setTest(test);
                TestResult testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), Long.valueOf(s.getStudent_id()));
                if (testResult != null) {
                    TestResultGrade trg = this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id()));
                    if (trg != null) {
                        adw.setGrade(trg.getGrade());
                    } else {
                        adw.setGrade(0.0f);
                    }
                    adw.setTestResult(testResult);
                }
                boolean found = false;
                for (AssessmentDataWrapper a : list) {
                    if (a.getTest().getTest_id() != adw.getTest().getTest_id()) continue;
                    a.setCount(a.getCount() + 1);
                    a.setGrade(a.getGrade() + adw.getGrade());
                    found = true;
                }
                if (found) continue;
                ++adw.count;
                list.add(adw);
            }
        }
        for (AssessmentDataWrapper a : list) {
            a.grade /= (float)a.count;
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/mood/analysis/by/school"})
    public ResponseEntity<List<MoodOccurance>> getMoodAnalysisBySchool(@RequestParam(value="school_id", defaultValue="aEn24") Long school_id) {
        List instructors = this.instructorRepository.findBySchoolId(school_id);
        ArrayList students = new ArrayList();
        for (Instructor i : instructors) {
            List classes = this.classRepository.findByInstructorId(Long.valueOf(i.getInstructor_id()));
            for (Class c : classes) {
                students.addAll(this.studentRepository.findByClassId(Long.valueOf(c.getClass_id())));
            }
        }
        ArrayList<MoodOccurance> list = new ArrayList<MoodOccurance>();
        list.add(new MoodOccurance("happy", Integer.valueOf(0)));
        list.add(new MoodOccurance("angry", Integer.valueOf(0)));
        list.add(new MoodOccurance("sad", Integer.valueOf(0)));
        list.add(new MoodOccurance("mad", Integer.valueOf(0)));
        list.add(new MoodOccurance("scared", Integer.valueOf(0)));
        list.add(new MoodOccurance("annoyed", Integer.valueOf(0)));
        list.add(new MoodOccurance("shy", Integer.valueOf(0)));
        list.add(new MoodOccurance("silly", Integer.valueOf(0)));
        list.add(new MoodOccurance("excited", Integer.valueOf(0)));
        for (Student s : students) {
            for (MoodUpdate m : this.moodUpdateRepository.findByStudentId(Long.valueOf(s.getStudent_id()))) {
                if (this.containsMood("excited", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("excited")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("shy", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("shy")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("mad", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("mad")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("annoyed", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("annoyed")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("scared", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("scared")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("silly", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("silly")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("happy", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("happy")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (this.containsMood("sad", m.getText())) {
                    for (MoodOccurance o : list) {
                        if (!o.getMood().equals("sad")) continue;
                        o.setCount(Integer.valueOf(o.getCount() + 1));
                    }
                }
                if (!this.containsMood("angry", m.getText())) continue;
                for (MoodOccurance o : list) {
                    if (!o.getMood().equals("angry")) continue;
                    o.setCount(Integer.valueOf(o.getCount() + 1));
                }
            }
        }
        for (MoodOccurance m : list) {
            if (students.size() > 0) {
                m.count = m.count / students.size();
                continue;
            }
            m.count = m.count;
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    private boolean containsMood(String mood, String text) {
        String[] words;
        if (text.toLowerCase().trim().contains(mood.toLowerCase().trim())) {
            return true;
        }
        for (String s : words = text.split("\\s+")) {
            if (this.calculate(s.toLowerCase().trim(), mood.toLowerCase().trim()) >= 2) continue;
            return true;
        }
        return false;
    }

    public int calculate(String x, String y) {
        if (x.isEmpty()) {
            return y.length();
        }
        if (y.isEmpty()) {
            return x.length();
        }
        int substitution = this.calculate(x.substring(1), y.substring(1)) + this.costOfSubstitution(x.charAt(0), y.charAt(0));
        int insertion = this.calculate(x, y.substring(1)) + 1;
        int deletion = this.calculate(x.substring(1), y) + 1;
        return this.min(new int[]{substitution, insertion, deletion});
    }

    public int costOfSubstitution(char a, char b) {
        return a == b ? 0 : 1;
    }

    public int min(int ... numbers) {
        return Arrays.stream(numbers).min().orElse(Integer.MAX_VALUE);
    }

    @GetMapping(value={"/get/assessment-master-details"})
    public ResponseEntity<AssessmentMasterDetailsWrapper> getAssessmentMasterDetails(@RequestHeader(value="Authorization") String token) {
        AssessmentMasterDetailsWrapper assessmentMasterDetailsWrapper = new AssessmentMasterDetailsWrapper();
        List moods = this.moodRepository.getAllMoodsOrderByMoodId();
        assessmentMasterDetailsWrapper.setMoods(moods);
        return new ResponseEntity((Object)assessmentMasterDetailsWrapper, HttpStatus.OK);
    }
}

