/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.fcm;

import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.NotFoundException;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.fcm.PushNotifcationRepository;
import com.infinite.focus.server.fcm.PushNotificationController;
import com.infinite.focus.server.fcm.SendStudentNotificationRequest;
import com.infinite.focus.server.fcm.StudentPushNotification;
import com.infinite.focus.server.fcm.StudentPushNotificationRepository;
import com.infinite.focus.server.fcm.model.PushNotification;
import com.infinite.focus.server.fcm.model.PushNotificationResponse;
import com.infinite.focus.server.fcm.service.PushNotificationService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/fcm"})
public class PushNotificationController {
    private AccountRepository accountRepository;
    private PushNotificationService pushNotificationService;
    private PushNotifcationRepository pushNotifcationRepository;
    private StudentPushNotificationRepository studentPushNotificationRepository;
    private StudentRepository studentRepository;

    public PushNotificationController(AccountRepository accountRepository, PushNotificationService pushNotificationService, PushNotifcationRepository pushNotifcationRepository, StudentPushNotificationRepository studentPushNotificationRepository, StudentRepository studentRepository) {
        this.accountRepository = accountRepository;
        this.pushNotificationService = pushNotificationService;
        this.pushNotifcationRepository = pushNotifcationRepository;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.studentRepository = studentRepository;
    }

    @PostMapping(value={"/notification/topic"})
    public ResponseEntity sendNotification(@RequestBody PushNotification request) {
        this.pushNotificationService.sendPushNotificationWithoutData(request);
        return new ResponseEntity((Object)new PushNotificationResponse(HttpStatus.OK.value(), "Notification has been sent."), HttpStatus.OK);
    }

    @PostMapping(value={"/notification/token"})
    public ResponseEntity sendTokenNotification(@RequestBody PushNotification request) {
        this.pushNotificationService.sendPushNotificationToToken(request);
        return new ResponseEntity((Object)new PushNotificationResponse(HttpStatus.OK.value(), "Notification has been sent."), HttpStatus.OK);
    }

    @PostMapping(value={"/notification/data"})
    public ResponseEntity sendDataNotification(@RequestBody PushNotification request) {
        this.pushNotificationService.sendPushNotification(request);
        return new ResponseEntity((Object)new PushNotificationResponse(HttpStatus.OK.value(), "Notification has been sent."), HttpStatus.OK);
    }

    @PostMapping(value={"/student/send/notification"})
    public ResponseEntity<Message> sendDataNotification(@RequestHeader(value="Authorization") String token, @RequestBody SendStudentNotificationRequest request) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            int i;
            Account a = this.accountRepository.findByUsername(user);
            if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            List students = request.getInstructor_id() != null ? this.studentRepository.findByInstructorId(request.getInstructor_id()) : (request.getIds() == null || request.getIds().isEmpty() ? this.studentRepository.findAllOrderById() : this.studentRepository.findByStudentIds(request.getIds()));
            if (students == null || students.isEmpty()) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Students are not found!!!");
            }
            PushNotification pushNotification = request.getPush_notification();
            block5: for (i = 0; i < students.size(); ++i) {
                switch (1.$SwitchMap$com$infinite$focus$server$fcm$model$ScreenType[pushNotification.getScreen_type().ordinal()]) {
                    case 1: {
                        Student student = (Student)students.get(i);
                        student.setShould_force_socio_emotional_assessment(true);
                        this.studentRepository.save((Object)student);
                        continue block5;
                    }
                }
            }
            if (request.isSaveToDB()) {
                pushNotification = (PushNotification)this.pushNotifcationRepository.save((Object)request.getPush_notification());
                if (request.getIds() == null || request.getIds().isEmpty()) {
                    StudentPushNotification studentNotificationTemplate = new StudentPushNotification();
                    studentNotificationTemplate.setStudent_id(0L);
                    studentNotificationTemplate.setPush_notification_id(pushNotification.getPush_notification_id());
                    studentNotificationTemplate.setCreatedAt(new Date());
                    this.studentPushNotificationRepository.save((Object)studentNotificationTemplate);
                } else {
                    for (i = 0; i < students.size(); ++i) {
                        StudentPushNotification studentNotificationTemplate = new StudentPushNotification();
                        studentNotificationTemplate.setStudent_id(((Student)students.get(i)).getStudent_id());
                        studentNotificationTemplate.setPush_notification_id(pushNotification.getPush_notification_id());
                        studentNotificationTemplate.setCreatedAt(new Date());
                        this.studentPushNotificationRepository.save((Object)studentNotificationTemplate);
                    }
                }
            }
            try {
                ArrayList<PushNotification> pushNotifications = new ArrayList<PushNotification>();
                ArrayList<String> tokens = new ArrayList<String>();
                for (int i2 = 0; i2 < students.size(); ++i2) {
                    String fcmToken = ((Student)students.get(i2)).getFcm_token();
                    if (fcmToken == null || fcmToken.trim().isEmpty() || tokens.contains(fcmToken)) continue;
                    PushNotification push_notification = new PushNotification();
                    push_notification.setTitle(pushNotification.getTitle());
                    push_notification.setMessage(pushNotification.getMessage());
                    push_notification.setScreen_type(pushNotification.getScreen_type());
                    push_notification.setToken(fcmToken);
                    tokens.add(fcmToken);
                    pushNotifications.add(push_notification);
                }
                this.pushNotificationService.sendPushNotifications(pushNotifications);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Message message = new Message();
            message.setMessage("Notification has been sent.");
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        throw new NotFoundException("User not found!!!");
    }
}

