/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.lessons;

import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Admin;
import com.infinite.focus.server.auth.AdminRepository;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.googleapis.services.youtube.YouTubeDurationUtils;
import com.infinite.focus.server.googleapis.services.youtube.YouTubeService;
import com.infinite.focus.server.googleapis.services.youtube.YouTubeVideoDetails;
import com.infinite.focus.server.googleapis.services.youtube.YouTubeVideoDetailsItem;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.lessons.Lesson;
import com.infinite.focus.server.lessons.LessonRecord;
import com.infinite.focus.server.lessons.LessonRecordRepository;
import com.infinite.focus.server.lessons.LessonRecordWrapper;
import com.infinite.focus.server.lessons.LessonRepository;
import com.infinite.focus.server.lessons.LessonTestWrapper;
import com.infinite.focus.server.lessons.LessonWrapper;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.tests.AnswerRepository;
import com.infinite.focus.server.tests.CorrectAnswerRepository;
import com.infinite.focus.server.tests.MultipleChoiceOptionRepository;
import com.infinite.focus.server.tests.QuestionRepository;
import com.infinite.focus.server.tests.Test;
import com.infinite.focus.server.tests.TestRepository;
import com.infinite.focus.server.tests.TestResult;
import com.infinite.focus.server.tests.TestResultGradeRepository;
import com.infinite.focus.server.tests.TestResultRepository;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/lessons"})
public class LessonController {
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private ClassRepository classRepository;
    private TestRepository testRepository;
    private QuestionRepository questionRepository;
    private CorrectAnswerRepository correctAnswerRepository;
    private MultipleChoiceOptionRepository multipleChoiceOptionRepository;
    private AnswerRepository answerRepository;
    private TestResultRepository testResultRepository;
    private TestResultGradeRepository testResultGradeRepository;
    private LessonRepository lessonRepository;
    private LessonRecordRepository lessonRecordRepository;
    private AdminRepository adminRepository;
    @Autowired
    private YouTubeService youTubeService;

    public LessonController(AdminRepository adminRepository, LessonRecordRepository lessonRecordRepository, LessonRepository lessonRepository, TestResultGradeRepository testResultGradeRepository, TestResultRepository testResultRepository, AnswerRepository answerRepository, TestRepository testRepository, QuestionRepository questionRepository, CorrectAnswerRepository correctAnswerRepository, MultipleChoiceOptionRepository multipleChoiceOptionRepository, ClassRepository classRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder) {
        this.adminRepository = adminRepository;
        this.lessonRecordRepository = lessonRecordRepository;
        this.lessonRepository = lessonRepository;
        this.testResultRepository = testResultRepository;
        this.answerRepository = answerRepository;
        this.testRepository = testRepository;
        this.questionRepository = questionRepository;
        this.correctAnswerRepository = correctAnswerRepository;
        this.multipleChoiceOptionRepository = multipleChoiceOptionRepository;
        this.testResultGradeRepository = testResultGradeRepository;
        this.classRepository = classRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
    }

    @GetMapping(value={"/get/lessons"})
    public ResponseEntity<List<LessonTestWrapper>> getLessons(@RequestParam(value="grade_id", defaultValue="aEn24") Long grade_id) {
        ArrayList<LessonTestWrapper> lessons = new ArrayList<LessonTestWrapper>();
        for (Lesson l : this.lessonRepository.findByGradeId(grade_id)) {
            LessonTestWrapper ltw = new LessonTestWrapper();
            ltw.setLesson(l);
            ltw.setHasTest(Boolean.valueOf(false));
            if (this.testRepository.existsById((Object)l.getTest_id())) {
                ltw.setTest((Test)this.testRepository.getOne((Object)l.getTest_id()));
                ltw.setHasTest(Boolean.valueOf(true));
            }
            lessons.add(ltw);
        }
        return new ResponseEntity(lessons, HttpStatus.OK);
    }

    @PostMapping(value={"/create/lesson"})
    @ResponseBody
    public ResponseEntity<Lesson> createLesson(@RequestBody Lesson request, @RequestHeader(value="Authorization") String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                Admin ad = this.adminRepository.findByUserName(user);
                if (ad != null) {
                    Lesson highest_lesson = this.lessonRepository.findHighestLessonByGradeId(Long.valueOf(request.getGrade_id()));
                    if (highest_lesson == null) {
                        request.setLesson_index(1);
                    } else {
                        request.setLesson_index(highest_lesson.getLesson_index() + 1);
                    }
                    long duration = this.getYouTubeVideoDurationInSeconds(request.getVideo_url());
                    request.setVideo_duration(duration);
                    return new ResponseEntity((Object)((Lesson)this.lessonRepository.save((Object)request)), HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/update/lesson"})
    @ResponseBody
    public ResponseEntity<Lesson> updateLesson(@RequestBody Lesson request, @RequestHeader(value="Authorization") String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                Admin ad = this.adminRepository.findByUserName(user);
                if (ad != null) {
                    long duration = this.getYouTubeVideoDurationInSeconds(request.getVideo_url());
                    request.setVideo_duration(duration);
                    return new ResponseEntity((Object)((Lesson)this.lessonRepository.save((Object)request)), HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/delete/lesson"})
    public ResponseEntity<Lesson> deleteLesson(@RequestParam(value="lesson_id", defaultValue="aEn24") Long lesson_id, @RequestHeader(value="Authorization") String token) {
        if (token != null && !token.contains("undefined")) {
            String user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject();
            if (user != null) {
                Account a = this.accountRepository.findByUsername(user);
                if (a == null) {
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
                Admin ad = this.adminRepository.findByUserName(user);
                if (ad != null) {
                    this.lessonRepository.deleteById((Object)lesson_id);
                    return new ResponseEntity((Object)new Lesson(), HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/create/record"})
    @ResponseBody
    public ResponseEntity<LessonRecord> updateLesson(@RequestBody LessonRecord request) {
        return new ResponseEntity((Object)((LessonRecord)this.lessonRecordRepository.save((Object)request)), HttpStatus.OK);
    }

    @GetMapping(value={"/get/records"})
    public ResponseEntity<List<LessonRecordWrapper>> getRecords(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        ArrayList<LessonRecordWrapper> list = new ArrayList<LessonRecordWrapper>();
        for (LessonRecord l : this.lessonRecordRepository.findByStudentId(student_id)) {
            TestResult testResult;
            LessonRecordWrapper lrw = new LessonRecordWrapper();
            lrw.setLessonRecord(l);
            Lesson lesson = (Lesson)this.lessonRepository.getOne((Object)l.getLesson_id());
            if (lesson == null) {
                new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            lrw.setLesson(lesson);
            Test test = (Test)this.testRepository.getOne((Object)lesson.getTest_id());
            if (test == null) {
                new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            if ((testResult = this.testResultRepository.findMostRecentByStudent(Long.valueOf(test.getTest_id()), student_id)) != null) {
                lrw.setAnswers(this.answerRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id())));
                lrw.setGrade(this.testResultGradeRepository.findByTestResultId(Long.valueOf(testResult.getTest_result_id())).getGrade());
            }
            list.add(lrw);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/next/lesson"})
    public ResponseEntity<LessonWrapper> getNextLesson(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        int n;
        LessonWrapper lesson = new LessonWrapper();
        lesson.setStatus("LESSON_COMPLETE");
        Student student = (Student)this.studentRepository.getOne((Object)student_id);
        if (student == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        ArrayList<Lesson> completedLessons = new ArrayList<Lesson>();
        List allLessons = this.lessonRepository.findByGradeId(Long.valueOf(student.getGrade_id()));
        if (allLessons == null || allLessons.isEmpty()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Sorry, no lessons are available at the moment. Please check back later.");
        }
        for (LessonRecord lessonRecord : this.lessonRecordRepository.findByStudentId(student_id)) {
            Lesson _l = this.lessonRepository.findByLessonId(Long.valueOf(lessonRecord.getLesson_id()));
            if (_l == null) continue;
            completedLessons.add(_l);
        }
        if (completedLessons == null || completedLessons.isEmpty()) {
            lesson.setLesson_id(((Lesson)allLessons.get(0)).getLesson_id());
            lesson.setGrade_id(((Lesson)allLessons.get(0)).getGrade_id());
            lesson.setGuide_post_text(((Lesson)allLessons.get(0)).getGuide_post_text());
            lesson.setLesson_index(((Lesson)allLessons.get(0)).getLesson_index());
            lesson.setTest_id(((Lesson)allLessons.get(0)).getTest_id());
            lesson.setVideo_url(((Lesson)allLessons.get(0)).getVideo_url());
            lesson.setStatus("HAS_NEXT_LESSON");
            return new ResponseEntity((Object)lesson, HttpStatus.OK);
        }
        for (Lesson lesson2 : allLessons) {
        }
        for (Lesson lesson3 : completedLessons) {
        }
        int highest_lesson = 0;
        for (Object l : allLessons) {
            if (l.getLesson_index() <= highest_lesson) continue;
            highest_lesson = l.getLesson_index();
        }
        boolean bl = false;
        for (Lesson l : completedLessons) {
            if (l.getLesson_index() <= n) continue;
            n = l.getLesson_index();
        }
        if (highest_lesson == n) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Hurray, you have completed all lessons!!");
        }
        boolean isLessonIndexNotFound = true;
        for (Lesson l : allLessons) {
            if (l.getLesson_index() != n + 1) continue;
            isLessonIndexNotFound = false;
            lesson.setLesson_id(l.getLesson_id());
            lesson.setGrade_id(l.getGrade_id());
            lesson.setGuide_post_text(l.getGuide_post_text());
            lesson.setLesson_index(l.getLesson_index());
            lesson.setTest_id(l.getTest_id());
            lesson.setVideo_url(l.getVideo_url());
            lesson.setStatus("HAS_NEXT_LESSON");
        }
        if (isLessonIndexNotFound) {
            lesson.setLesson_id(((Lesson)allLessons.get(0)).getLesson_id());
            lesson.setGrade_id(((Lesson)allLessons.get(0)).getGrade_id());
            lesson.setGuide_post_text(((Lesson)allLessons.get(0)).getGuide_post_text());
            lesson.setLesson_index(((Lesson)allLessons.get(0)).getLesson_index());
            lesson.setTest_id(((Lesson)allLessons.get(0)).getTest_id());
            lesson.setVideo_url(((Lesson)allLessons.get(0)).getVideo_url());
            lesson.setStatus("HAS_NEXT_LESSON");
        }
        return new ResponseEntity((Object)lesson, HttpStatus.OK);
    }

    @GetMapping(value={"/set-video-duration-in-lessons-in-seconds"})
    public ResponseEntity<List<Lesson>> setVideoDurationInLessonsInSe() {
        List allLessons = this.lessonRepository.findAll();
        for (Lesson l : allLessons) {
            long duration = this.getYouTubeVideoDurationInSeconds(l.getVideo_url());
            l.setVideo_duration(duration);
            this.lessonRepository.save((Object)l);
        }
        return new ResponseEntity((Object)allLessons, HttpStatus.OK);
    }

    public Long getYouTubeVideoDurationInSeconds(String video_url) {
        String video_id = this.getVideoIdFromUrl(video_url);
        Long duration = 0L;
        try {
            YouTubeVideoDetails youTubeVideoDetails = this.youTubeService.getYouTubeVideoDetailsByVideoId(video_id);
            String youTubeVideDuration = ((YouTubeVideoDetailsItem)youTubeVideoDetails.getItems().get(0)).getContentDetails().getDuration();
            duration = YouTubeDurationUtils.convertYouTubeDurationInSeconds((String)youTubeVideDuration);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return duration;
    }

    public String getVideoIdFromUrl(String video_url) {
        video_url = video_url.trim();
        String video_id = "error";
        String pattern = "(?<=watch\\?v=|/videos/|embed\\/|youtu.be\\/|\\/v\\/|\\/e\\/|watch\\?v%3D|watch\\?feature=player_embedded&v=|%2Fvideos%2F|embed%\u200c\u200b2F|youtu.be%2F|%2Fv%2F)[^#\\&\\?\\n]*";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(video_url);
        if (matcher.find()) {
            video_id = matcher.group();
        }
        return video_id;
    }
}

