/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.moods;

import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.moods.Mood;
import com.infinite.focus.server.moods.MoodRepository;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/mood"})
public class MoodController {
    @Value(value="${app.api-base-url}")
    private String apiBaseUrl;
    @Autowired
    MoodRepository moodRepository;

    @PostMapping(value={"/fill-mood-data"})
    @ResponseBody
    public ResponseEntity<List<Mood>> fillMoodData(@RequestHeader(value="Authorization") String token) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)this.moodRepository.saveAll((Iterable)this.getMoodList()), HttpStatus.OK);
    }

    @PostMapping(value={"/create/mood"})
    @ResponseBody
    public ResponseEntity<Mood> createMood(@RequestHeader(value="Authorization") String token, @RequestBody Mood request) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)((Mood)this.moodRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/mood"})
    @ResponseBody
    public ResponseEntity<Mood> updateMood(@RequestHeader(value="Authorization") String token, @RequestBody Mood request) {
        AuthenticationController.isAuthenticated((String)token);
        Mood mood = (Mood)this.moodRepository.getOne((Object)request.getMood_id());
        mood.setAnimated_image(request.getAnimated_image());
        mood.setImage(request.getImage());
        mood.setMood(request.getMood());
        mood.setWeight(request.getWeight());
        mood.setCreatedAt(mood.getCreatedAt());
        mood.setUpdateAt(new Date());
        return new ResponseEntity((Object)((Mood)this.moodRepository.save((Object)mood)), HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/mood/{mood_id}"})
    public ResponseEntity<Message> deleteMood(@RequestHeader(value="Authorization") String token, @PathVariable(value="mood_id") Long mood_id) {
        AuthenticationController.isAuthenticated((String)token);
        Mood content = (Mood)this.moodRepository.getOne((Object)mood_id);
        if (content == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The Mood not found!");
        }
        this.moodRepository.deleteById((Object)mood_id);
        Message message = new Message();
        message.setMessage("The Mood is deleted successfully.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }

    public LinkedList<Mood> getMoodList() {
        LinkedList<Mood> moods = new LinkedList<Mood>();
        Mood mood = new Mood();
        mood.setMood("Sad");
        mood.setWeight(8.3);
        mood.setAnimated_image(this.apiBaseUrl + "/images/gifs/Sad.gif");
        moods.add(mood);
        Mood mood2 = new Mood();
        mood2.setMood("Angry");
        mood2.setWeight(8.3);
        mood2.setAnimated_image(this.apiBaseUrl + "/images/gifs/Angry.gif");
        moods.add(mood2);
        Mood mood3 = new Mood();
        mood3.setMood("Scared");
        mood3.setWeight(8.3);
        mood3.setAnimated_image(this.apiBaseUrl + "/images/gifs/Scared.gif");
        moods.add(mood3);
        Mood mood4 = new Mood();
        mood4.setMood("Meh");
        mood4.setWeight(16.6);
        mood4.setAnimated_image(this.apiBaseUrl + "/images/gifs/Meh.gif");
        moods.add(mood4);
        Mood mood5 = new Mood();
        mood5.setMood("Shy");
        mood5.setWeight(16.6);
        mood5.setAnimated_image(this.apiBaseUrl + "/images/gifs/Shy.gif");
        moods.add(mood5);
        Mood mood6 = new Mood();
        mood6.setMood("Unmotivated");
        mood6.setWeight(16.6);
        mood6.setAnimated_image(this.apiBaseUrl + "/images/gifs/Unmotivated.gif");
        moods.add(mood6);
        Mood mood7 = new Mood();
        mood7.setMood("Happy");
        mood7.setWeight(25.0);
        mood7.setAnimated_image(this.apiBaseUrl + "/images/gifs/Happy.gif");
        moods.add(mood7);
        Mood mood8 = new Mood();
        mood8.setMood("Exited");
        mood8.setWeight(25.0);
        mood8.setAnimated_image(this.apiBaseUrl + "/images/gifs/Exited.gif");
        moods.add(mood8);
        Mood mood9 = new Mood();
        mood9.setMood("Hopeful");
        mood9.setWeight(25.0);
        mood9.setAnimated_image(this.apiBaseUrl + "/images/gifs/Hopeful.gif");
        moods.add(mood9);
        return moods;
    }
}

