/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.resourcelibrary;

import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.categories.Category;
import com.infinite.focus.server.categories.CategoryRepository;
import com.infinite.focus.server.contents.Content;
import com.infinite.focus.server.contents.ContentRepository;
import com.infinite.focus.server.moods.Mood;
import com.infinite.focus.server.moods.MoodRepository;
import com.infinite.focus.server.resourcelibrary.Post;
import com.infinite.focus.server.resourcelibrary.PostRepository;
import com.infinite.focus.server.resourcelibrary.PostType;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.vimeo.VimeoService;
import com.infinite.focus.server.vimeo.VimeoVideoDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/post"})
public class PostController {
    @Autowired
    PostRepository postRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    ContentRepository contentRepository;
    @Autowired
    MoodRepository moodRepository;
    @Autowired
    VimeoService vimeoService;
    @Autowired
    EntityManager entityManager;
    private static final Pattern VIMEO_PATTERN = Pattern.compile("[http|https]+:\\/\\/(?:www\\.|)vimeo\\.com\\/([a-zA-Z0-9_\\-]+)(&.+)?", 2);

    @PostMapping(value={"/create/post"})
    @ResponseBody
    public ResponseEntity<Post> createPost(@RequestHeader(value="Authorization") String token, @RequestParam(value="post_title") String post_title, @RequestParam(value="post_description") String post_description, @RequestParam(required=false, value="post_cover_image_url") String post_cover_image_url, @RequestParam(required=false, value="post_duration") String post_duration, @RequestParam(required=false, value="post_video_url") String post_video_url, @RequestParam(value="post_type") PostType post_type, @RequestParam(value="categories") String categories, @RequestParam(value="contents") String contents, @RequestParam(value="moods") String moods) {
        AuthenticationController.isAuthenticated((String)token);
        Post requestPost = new Post();
        requestPost.setPost_title(post_title);
        requestPost.setPost_description(post_description);
        requestPost.setPost_cover_image_url(post_cover_image_url);
        requestPost.setPost_description(post_description);
        requestPost.setPost_video_url(post_video_url);
        requestPost.setPost_type(post_type);
        if (requestPost.getPost_type().equals((Object)PostType.VIDEO)) {
            String url = post_video_url.trim();
            System.out.println("Vimeo Video Url - " + url);
            Long video_id = PostController.getVimeoVideoId((String)url);
            System.out.println("Vimeo Video Id - " + video_id);
            if (video_id != null) {
                try {
                    VimeoVideoDetails vimeoVideoDetails = this.vimeoService.getVimeoVideoDetailsByVideoId(video_id);
                    requestPost.setPost_cover_image_url(vimeoVideoDetails.getThumbnail_large());
                    requestPost.setPost_duration(vimeoVideoDetails.getDuration());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Post post = (Post)this.postRepository.save((Object)requestPost);
        List<String> categoryIds = Arrays.asList(categories.split("\\s*,\\s*"));
        for (String string : categoryIds) {
            Category category = this.categoryRepository.findByCategoryId(Long.valueOf(string));
            post.getCategories().add(category);
        }
        List<String> contentIds = Arrays.asList(contents.split("\\s*,\\s*"));
        for (String contentId : contentIds) {
            Content content = this.contentRepository.findByContentId(Long.valueOf(contentId));
            post.getContents().add(content);
        }
        List<String> list = Arrays.asList(moods.split("\\s*,\\s*"));
        for (String moodId : list) {
            Mood mood = this.moodRepository.findByMoodId(Long.valueOf(moodId));
            post.getMoods().add(mood);
        }
        return new ResponseEntity((Object)((Post)this.postRepository.save((Object)post)), HttpStatus.OK);
    }

    public static long getVimeoVideoId(@NonNull String url) {
        Matcher vimeo = VIMEO_PATTERN.matcher(url);
        if (!vimeo.find()) {
            return -1L;
        }
        return Long.valueOf(vimeo.group(1));
    }

    @GetMapping(value={"/get/posts"})
    public ResponseEntity<Page<Post>> getPosts(@RequestHeader(value="Authorization") String token, @RequestParam(value="post_title", defaultValue="") String post_title, @RequestParam(value="post_types", defaultValue="") String post_types, @RequestParam(value="categories", defaultValue="") String categories, @RequestParam(value="contents", defaultValue="") String contents, @RequestParam(value="moods", defaultValue="") String moods, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="post_id") String sortBy, @RequestParam(value="orderBy", defaultValue="desc") String orderBy) {
        List moodIds;
        List contentIds;
        List categoryIds;
        AuthenticationController.isAuthenticated((String)token);
        ArrayList<PostType> postTypes = new ArrayList<PostType>();
        for (String post_type : Arrays.asList(post_types.split("\\s*,\\s*"))) {
            if (post_type.equals(PostType.ARTICLE.toString())) {
                postTypes.add(PostType.ARTICLE);
            }
            if (!post_type.equals(PostType.VIDEO.toString())) continue;
            postTypes.add(PostType.VIDEO);
        }
        CriteriaBuilder qb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = qb.createQuery(Post.class);
        Root postRoot = query.from(Post.class);
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (AppUtils.isNotNullOrEmpty((String)post_title)) {
            predicates.add(qb.like(qb.lower((Expression)postRoot.get("post_title")), "%" + post_title.toLowerCase() + "%"));
        }
        if (AppUtils.isNotNullOrEmpty(postTypes)) {
            CriteriaBuilder.In postTypePredicate = qb.in((Expression)postRoot.get("post_type")).value(postTypes);
            predicates.add(postTypePredicate);
        }
        if (AppUtils.isNotNullOrEmpty((List)(categoryIds = AppUtils.convertCommaSeparatedStringIdsToLongIds((String)categories)))) {
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Root sqRoot = sq.correlate(postRoot);
            Join sqJoin = sqRoot.join("categories");
            sq.where((Expression)sqJoin.get("category_id").in((Collection)categoryIds));
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        if (AppUtils.isNotNullOrEmpty((List)(contentIds = AppUtils.convertCommaSeparatedStringIdsToLongIds((String)contents)))) {
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Root sqRoot = sq.correlate(postRoot);
            Join sqJoin = sqRoot.join("contents");
            sq.where((Expression)sqJoin.get("content_id").in((Collection)contentIds));
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        if (AppUtils.isNotNullOrEmpty((List)(moodIds = AppUtils.convertCommaSeparatedStringIdsToLongIds((String)moods)))) {
            Subquery sq = query.subquery(Long.class).select(qb.literal((Object)1L));
            Root sqRoot = sq.correlate(postRoot);
            Join sqJoin = sqRoot.join("moods");
            sq.where((Expression)sqJoin.get("mood_id").in((Collection)moodIds));
            predicates.add(qb.and(new Predicate[]{qb.exists(sq)}));
        }
        query.where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        if (orderBy.equals("desc")) {
            query.orderBy(new Order[]{qb.desc((Expression)postRoot.get(sortBy))});
        } else {
            query.orderBy(new Order[]{qb.asc((Expression)postRoot.get(sortBy))});
        }
        PageRequest pageable = PageRequest.of((int)pageNo, (int)pageSize, (Sort)(orderBy.equals("desc") ? Sort.by((String[])new String[]{sortBy}).descending() : Sort.by((String[])new String[]{sortBy}).ascending()));
        List result = this.entityManager.createQuery(query).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = qb.createQuery(Long.class);
        Root booksRootCount = countQuery.from(Post.class);
        countQuery.select((Selection)qb.count((Expression)booksRootCount)).where((Expression)qb.and(predicates.toArray(new Predicate[predicates.size()])));
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        PageImpl pagedResult = new PageImpl(result, (Pageable)pageable, count.longValue());
        return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }
}

