/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.standard;

import com.infinite.focus.server.auth.AccessCodeRepository;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.AuthenticationController;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.EmailSenderService;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.standard.Standard;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import java.util.Date;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/standard"})
public class StandardController {
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private ClassRepository classRepository;
    private AccessCodeRepository accessCodeRepository;
    private EmailSenderService emailSenderService;
    private StandardRepository standardRepository;

    public StandardController(ClassRepository classRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder, AccessCodeRepository accessCodeRepository, EmailSenderService emailSenderService, StandardRepository standardRepository) {
        this.classRepository = classRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
        this.accessCodeRepository = accessCodeRepository;
        this.emailSenderService = emailSenderService;
        this.standardRepository = standardRepository;
    }

    @GetMapping(value={"/get/standards"})
    public ResponseEntity<List<Standard>> getStandards() {
        return new ResponseEntity((Object)this.standardRepository.findAll(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/standard/{standard_id}"})
    public ResponseEntity<Standard> getStandardById(@PathVariable(value="standard_id") Long standard_id) {
        Standard standard = (Standard)this.standardRepository.getOne((Object)standard_id);
        if (standard == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The standard not found.");
        }
        return new ResponseEntity((Object)standard, HttpStatus.OK);
    }

    @PostMapping(value={"/create/standard"})
    @ResponseBody
    public ResponseEntity<Standard> createDailyQuote(@RequestHeader(value="Authorization") String token, @RequestBody Standard request) {
        AuthenticationController.isAuthenticated((String)token);
        return new ResponseEntity((Object)((Standard)this.standardRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/standard"})
    @ResponseBody
    public ResponseEntity<Standard> updateStandard(@RequestHeader(value="Authorization") String token, @RequestBody Standard request) {
        AuthenticationController.isAuthenticated((String)token);
        Standard standard = (Standard)this.standardRepository.getOne((Object)request.getStandard_id());
        standard.setStandard_name(request.getStandard_name());
        standard.setGrade_type(request.getGrade_type());
        standard.setCreatedAt(standard.getCreatedAt());
        standard.setUpdateAt(new Date());
        return new ResponseEntity((Object)((Standard)this.standardRepository.save((Object)standard)), HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/standard/{standard_id}"})
    public ResponseEntity<Message> deleteQuote(@RequestHeader(value="Authorization") String token, @PathVariable(value="standard_id") Long standard_id) {
        AuthenticationController.isAuthenticated((String)token);
        Standard standard = (Standard)this.standardRepository.getOne((Object)standard_id);
        if (standard == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The standard not found!");
        }
        this.standardRepository.deleteById((Object)standard_id);
        Message message = new Message();
        message.setMessage("The Standard is deleted successfully.");
        return new ResponseEntity((Object)message, HttpStatus.OK);
    }
}

