/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.students;

import com.infinite.focus.server.auth.AccessCode;
import com.infinite.focus.server.auth.AccessCodeRepository;
import com.infinite.focus.server.auth.Account;
import com.infinite.focus.server.auth.AccountRepository;
import com.infinite.focus.server.auth.Avatar;
import com.infinite.focus.server.auth.AvatarRepository;
import com.infinite.focus.server.auth.Instructor;
import com.infinite.focus.server.auth.InstructorRepository;
import com.infinite.focus.server.auth.Message;
import com.infinite.focus.server.auth.NotFoundException;
import com.infinite.focus.server.auth.Status;
import com.infinite.focus.server.auth.Student;
import com.infinite.focus.server.auth.StudentRepository;
import com.infinite.focus.server.auth.service.AuthService;
import com.infinite.focus.server.fcm.StudentPushNotification;
import com.infinite.focus.server.fcm.StudentPushNotificationRepository;
import com.infinite.focus.server.home.DailyAppreciationRepository;
import com.infinite.focus.server.home.MoodUpdateRepository;
import com.infinite.focus.server.home.QuoteRepository;
import com.infinite.focus.server.standard.Standard;
import com.infinite.focus.server.standard.StandardRepository;
import com.infinite.focus.server.students.Class;
import com.infinite.focus.server.students.ClassRepository;
import com.infinite.focus.server.students.SearchStudentRequest;
import com.infinite.focus.server.students.StudentClassWrapper;
import com.infinite.focus.server.students.StudentPagingAndSortingRepository;
import com.infinite.focus.server.students.service.StudentService;
import com.infinite.focus.server.utils.AppUtils;
import com.infinite.focus.server.utils.DateUtils;
import com.infinite.focus.server.wall.WallPostAttachmentRepository;
import com.infinite.focus.server.wall.WallPostRepository;
import com.infinite.focus.server.wall.WallPostRequestRepository;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@CrossOrigin(origins={"http://localhost:8383"})
@RestController
@RequestMapping(value={"api/student"})
public class StudentController {
    @Autowired
    AuthService authService;
    @Autowired
    StudentService studentService;
    private AccountRepository accountRepository;
    private StudentRepository studentRepository;
    private StudentPagingAndSortingRepository studentPagingAndSortingRepository;
    private InstructorRepository instructorRepository;
    private AvatarRepository avatarRepository;
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    private WallPostRepository wallPostRepository;
    private WallPostAttachmentRepository wallPostAttachmentRepository;
    private WallPostRequestRepository wallPostRequestRepository;
    private QuoteRepository qouteRepository;
    private MoodUpdateRepository moodUpdateRepository;
    private DailyAppreciationRepository dailyAppreciationRepository;
    private ClassRepository classRepository;
    private AccessCodeRepository accessCodeRepository;
    private StandardRepository standardRepository;
    private StudentPushNotificationRepository studentPushNotificationRepository;

    public StudentController(ClassRepository classRepository, DailyAppreciationRepository dailyAppreciationRepository, MoodUpdateRepository moodUpdateRepository, QuoteRepository qouteRepository, WallPostRepository wallPostRepository, WallPostAttachmentRepository wallPostAttachmentRepository, WallPostRequestRepository wallPostRequestRepository, AvatarRepository avatarRepository, InstructorRepository instructorRepository, StudentRepository studentRepository, AccountRepository accountRepository, BCryptPasswordEncoder bCryptPasswordEncoder, AccessCodeRepository accessCodeRepository, StudentPushNotificationRepository studentPushNotificationRepository, StudentPagingAndSortingRepository studentPagingAndSortingRepository, StandardRepository standardRepository) {
        this.classRepository = classRepository;
        this.qouteRepository = qouteRepository;
        this.wallPostRepository = wallPostRepository;
        this.wallPostAttachmentRepository = wallPostAttachmentRepository;
        this.wallPostRequestRepository = wallPostRequestRepository;
        this.avatarRepository = avatarRepository;
        this.bCryptPasswordEncoder = bCryptPasswordEncoder;
        this.instructorRepository = instructorRepository;
        this.studentRepository = studentRepository;
        this.accountRepository = accountRepository;
        this.moodUpdateRepository = moodUpdateRepository;
        this.dailyAppreciationRepository = dailyAppreciationRepository;
        this.accessCodeRepository = accessCodeRepository;
        this.studentPushNotificationRepository = studentPushNotificationRepository;
        this.studentPagingAndSortingRepository = studentPagingAndSortingRepository;
        this.standardRepository = standardRepository;
    }

    @GetMapping(value={"/get/count"})
    public ResponseEntity<Long> getCount() {
        return new ResponseEntity((Object)this.studentRepository.count(), HttpStatus.OK);
    }

    @GetMapping(value={"/get/student"})
    public ResponseEntity<Student> getStudent(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student s = new Student();
        Student z = (Student)this.studentRepository.getOne((Object)student_id);
        s.setFirst_name(z.getFirst_name());
        s.setLast_name(z.getLast_name());
        s.setAvatar(z.getAvatar());
        s.setIsVerified(true);
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @GetMapping(value={"/get/profile"})
    public ResponseEntity<Student> getStudentProfile(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        if (s == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The Student is not found!!!");
        }
        return new ResponseEntity((Object)s, HttpStatus.OK);
    }

    @GetMapping(value={"/get/class"})
    public ResponseEntity<Class> getClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        Class c = (Class)this.classRepository.getOne((Object)class_id);
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)c, HttpStatus.OK);
    }

    @GetMapping(value={"/get/students/by/class"})
    public ResponseEntity<List<Student>> getStudentByClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        return new ResponseEntity((Object)this.studentRepository.findByClassId(class_id), HttpStatus.OK);
    }

    @PostMapping(value={"/search/students/by/instructor/and/demographic"})
    public ResponseEntity<List<StudentClassWrapper>> searchStudentByInstructorAndDemographic(@RequestHeader(value="Authorization") String token, @RequestBody SearchStudentRequest searchStudentRequest) {
        Instructor i = this.authService.isInstructor(token);
        if (i == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The instructor is not found.");
        }
        ArrayList<StudentClassWrapper> list = new ArrayList<StudentClassWrapper>();
        for (Student s : this.studentService.searchStudentByInstructorAndDemographic(i, searchStudentRequest)) {
            if (s.getStatus() == null || s.getStatus() == Status.PENDING) continue;
            StudentClassWrapper w = new StudentClassWrapper();
            w.setStudent(s);
            if (this.classRepository.existsById((Object)s.getClass_id())) {
                w.setParent_class((Class)this.classRepository.getOne((Object)s.getClass_id()));
            } else {
                Class c = new Class();
                c.setClass_id(0L);
                c.setClass_name("");
                w.setParent_class(c);
            }
            list.add(w);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/students/by/instructor"})
    public ResponseEntity<List<StudentClassWrapper>> getStudentByInstructor(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        ArrayList<StudentClassWrapper> list = new ArrayList<StudentClassWrapper>();
        for (Student s : this.studentRepository.findByInstructorId(instructor_id)) {
            if (s.getStatus() == null || s.getStatus() == Status.PENDING) continue;
            StudentClassWrapper w = new StudentClassWrapper();
            w.setStudent(s);
            if (this.classRepository.existsById((Object)s.getClass_id())) {
                w.setParent_class((Class)this.classRepository.getOne((Object)s.getClass_id()));
            } else {
                Class c = new Class();
                c.setClass_id(0L);
                c.setClass_name("");
                w.setParent_class(c);
            }
            list.add(w);
        }
        return new ResponseEntity(list, HttpStatus.OK);
    }

    @GetMapping(value={"/get/classes/by/instructor"})
    public ResponseEntity<List<Class>> getClassesByInstructor(@RequestParam(value="instructor_id", defaultValue="aEn24") Long instructor_id) {
        return new ResponseEntity((Object)this.classRepository.findByInstructorId(instructor_id), HttpStatus.OK);
    }

    @PostMapping(value={"/create/class"})
    @ResponseBody
    public ResponseEntity<Class> createClass(@RequestBody Class request) {
        Class exist_class = this.classRepository.findByClassNameAndInstructorId(request.getClass_name(), Long.valueOf(request.getInstructor_id()));
        if (exist_class != null) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The class is already exist.");
        }
        return new ResponseEntity((Object)((Class)this.classRepository.save((Object)request)), HttpStatus.OK);
    }

    @PostMapping(value={"/update/class"})
    @ResponseBody
    public ResponseEntity<Class> updateClass(@RequestBody Class request) {
        Class exist_class = this.classRepository.findByClassNameAndInstructorId(request.getClass_name(), Long.valueOf(request.getInstructor_id()));
        if (exist_class != null && exist_class.getClass_id() != request.getClass_id()) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The class is already exist.");
        }
        Class c = (Class)this.classRepository.getOne((Object)request.getClass_id());
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        c.setClass_name(request.getClass_name());
        c.setInstructor_id(request.getInstructor_id());
        c.setCreatedAt(c.getCreatedAt());
        return new ResponseEntity((Object)((Class)this.classRepository.save((Object)c)), HttpStatus.OK);
    }

    @GetMapping(value={"/delete/class"})
    public ResponseEntity<Class> deleteClass(@RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        Class c = (Class)this.classRepository.getOne((Object)class_id);
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        this.classRepository.delete((Object)c);
        return new ResponseEntity((Object)c, HttpStatus.OK);
    }

    @GetMapping(value={"/add/student/to/class"})
    public ResponseEntity<Student> addStudentToClass(@RequestParam(value="student_id", defaultValue="aEn24") Long student_id, @RequestParam(value="class_id", defaultValue="aEn24") Long class_id) {
        Student s = (Student)this.studentRepository.getOne((Object)student_id);
        if (s == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Class c = (Class)this.classRepository.getOne((Object)class_id);
        if (c == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        s.setClass_id(c.getClass_id());
        return new ResponseEntity((Object)((Student)this.studentRepository.save((Object)s)), HttpStatus.OK);
    }

    @PostMapping(value={"/verify-access-code"})
    public ResponseEntity<Student> verifyAccessCodeStudent(@RequestParam(value="student_id") long student_id, @RequestParam(value="access_code") String access_code) {
        AccessCode accessCode = this.accessCodeRepository.findByAccessCode(access_code);
        if (accessCode != null) {
            if (accessCode.getStudent().getStudent_id() == student_id) {
                if (accessCode.getStatus() == Status.ACCEPTED) {
                    Student student = accessCode.getStudent();
                    student.setIsVerified(true);
                    this.studentRepository.save((Object)student);
                    return new ResponseEntity((Object)student, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.UNAUTHORIZED);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/set/fcm/token"})
    public ResponseEntity<Message> setFCMToken(@RequestHeader(value="Authorization") String token, @RequestParam(value="fcm_token") String fcm_token) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account a = this.accountRepository.findByUsername(user);
            if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            Student student = this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
            if (student == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The User is not a Student!!!");
            }
            student.setFcm_token(fcm_token);
            this.studentRepository.save((Object)student);
            Message message = new Message("The fcm_token setted.");
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        throw new NotFoundException("User not found!!!");
    }

    @GetMapping(value={"/get/notifications"})
    public ResponseEntity<Page<StudentPushNotification>> getNotificationsByStudentId(@RequestHeader(value="Authorization") String token, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="student_push_notification_id") String sortBy, @RequestParam(value="status", defaultValue="PENDING") String status) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account a = this.accountRepository.findByUsername(user);
            if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            Student student = this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
            if (student == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The User is not a Student!!!");
            }
            PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)Sort.by((String[])new String[]{sortBy}).descending());
            Page pagedResult = this.studentPushNotificationRepository.findByStudentId(Long.valueOf(student.getStudent_id()), (Pageable)paging);
            return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
        }
        throw new NotFoundException("User not found!!!");
    }

    @GetMapping(value={"/get/students"})
    public ResponseEntity<Page<Student>> getStudents(@RequestHeader(value="Authorization") String token, @RequestParam(value="name", defaultValue="") String name, @RequestParam(value="pageNo", defaultValue="0") Integer pageNo, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="sortBy", defaultValue="student_id") String sortBy) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account a = this.accountRepository.findByUsername(user);
            if (a == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            PageRequest paging = PageRequest.of((int)pageNo, (int)pageSize, (Sort)Sort.by((String[])new String[]{sortBy}).ascending());
            Page pagedResult = null;
            pagedResult = name == null || name.isEmpty() ? this.studentPagingAndSortingRepository.findAllStudents((Pageable)paging) : this.studentPagingAndSortingRepository.findByStudentByName(name, (Pageable)paging);
            return new ResponseEntity((Object)pagedResult, (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
        }
        throw new NotFoundException("User not found!!!");
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<Message> logout(@RequestHeader(value="Authorization") String token) {
        String user;
        if (token != null && !token.contains("undefined") && (user = ((Claims)Jwts.parser().setSigningKey("SecretKeyToGenJWTs").parseClaimsJws(token.replace("Bearer ", "")).getBody()).getSubject()) != null) {
            Account a = this.accountRepository.findByUsername(user);
            if (a == null && (a = this.accountRepository.findByUsername2(user)) == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "User not found!!!");
            }
            Student student = this.studentRepository.findByAccountId(Long.valueOf(a.getAccount_id()));
            if (student == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The User is not a Student!!!");
            }
            student.setFcm_token(null);
            this.studentRepository.save((Object)student);
            Message message = new Message("The user is logout successfully.");
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        throw new NotFoundException("User not found!!!");
    }

    @PostMapping(value={"/edit/profile"})
    public ResponseEntity<Student> editProfile(@RequestHeader(value="Authorization") String token, @RequestBody Student student) {
        Instructor i = this.authService.isInstructor(token);
        if (i == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The instructor is not found.");
        }
        Student s = (Student)this.studentRepository.getOne((Object)student.getStudent_id());
        if (s == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "The Student is not found!!!");
        }
        if (AppUtils.isNullOrEmpty((String)student.getFirst_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The first name is required.");
        }
        if (AppUtils.isNullOrEmpty((String)student.getLast_name())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The last name is required.");
        }
        if (AppUtils.isNullOrEmpty((String)student.getEthnicity())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The Ethnicity is required.");
        }
        if (AppUtils.isNullOrEmpty((String)student.getGender())) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The Gender is required.");
        }
        int age = DateUtils.getAge((Date)student.getDate_of_birth());
        if (age < 4 || age > 19) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "The age must be 4-19.");
        }
        Avatar avatar = (Avatar)this.avatarRepository.getOne((Object)student.getAvatar_id());
        Standard std = (Standard)this.standardRepository.getOne((Object)student.getStandard_id());
        s.setFirst_name(student.getFirst_name());
        s.setLast_name(student.getLast_name());
        s.setAvatar(avatar);
        s.setDate_of_birth(student.getDate_of_birth());
        s.setEthnicity(student.getEthnicity());
        s.setGender(student.getGender());
        s.setGrade_id(student.getGrade_id());
        s.setStandard(std);
        Student stud = (Student)this.studentRepository.save((Object)s);
        return new ResponseEntity((Object)stud, HttpStatus.OK);
    }
}

