/*
 * Decompiled with CFR 0.152.
 */
package com.infinite.focus.server.vimeo;

import com.infinite.focus.server.vimeo.VimeoApisConfiguration;
import com.infinite.focus.server.vimeo.VimeoRepositoryInterface;
import com.infinite.focus.server.vimeo.VimeoVideoDetails;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Service
public class VimeoService
implements VimeoApisConfiguration {
    private VimeoRepositoryInterface service;

    public VimeoService() {
        Retrofit retrofit = new Retrofit.Builder().baseUrl("http://vimeo.com/").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (VimeoRepositoryInterface)retrofit.create(VimeoRepositoryInterface.class);
    }

    public VimeoVideoDetails getVimeoVideoDetailsByVideoId(Long video_id) throws IOException {
        Call retrofitCall = this.service.getVimeoVideoDetailsByVideoId(video_id);
        Response response = retrofitCall.execute();
        if (!response.isSuccessful()) {
            throw new IOException(response.errorBody() != null ? response.errorBody().string() : "Unknown error");
        }
        return (VimeoVideoDetails)((List)response.body()).get(0);
    }
}

